/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ConsumingEndpointStatisticsData;
import com.sun.esb.management.common.data.IEndpointStatisticsData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class ConsumingEndpointStatisticsDataCreator {
    static String[] STATS_TABLE_INDEX = new String[]{"InstanceName"};

    public static TabularData createTabularData(Map<String, IEndpointStatisticsData> map) throws ManagementRemoteException {
        Set<String> instanceNames = map.keySet();
        TabularType endpointStatsTableType = null;
        TabularDataSupport endpointsStatsTable = null;
        CompositeData[] endpointStats = new CompositeData[instanceNames.size()];
        int index = 0;
        for (String instanceName : instanceNames) {
            IEndpointStatisticsData value = map.get(instanceName);
            ConsumingEndpointStatisticsData data = (ConsumingEndpointStatisticsData)value;
            endpointStats[index++] = ConsumingEndpointStatisticsDataCreator.composeConsumingEndpointStats(data);
        }
        try {
            if (index > 0 && endpointStats[0] != null) {
                endpointStatsTableType = new TabularType("EndpointStats", "Endpoint Statistic Information", endpointStats[0].getCompositeType(), STATS_TABLE_INDEX);
                endpointsStatsTable = new TabularDataSupport(endpointStatsTableType);
                for (int innerIndex = 0; innerIndex < index; ++innerIndex) {
                    endpointsStatsTable.put(endpointStats[innerIndex]);
                }
            }
        }
        catch (OpenDataException e) {
            throw new ManagementRemoteException(e);
        }
        return endpointsStatsTable;
    }

    protected static CompositeData composeConsumingEndpointStats(ConsumingEndpointStatisticsData data) throws ManagementRemoteException {
        Object ojcStatsType = null;
        if (data.getCategoryToPerformanceDataMap() != null) {
            // empty if block
        }
        ArrayList<String> consumerItemNames = new ArrayList<String>();
        consumerItemNames.add("InstanceName");
        consumerItemNames.add("NumSentRequests");
        consumerItemNames.add("NumReceivedReplies");
        consumerItemNames.add("NumReceivedDONEs");
        consumerItemNames.add("NumSentDONEs");
        consumerItemNames.add("NumReceivedFaults");
        consumerItemNames.add("NumSentFaults");
        consumerItemNames.add("NumReceivedErrors");
        consumerItemNames.add("NumSentErrors");
        consumerItemNames.add("NumActiveExchanges");
        consumerItemNames.add("ComponentName");
        consumerItemNames.add("ME-StatusTime-Avg");
        consumerItemNames.add("ME-ComponentTime-Avg");
        consumerItemNames.add("ME-DeliveryChannelTime-Avg");
        consumerItemNames.add("ME-MessageServiceTime-Avg");
        if (ojcStatsType != null) {
            consumerItemNames.add("PerformanceMeasurements");
        }
        ArrayList<String> consumerItemDescriptions = new ArrayList<String>();
        consumerItemDescriptions.add("Instance Name");
        consumerItemDescriptions.add("Number of Sent Requests");
        consumerItemDescriptions.add("Number of Received Replies");
        consumerItemDescriptions.add("Number of Received DONEs");
        consumerItemDescriptions.add("Number of Sent DONEs");
        consumerItemDescriptions.add("Number of Received Faults");
        consumerItemDescriptions.add("Number of Sent Faults");
        consumerItemDescriptions.add("Number of Received Errors");
        consumerItemDescriptions.add("Number of Sent Errors");
        consumerItemDescriptions.add("Number of active exchanges");
        consumerItemDescriptions.add("Name of the owning component");
        consumerItemDescriptions.add("Message Exchange Status Time Avg in ns");
        consumerItemDescriptions.add("Message Exchange ComponentTime Avg in ns");
        consumerItemDescriptions.add("Message Exchange DeliveryChannelTime Avg in ns");
        consumerItemDescriptions.add("Message Exchange MessageServiceTime  Avg in ns");
        if (ojcStatsType != null) {
            consumerItemDescriptions.add("Performance Measurements recorded by OJC Components");
        }
        ArrayList<SimpleType<Object>> consumerItemTypes = new ArrayList<SimpleType<Object>>();
        consumerItemTypes.add(SimpleType.STRING);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.STRING);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        if (ojcStatsType != null) {
            consumerItemTypes.add((SimpleType<Object>)ojcStatsType);
        }
        ArrayList<Object> consumerItemValues = new ArrayList<Object>();
        consumerItemValues.add(data.getInstanceName());
        consumerItemValues.add(data.getNumberOfSentRequests());
        consumerItemValues.add(data.getNumberOfReceivedReplies());
        consumerItemValues.add(data.getNumberOfReceivedDones());
        consumerItemValues.add(data.getNumberOfSentDones());
        consumerItemValues.add(data.getNumberOfReceivedFaults());
        consumerItemValues.add(data.getNumberOfSentFaults());
        consumerItemValues.add(data.getNumberOfReceivedErrors());
        consumerItemValues.add(data.getNumberOfSentErrors());
        consumerItemValues.add(data.getNumberOfActiveExchanges());
        consumerItemValues.add(data.getComponentName());
        consumerItemValues.add(data.getMessageExchangeStatusTimeAverage());
        consumerItemValues.add(data.getMessageExchangeComponentTimeAverage());
        consumerItemValues.add(data.getMessageExchangeDeliveryChannelTimeAverage());
        consumerItemValues.add(data.getMessageExchangeServiceTimeAverage());
        if (ojcStatsType != null) {
            // empty if block
        }
        try {
            return new CompositeDataSupport(new CompositeType("ConsumerEndpointStats", "Consumer Endpoint Statistics", consumerItemNames.toArray(new String[0]), consumerItemDescriptions.toArray(new String[0]), consumerItemTypes.toArray(new SimpleType[0])), consumerItemNames.toArray(new String[0]), consumerItemValues.toArray(new Object[0]));
        }
        catch (OpenDataException ode) {
            throw new ManagementRemoteException(ode);
        }
    }

    public static void main(String[] args) {
    }
}

