/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ComponentStatisticsData;
import com.sun.esb.management.common.data.helper.ComponentStatisticsDataReader;
import com.sun.esb.management.common.data.helper.ComponentStatisticsDataXMLConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ComponentStatisticsDataWriter
implements ComponentStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    static final String FILE_NAME_KEY = "ComponentStatisticsData.xml";

    public static void writeToFile(Document document, String directoryPath) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(directoryPath);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + directoryPath + " is invalid.");
        }
        String fileLocation = file.getAbsolutePath() + File.separator + FILE_NAME_KEY;
        System.out.println("Writing out to file: " + fileLocation);
        File outputFile = new File(fileLocation);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputFile);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            aFile.createNewFile();
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static String serialize(Map<String, ComponentStatisticsData> dataMap) throws ParserConfigurationException, TransformerException {
        Document document = null;
        ComponentStatisticsDataWriter writer = new ComponentStatisticsDataWriter();
        if (dataMap != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("ComponentStatisticsDataList");
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/ComponentStatisticsDataList");
            root.setAttribute("version", "1.0");
            for (String instanceName : dataMap.keySet()) {
                ComponentStatisticsData data = dataMap.get(instanceName);
                Element componentStatisticsDataElementChild = writer.createComponentStatisticsDataElement(document, data);
                root.appendChild(componentStatisticsDataElementChild);
            }
            document.appendChild(root);
        }
        return writer.writeToString(document);
    }

    protected Element createComponentStatisticsDataElement(Document document, ComponentStatisticsData data) {
        Element componentStatisticsDataElement = null;
        if (document != null && data != null) {
            componentStatisticsDataElement = document.createElement("ComponentStatisticsData");
            Element instanceNameElementChild = document.createElement("InstanceName");
            if (instanceNameElementChild != null) {
                instanceNameElementChild.setTextContent(data.getInstanceName());
            }
            componentStatisticsDataElement.appendChild(instanceNameElementChild);
            Element upTimeElementChild = document.createElement("ComponentUpTime");
            if (upTimeElementChild != null) {
                upTimeElementChild.setTextContent(data.getComponentUpTime() + "");
            }
            componentStatisticsDataElement.appendChild(upTimeElementChild);
            Element activatedEndpointsElementChild = document.createElement("NumberOfActivatedEndpoints");
            if (activatedEndpointsElementChild != null) {
                activatedEndpointsElementChild.setTextContent(data.getNumberOfActivatedEndpoints() + "");
            }
            componentStatisticsDataElement.appendChild(activatedEndpointsElementChild);
            Element receivedRequestsElementChild = document.createElement("NumberOfReceivedRequests");
            if (receivedRequestsElementChild != null) {
                receivedRequestsElementChild.setTextContent(data.getNumberOfReceivedRequests() + "");
            }
            componentStatisticsDataElement.appendChild(receivedRequestsElementChild);
            Element sentRequestsElementChild = document.createElement("NumberOfSentRequests");
            if (sentRequestsElementChild != null) {
                sentRequestsElementChild.setTextContent(data.getNumberOfSentRequests() + "");
            }
            componentStatisticsDataElement.appendChild(sentRequestsElementChild);
            Element receivedRepliesElementChild = document.createElement("NumberOfReceivedReplies");
            if (receivedRepliesElementChild != null) {
                receivedRepliesElementChild.setTextContent(data.getNumberOfReceivedReplies() + "");
            }
            componentStatisticsDataElement.appendChild(receivedRepliesElementChild);
            Element sentRepliesElementChild = document.createElement("NumberOfSentReplies");
            if (sentRepliesElementChild != null) {
                sentRepliesElementChild.setTextContent(data.getNumberOfSentReplies() + "");
            }
            componentStatisticsDataElement.appendChild(sentRepliesElementChild);
            Element receivedDonesElementChild = document.createElement("NumberOfReceivedDones");
            if (receivedDonesElementChild != null) {
                receivedDonesElementChild.setTextContent(data.getNumberOfReceivedDones() + "");
            }
            componentStatisticsDataElement.appendChild(receivedDonesElementChild);
            Element sentDonesElementChild = document.createElement("NumberOfSentDones");
            if (sentDonesElementChild != null) {
                sentDonesElementChild.setTextContent(data.getNumberOfSentDones() + "");
            }
            componentStatisticsDataElement.appendChild(sentDonesElementChild);
            Element receivedFaultsElementChild = document.createElement("NumberOfReceivedFaults");
            if (receivedFaultsElementChild != null) {
                receivedFaultsElementChild.setTextContent(data.getNumberOfReceivedFaults() + "");
            }
            componentStatisticsDataElement.appendChild(receivedFaultsElementChild);
            Element sentFaultsElementChild = document.createElement("NumberOfSentFaults");
            if (sentFaultsElementChild != null) {
                sentFaultsElementChild.setTextContent(data.getNumberOfSentFaults() + "");
            }
            componentStatisticsDataElement.appendChild(sentFaultsElementChild);
            Element receivedErrorsElementChild = document.createElement("NumberOfReceivedErrors");
            if (receivedErrorsElementChild != null) {
                receivedErrorsElementChild.setTextContent(data.getNumberOfReceivedErrors() + "");
            }
            componentStatisticsDataElement.appendChild(receivedErrorsElementChild);
            Element sentErrorsElementChild = document.createElement("NumberOfSentErrors");
            if (sentErrorsElementChild != null) {
                sentErrorsElementChild.setTextContent(data.getNumberOfSentErrors() + "");
            }
            componentStatisticsDataElement.appendChild(sentErrorsElementChild);
            Element completedExchangesElementChild = document.createElement("NumberOfCompletedExchanges");
            if (completedExchangesElementChild != null) {
                completedExchangesElementChild.setTextContent(data.getNumberOfCompletedExchanges() + "");
            }
            componentStatisticsDataElement.appendChild(completedExchangesElementChild);
            Element completedActiveElementChild = document.createElement("NumberOfActiveExchanges");
            if (completedActiveElementChild != null) {
                completedActiveElementChild.setTextContent(data.getNumberOfActiveExchanges() + "");
            }
            componentStatisticsDataElement.appendChild(completedActiveElementChild);
            Element completedErrorElementChild = document.createElement("NumberOfErrorExchanges");
            if (completedErrorElementChild != null) {
                completedErrorElementChild.setTextContent(data.getNumberOfErrorExchanges() + "");
            }
            componentStatisticsDataElement.appendChild(completedErrorElementChild);
            Element extendedTimingStatisticsFlagEnabledElementChild = document.createElement("ExtendedTimingStatisticsFlagEnabled");
            if (extendedTimingStatisticsFlagEnabledElementChild != null) {
                extendedTimingStatisticsFlagEnabledElementChild.setTextContent(data.isExtendedTimingStatisticsFlagEnabled() + "");
            }
            componentStatisticsDataElement.appendChild(extendedTimingStatisticsFlagEnabledElementChild);
            Element responseTimeAverageElementChild = document.createElement("MessageExchangeResponseTimeAverage");
            if (responseTimeAverageElementChild != null) {
                responseTimeAverageElementChild.setTextContent(data.getMessageExchangeResponseTimeAverage() + "");
            }
            componentStatisticsDataElement.appendChild(responseTimeAverageElementChild);
            Element componentTimeAverageElementChild = document.createElement("MessageExchangeComponentTimeAverage");
            if (componentTimeAverageElementChild != null) {
                componentTimeAverageElementChild.setTextContent(data.getMessageExchangeComponentTimeAverage() + "");
            }
            componentStatisticsDataElement.appendChild(componentTimeAverageElementChild);
            Element deliveryChannelTimeAverageElementChild = document.createElement("MessageExchangeDeliveryChannelTimeAverage");
            if (deliveryChannelTimeAverageElementChild != null) {
                deliveryChannelTimeAverageElementChild.setTextContent(data.getMessageExchangeDeliveryChannelTimeAverage() + "");
            }
            componentStatisticsDataElement.appendChild(deliveryChannelTimeAverageElementChild);
            Element messageServiceTimeAverageElementChild = document.createElement("MessageExchangeMessageServiceTimeAverage");
            if (messageServiceTimeAverageElementChild != null) {
                messageServiceTimeAverageElementChild.setTextContent(data.getMessageExchangeMessageServiceTimeAverage() + "");
            }
            componentStatisticsDataElement.appendChild(messageServiceTimeAverageElementChild);
            Element componentExtensionStatusElementChild = document.createElement("ComponentExtensionStatus");
            if (componentExtensionStatusElementChild != null) {
                componentExtensionStatusElementChild.setTextContent(data.getComponentExtensionStatusAsString());
            }
            componentStatisticsDataElement.appendChild(componentExtensionStatusElementChild);
        }
        return componentStatisticsDataElement;
    }

    protected String writeToString(Document document) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/componentstatistics/ComponentStatisticsData.xml";
        try {
            Map<String, ComponentStatisticsData> map = null;
            map = ComponentStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
            String content = ComponentStatisticsDataWriter.serialize(map);
            System.out.println(content);
            ComponentStatisticsDataWriter.setContents(new File(uri), content);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

