/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceUnitStatisticsData
implements Serializable {
    static final long serialVersionUID = -1L;
    public static final String NAME_KEY = "ServiceUnitName";
    public static final String STARTUP_TIME_AVG_KEY = "ServiceUnitStartupTime Avg (ms)";
    public static final String STOP_TIME_AVG_KEY = "ServiceUnitStopTime Avg (ms)";
    public static final String SHUTDOWN_TIME_AVG_KEY = "ServiceUnitShutdownTime Avg (ms)";
    public static final String ENDPOINTS_KEY = "Endpoints";
    protected String name;
    protected long startupTimeAverage;
    protected long stopTimeAverage;
    protected long shutdownTimeAverage;
    protected List<String> endpointNameList = new ArrayList<String>();

    public String getName() {
        return this.name;
    }

    public void setName(String serviceUnitName) {
        this.name = serviceUnitName;
    }

    public long getStartupTimeAverage() {
        return this.startupTimeAverage;
    }

    public void setStartupTimeAverage(long serviceUnitStartTime) {
        this.startupTimeAverage = serviceUnitStartTime;
    }

    public long getStopTimeAverage() {
        return this.stopTimeAverage;
    }

    public void setStopTimeAverage(long serviceUnitStopTime) {
        this.stopTimeAverage = serviceUnitStopTime;
    }

    public long getShutdownTimeAverage() {
        return this.shutdownTimeAverage;
    }

    public void setShutdownTimeAverage(long serviceUnitShutdownTime) {
        this.shutdownTimeAverage = serviceUnitShutdownTime;
    }

    public List<String> getEndpointNameList() {
        return this.endpointNameList;
    }

    public String[] getEndpointNameArray() {
        String[] result = ServiceUnitStatisticsData.toArray(this.endpointNameList, String.class);
        return result;
    }

    public void setEndpointNameList(List<String> endpointNameList) {
        this.endpointNameList = endpointNameList;
    }

    public void setEndpointNameList(String[] endpointNameArray) {
        for (String endpointName : endpointNameArray) {
            this.endpointNameList.add(endpointName);
        }
    }

    protected static <Type> Type[] toArray(Collection<Type> collection, Class<Type> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, collection.size());
        int index = 0;
        for (Type value : collection) {
            array[index++] = value;
        }
        return array;
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n    Service Unit Name=" + this.getName());
        buffer.append("\n    Service Unit Shutdown Time=" + this.getShutdownTimeAverage());
        buffer.append("\n    Service Unit Start Time=" + this.getStartupTimeAverage());
        buffer.append("\n    Service Unit Stop Time=" + this.getStopTimeAverage());
        if (this.getEndpointNameList() != null && this.getEndpointNameList().size() > 0) {
            buffer.append("\n    Endpoints List:");
            for (String endpoint : this.getEndpointNameList()) {
                buffer.append("\n      Endpoint Name=" + endpoint);
            }
        }
        buffer.append("\n\n");
        return buffer.toString();
    }

    public static void main(String[] args) {
    }
}

