/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.EndpointInformation;
import com.sun.esb.management.common.data.JavaEEVerifierReport;
import com.sun.esb.management.common.data.helper.VerificationDataCreator;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public class ApplicationVerificationReport
implements Serializable {
    static final long serialVersionUID = -1L;
    String serviceAssemblyName;
    String serviceAssemblyDescription;
    int numberOfServiceUnits;
    boolean allComponentsInstalled;
    List<String> missingComponentsList = new ArrayList<String>();
    List<EndpointInformation> endpointInformationList = new ArrayList<EndpointInformation>();
    String templateZipId;
    List<JavaEEVerifierReport> javaEEVerifierReports = new ArrayList<JavaEEVerifierReport>();

    public ApplicationVerificationReport() {
    }

    public ApplicationVerificationReport(CompositeData compositeData) {
        ApplicationVerificationReport report = ApplicationVerificationReport.retrieveApplicationVerificationReport(compositeData);
        this.serviceAssemblyName = report.getServiceAssemblyName();
        this.serviceAssemblyDescription = report.getServiceAssemblyDescription();
        this.numberOfServiceUnits = report.getNumberOfServiceUnits();
        this.allComponentsInstalled = report.areAllComponentsInstalled();
        this.missingComponentsList = report.getMissingComponentsList();
        this.endpointInformationList = report.getEndpointInformationList();
        this.templateZipId = report.getTemplateZipId();
        this.javaEEVerifierReports = report.getJavaEEVerifierReports();
    }

    public CompositeData generateCompositeData() {
        CompositeData compositeData = null;
        try {
            compositeData = VerificationDataCreator.createCompositeData(this);
        }
        catch (ManagementRemoteException managementRemoteException) {
            // empty catch block
        }
        return compositeData;
    }

    public String getServiceAssemblyName() {
        return this.serviceAssemblyName;
    }

    public void setServiceAssemblyName(String serviceAssemblyName) {
        this.serviceAssemblyName = serviceAssemblyName;
    }

    public String getServiceAssemblyDescription() {
        return this.serviceAssemblyDescription;
    }

    public void setServiceAssemblyDescription(String serviceAssemblyDescription) {
        this.serviceAssemblyDescription = serviceAssemblyDescription;
    }

    public int getNumberOfServiceUnits() {
        return this.numberOfServiceUnits;
    }

    public void setNumberOfServiceUnits(int numberOfServiceUnits) {
        this.numberOfServiceUnits = numberOfServiceUnits;
    }

    public boolean areAllComponentsInstalled() {
        return this.allComponentsInstalled;
    }

    public void setAllComponentsInstalled(boolean allComponentsInstalled) {
        this.allComponentsInstalled = allComponentsInstalled;
    }

    public List<String> getMissingComponentsList() {
        return this.missingComponentsList;
    }

    protected static <Type> Type[] toArray(Collection<Type> collection, Class<Type> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, collection.size());
        int index = 0;
        for (Type value : collection) {
            array[index++] = value;
        }
        return array;
    }

    public String[] getMissingComponentsArray() {
        String[] result = ApplicationVerificationReport.toArray(this.missingComponentsList, String.class);
        return result;
    }

    public void setMissingComponentsList(String[] missingComponentsArray) {
        for (String componentName : missingComponentsArray) {
            this.missingComponentsList.add(componentName);
        }
    }

    public void setMissingComponentsList(List<String> missingComponentsArray) {
        this.missingComponentsList = missingComponentsArray;
    }

    public List<EndpointInformation> getEndpointInformationList() {
        return this.endpointInformationList;
    }

    public void setEndpointInformationList(EndpointInformation[] endpointInformationArray) {
        for (EndpointInformation endpointInformation : endpointInformationArray) {
            this.endpointInformationList.add(endpointInformation);
        }
    }

    public void setEndpointInformationList(List<EndpointInformation> endpointInformationArray) {
        this.endpointInformationList = endpointInformationArray;
    }

    public void setJavaEEVerifierReports(List<JavaEEVerifierReport> javaEEVerifierReports) {
        this.javaEEVerifierReports = javaEEVerifierReports;
    }

    public List<JavaEEVerifierReport> getJavaEEVerifierReports() {
        return this.javaEEVerifierReports;
    }

    public String getTemplateZipId() {
        return this.templateZipId;
    }

    public void setTemplateZipId(String templateZIPID) {
        this.templateZipId = templateZIPID;
    }

    public String getTemplateDirectory() {
        return this.templateZipId;
    }

    public void setTemplateDirectory(String templateZIPID) {
        this.templateZipId = templateZIPID;
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n  Service Assembly Name=" + this.getServiceAssemblyName());
        buffer.append("\n  Service Assembly Description=" + this.getServiceAssemblyDescription());
        buffer.append("\n  Number of Service Units=" + this.getNumberOfServiceUnits());
        buffer.append("\n  Are All Components Installed=" + this.areAllComponentsInstalled());
        buffer.append("\n  Template Directory or TemplateZipID=" + this.getTemplateDirectory());
        for (String missingComponentName : this.getMissingComponentsList()) {
            buffer.append("\n    missing component name=" + missingComponentName);
        }
        for (EndpointInformation information : this.getEndpointInformationList()) {
            buffer.append(information.getDisplayString());
        }
        for (JavaEEVerifierReport verifierReport : this.getJavaEEVerifierReports()) {
            buffer.append(verifierReport.getDisplayString());
        }
        return buffer.toString();
    }

    protected static ApplicationVerificationReport retrieveApplicationVerificationReport(CompositeData compositeData) {
        ApplicationVerificationReport report = new ApplicationVerificationReport();
        CompositeType compositeType = compositeData.getCompositeType();
        for (String item : compositeType.keySet()) {
            List<Serializable> list;
            Constable value;
            if (item.equals("ServiceAssemblyName")) {
                report.setServiceAssemblyName((String)compositeData.get(item));
            }
            if (item.equals("ServiceAssemblyDescription")) {
                report.setServiceAssemblyDescription((String)compositeData.get(item));
            }
            if (item.equals("NumServiceUnits")) {
                value = (Integer)compositeData.get(item);
                report.setNumberOfServiceUnits((Integer)value);
            }
            if (item.equals("AllComponentsInstalled")) {
                value = (Boolean)compositeData.get(item);
                report.setAllComponentsInstalled((Boolean)value);
            }
            if (item.equals("TemplateZIPID")) {
                report.setTemplateZipId((String)compositeData.get(item));
            }
            if (item.equals("MissingComponentsList")) {
                String[] missingComponentNames = (String[])compositeData.get(item);
                report.setMissingComponentsList(missingComponentNames);
            }
            if (item.equals("EndpointInfo")) {
                list = ApplicationVerificationReport.retrieveEndpointInformationList((CompositeData[])compositeData.get(item));
                report.setEndpointInformationList(list);
            }
            if (!item.equals("JavaEEVerifierReport")) continue;
            list = ApplicationVerificationReport.retrieveJavaEEVerifierReports((CompositeData[])compositeData.get(item));
            report.setJavaEEVerifierReports(list);
        }
        return report;
    }

    protected static List<EndpointInformation> retrieveEndpointInformationList(CompositeData[] compositeDataArray) {
        ArrayList<EndpointInformation> result = new ArrayList<EndpointInformation>();
        for (CompositeData compositeData : compositeDataArray) {
            EndpointInformation information = null;
            if (compositeData.values().size() <= 0) continue;
            information = new EndpointInformation();
            CompositeType compositeType = compositeData.getCompositeType();
            for (String item : compositeType.keySet()) {
                if (item.equals("EndpointName")) {
                    information.setEndpointName((String)compositeData.get(item));
                }
                if (item.equals("ServiceUnitName")) {
                    information.setServiceUnitName((String)compositeData.get(item));
                }
                if (item.equals("ComponentName")) {
                    information.setComponentName((String)compositeData.get(item));
                }
                if (item.equals("Status")) {
                    information.setStatus((String)compositeData.get(item));
                }
                if (item.equals("MissingApplicationVariables")) {
                    information.setMissingApplicationVariables((String[])compositeData.get(item));
                }
                if (!item.equals("MissingApplicationConfigurations")) continue;
                information.setMissingApplicationConfigurations((String[])compositeData.get(item));
            }
            if (information == null) continue;
            result.add(information);
        }
        return result;
    }

    protected static List<JavaEEVerifierReport> retrieveJavaEEVerifierReports(CompositeData[] compositeDataArray) {
        ArrayList<JavaEEVerifierReport> result = new ArrayList<JavaEEVerifierReport>();
        for (CompositeData compositeData : compositeDataArray) {
            JavaEEVerifierReport report = null;
            if (compositeData.values().size() <= 0) continue;
            report = new JavaEEVerifierReport();
            CompositeType compositeType = compositeData.getCompositeType();
            for (String item : compositeType.keySet()) {
                if (item.equals("ServiceUnitName")) {
                    report.setServiceUnitName((String)compositeData.get(item));
                }
                if (!item.equals("JavaEEVerifierReport")) continue;
                report.setJavaEEVerifierReport((TabularData)compositeData.get(item));
            }
            if (report == null) continue;
            result.add(report);
        }
        return result;
    }

    public CompositeType getJavaEEVerifierReportCompositeType() throws OpenDataException {
        if (this.javaEEVerifierReports != null && this.javaEEVerifierReports.size() > 0) {
            return this.javaEEVerifierReports.get(0).getCompositeType();
        }
        return null;
    }
}

