/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.base.services;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public abstract class AbstractServiceImpl
implements Serializable {
    static final long serialVersionUID = -1L;
    protected static String CANNED_RESPONSE = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><jbi-task version=\"1.0\" xmlns=\"http://java.sun.com/xml/ns/jbi/management-message\"><jbi-task-result><frmwk-task-result><frmwk-task-result-details><task-result-details><task-id>OPERATION</task-id><task-result>SUCCESS</task-result><message-type>INFO</message-type></task-result-details><locale>en</locale></frmwk-task-result-details></frmwk-task-result></jbi-task-result></jbi-task>";
    protected static I18NBundle I18NBUNDLE = null;
    protected transient MBeanServerConnection remoteConnection;
    protected boolean isRemoteConnection;

    public AbstractServiceImpl() {
        this(null, false);
    }

    public AbstractServiceImpl(MBeanServerConnection serverConnection) {
        this(serverConnection, false);
    }

    public AbstractServiceImpl(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        this.remoteConnection = serverConnection;
        this.isRemoteConnection = isRemoteConnection;
    }

    protected boolean isRemoteConnection() {
        return this.isRemoteConnection;
    }

    protected I18NBundle getI18NBundle() {
        if (I18NBUNDLE == null) {
            I18NBUNDLE = new I18NBundle("com.sun.jbi.ui.client");
        }
        return I18NBUNDLE;
    }

    protected MBeanServerConnection getMBeanServerConnection() throws IllegalStateException {
        if (this.remoteConnection == null) {
            throw new IllegalStateException("caps.management.client.jmx.connection.not.open");
        }
        return this.remoteConnection;
    }

    protected boolean isRegistered(ObjectName objectName) {
        boolean result = false;
        Boolean resultObject = null;
        try {
            resultObject = this.remoteConnection.isRegistered(objectName);
            if (resultObject != null) {
                result = resultObject;
            }
        }
        catch (IOException e) {
            result = false;
        }
        catch (RuntimeException exception) {
            result = false;
        }
        return result;
    }

    protected ObjectName getAdministrationServiceMBeanObjectName() throws ManagementRemoteException {
        try {
            return JBIJMXObjectNames.getJavaCapsAdministrationServiceMBeanObjectName();
        }
        catch (MalformedObjectNameException e) {
            throw ManagementRemoteException.filterJmxExceptions(e);
        }
    }

    protected ObjectName getConfigurationServiceMBeanObjectName() throws ManagementRemoteException {
        try {
            return JBIJMXObjectNames.getJavaCapsConfigurationServiceMBeanObjectName();
        }
        catch (MalformedObjectNameException e) {
            throw ManagementRemoteException.filterJmxExceptions(e);
        }
    }

    protected ObjectName getDeploymentServiceMBeanObjectName() throws ManagementRemoteException {
        try {
            return JBIJMXObjectNames.getJavaCapsDeploymentServiceMBeanObjectName();
        }
        catch (MalformedObjectNameException e) {
            throw ManagementRemoteException.filterJmxExceptions(e);
        }
    }

    protected ObjectName getInstallationServiceMBeanObjectName() throws ManagementRemoteException {
        try {
            return JBIJMXObjectNames.getJavaCapsInstallationServiceMBeanObjectName();
        }
        catch (MalformedObjectNameException e) {
            throw ManagementRemoteException.filterJmxExceptions(e);
        }
    }

    protected ObjectName getRuntimeManagementServiceMBeanObjectName() throws ManagementRemoteException {
        try {
            return JBIJMXObjectNames.getJavaCapsRuntimeManagementServiceMBeanObjectName();
        }
        catch (MalformedObjectNameException e) {
            throw ManagementRemoteException.filterJmxExceptions(e);
        }
    }

    protected ObjectName getPerformanceMeasurementServiceMBeanObjectName() throws ManagementRemoteException {
        try {
            return JBIJMXObjectNames.getJavaCapsPerformanceMeasurementServiceMBeanObjectName();
        }
        catch (MalformedObjectNameException e) {
            throw ManagementRemoteException.filterJmxExceptions(e);
        }
    }

    protected ObjectName getNotificationServiceMBeanObjectName() throws ManagementRemoteException {
        try {
            return JBIJMXObjectNames.getJavaCapsNotificationServiceMBeanObjectName();
        }
        catch (MalformedObjectNameException e) {
            throw ManagementRemoteException.filterJmxExceptions(e);
        }
    }

    protected Set<ObjectName> queryNames(String pattern, QueryExp query) throws ManagementRemoteException {
        Set<ObjectName> objectNames = null;
        if (this.remoteConnection != null) {
            try {
                objectNames = this.remoteConnection.queryNames(new ObjectName(pattern), query);
            }
            catch (Exception e) {
                throw ManagementRemoteException.filterJmxExceptions(e);
            }
        }
        return objectNames;
    }

    protected Map<String, String[]> listTargetNames() throws ManagementRemoteException {
        Map targetNameToTargetInstanceNameMap = null;
        ObjectName mbeanName = this.getAdministrationServiceMBeanObjectName();
        Object[] params = null;
        String[] signature = null;
        targetNameToTargetInstanceNameMap = (Map)this.invokeMBeanOperation(mbeanName, "listTargetNames", params, signature);
        return targetNameToTargetInstanceNameMap;
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ManagementRemoteException {
        Object result = null;
        if (this.remoteConnection != null) {
            try {
                result = this.remoteConnection.invoke(objectName, operationName, params, signature);
            }
            catch (InstanceNotFoundException jmxException) {
                throw ManagementRemoteException.filterJmxExceptions(jmxException);
            }
            catch (MBeanException jmxException) {
                throw ManagementRemoteException.filterJmxExceptions(jmxException);
            }
            catch (ReflectionException jmxException) {
                throw ManagementRemoteException.filterJmxExceptions(jmxException);
            }
            catch (IOException jmxException) {
                throw ManagementRemoteException.filterJmxExceptions(jmxException);
            }
        }
        return result;
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName, String param) throws ManagementRemoteException {
        Object[] params = new Object[]{param};
        String[] signature = new String[]{"java.lang.String"};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }
}

