/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.reducers.ReducingMethod;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportParser {
    private static final Logger LOG = LoggerFactory.getLogger(ReportParser.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final Configuration configuration;

    public ReportParser(Configuration configuration) {
        this.configuration = configuration;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        this.mapper.registerModule((Module)new JavaTimeModule());
        InjectableValues.Std values = new InjectableValues.Std().addValue(Configuration.class, (Object)configuration);
        this.mapper.setInjectableValues((InjectableValues)values);
    }

    public List<Feature> parseJsonFiles(List<String> jsonFiles) {
        if (jsonFiles.isEmpty()) {
            throw new ValidationException("No JSON report file was found!");
        }
        ArrayList<Feature> featureResults = new ArrayList<Feature>();
        for (String jsonFile : jsonFiles) {
            if (new File(jsonFile).length() == 0L && this.configuration.containsReducingMethod(ReducingMethod.SKIP_EMPTY_JSON_FILES)) continue;
            Feature[] features = this.parseForFeature(jsonFile);
            LOG.info("File '{}' contains {} feature(s)", (Object)jsonFile, (Object)features.length);
            featureResults.addAll(Arrays.asList(features));
        }
        if (featureResults.isEmpty()) {
            throw new ValidationException("Passed files have no features!");
        }
        return featureResults;
    }

    private Feature[] parseForFeature(String jsonFile) {
        Object[] objectArray;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);
        try {
            Object[] features = (Feature[])this.mapper.readValue((Reader)reader, Feature[].class);
            if (ArrayUtils.isEmpty((Object[])features)) {
                LOG.info("File '{}' does not contain features", (Object)jsonFile);
            }
            String jsonFileName = this.extractQualifier(jsonFile);
            Arrays.stream(features).forEach(feature -> feature.setQualifier(Objects.toString(this.configuration.getQualifier(jsonFileName), jsonFileName)));
            objectArray = features;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonMappingException e) {
                throw new ValidationException(String.format("File '%s' is not a valid Cucumber report! %s", jsonFile, e.getMessage()), e.getCause());
            }
            catch (IOException e) {
                throw new ValidationException(e);
            }
        }
        ((Reader)reader).close();
        return objectArray;
    }

    private String extractQualifier(String jsonFileName) {
        File jsonFile = new File(jsonFileName);
        String target = jsonFile.getName();
        String jsonExtension = ".json";
        if (target.toLowerCase().endsWith(".json")) {
            return target.substring(0, target.length() - ".json".length());
        }
        return target;
    }

    public void parseClassificationsFiles(List<String> propertiesFiles) {
        if (propertiesFiles != null && !propertiesFiles.isEmpty()) {
            for (String propertyFile : propertiesFiles) {
                if (!StringUtils.isNotEmpty((CharSequence)propertyFile)) continue;
                this.processClassificationFile(propertyFile);
            }
        }
    }

    private void processClassificationFile(String file) {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFile(new File(file))).setThrowExceptionOnMissing(true)});
        try {
            PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
            config.getKeys().forEachRemaining(key -> {
                if (config.getStringArray(key).length > 1) {
                    this.configuration.addClassifications((String)key, Arrays.toString(config.getStringArray(key)));
                } else {
                    this.configuration.addClassifications((String)key, config.getString(key));
                }
            });
        }
        catch (ConfigurationException e) {
            throw new ValidationException(String.format("File '%s' doesn't exist or the properties file is invalid!", file), e);
        }
    }
}

