/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.util.ChartUtil;
import net.masterthought.cucumber.util.Util;

public class TagOverviewPage
extends AbstractPage {
    public TagOverviewPage(ReportResult reportResult, Configuration configuration) {
        super(reportResult, "tagOverview.vm", configuration);
    }

    @Override
    public void generatePage() {
        super.generatePage();
        List<TagObject> tags = this.report.getAllTags();
        this.contextMap.put("all_tags", (Object)tags);
        this.contextMap.put("all_tags_scenarios", (Object)this.report.getAllTagScenarios());
        this.contextMap.put("all_tags_passed_scenarios", (Object)this.report.getAllPassedTagScenarios());
        this.contextMap.put("all_tags_failed_scenarios", (Object)this.report.getAllFailedTagScenarios());
        this.contextMap.put("all_tags_steps", (Object)this.report.getAllTagSteps());
        this.contextMap.put("all_tags_passes", (Object)this.report.getAllPassesTags());
        this.contextMap.put("all_tags_failed", (Object)this.report.getAllFailsTags());
        this.contextMap.put("all_tags_skipped", (Object)this.report.getAllSkippedTags());
        this.contextMap.put("all_tags_pending", (Object)this.report.getAllPendingTags());
        this.contextMap.put("all_tags_undefined", (Object)this.report.getAllUndefinedTags());
        this.contextMap.put("all_tags_missing", (Object)this.report.getAllMissingTags());
        this.contextMap.put("chart_categories", (Object)ChartUtil.getTags(tags));
        this.contextMap.put("chart_data", (Object)ChartUtil.generateTagChartDataForHighCharts(tags));
        this.contextMap.put("all_durations", (Object)Util.formatDuration(this.report.getAllTagDuration()));
        super.generateReport("tag-overview.html");
    }
}

