/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.util.Arrays;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.Status;

public class FeatureOverviewPage
extends AbstractPage {
    public FeatureOverviewPage(ReportResult reportResult, Configuration configuration) {
        super(reportResult, "featureOverview.vm", configuration);
    }

    @Override
    public void generatePage() {
        super.generatePage();
        this.contextMap.put("all_features", (Object)this.report.getAllFeatures());
        this.contextMap.put("all_steps", (Object)this.report.getStepsCounter());
        this.contextMap.put("all_steps_passes", (Object)this.report.getAllPassedSteps());
        this.contextMap.put("all_steps_failed", (Object)this.report.getAllFailedSteps());
        this.contextMap.put("all_steps_skipped", (Object)this.report.getAllSkippedSteps());
        this.contextMap.put("all_steps_pending", (Object)this.report.getPendingStepsl());
        this.contextMap.put("all_steps_undefined", (Object)this.report.getUndefinedSteps());
        this.contextMap.put("all_steps_missing", (Object)this.report.getTotalStepsMissing());
        this.contextMap.put("all_scenarios", (Object)this.report.getAllScenarios().size());
        this.contextMap.put("all_scenarios_passed", (Object)this.report.getAllPassedScenarios());
        this.contextMap.put("all_scenarios_failed", (Object)this.report.getAllFailedScenarios());
        this.contextMap.put("scenario_data", (Object)Arrays.asList(Status.PASSED.color, Status.FAILED.color));
        this.contextMap.put("all_durations", (Object)this.report.getAllDurationsAsString());
        this.contextMap.put("parallel", (Object)this.configuration.isParallelTesting());
        super.generateReport("feature-overview.html");
    }
}

