/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.VelocityContextMap;
import net.masterthought.cucumber.generators.ErrorPage;
import net.masterthought.cucumber.json.support.Status;
import org.apache.commons.io.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.EscapeTool;

public abstract class AbstractPage {
    private static final Logger LOG = LogManager.getLogger(AbstractPage.class);
    protected final VelocityEngine ve = new VelocityEngine();
    protected final VelocityContextMap contextMap = VelocityContextMap.of(new VelocityContext());
    private Template template;
    private final String fileName;
    protected final ReportResult report;
    protected final Configuration configuration;

    protected AbstractPage(ReportResult reportResult, String fileName, Configuration configuration) {
        this.fileName = fileName;
        this.report = reportResult;
        this.configuration = configuration;
    }

    public void generatePage() {
        this.ve.init(this.getProperties());
        this.template = this.ve.getTemplate("templates/pages/" + this.fileName);
        this.contextMap.clear();
        this.contextMap.putAll((Map<? extends String, ?>)this.getGeneralParameters());
        this.contextMap.put("esc", (Object)new EscapeTool());
        if (this instanceof ErrorPage) {
            this.contextMap.put("time_stamp", (Object)new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date()));
        } else {
            this.contextMap.put("time_stamp", (Object)this.report.timeStamp());
        }
        this.contextMap.put("status_color", (Object)Arrays.asList(Status.getOrderedColors()));
    }

    protected void generateReport(String fileName) {
        VelocityContext context = this.contextMap.getVelocityContext();
        context.put("page_url", (Object)fileName);
        File dir = new File(this.configuration.getReportDirectory(), fileName);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dir), Charsets.UTF_8);){
            this.template.merge((Context)context, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("runtime.log", new File(this.configuration.getReportDirectory(), "velocity.log").getPath());
        return props;
    }

    protected Map<String, Object> getGeneralParameters() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("jenkins_source", this.configuration.isRunWithJenkins());
        result.put("jenkins_base", this.configuration.getJenkinsBasePath());
        result.put("build_project", this.configuration.getProjectName());
        result.put("build_number", this.configuration.getBuildNumber());
        int previousBuildNumber = -1;
        try {
            previousBuildNumber = Integer.parseInt(this.configuration.getBuildNumber());
            --previousBuildNumber;
        }
        catch (NumberFormatException e) {
            LOG.error("Could not parse build number: {}.", new Object[]{this.configuration.getBuildNumber(), e});
        }
        result.put("build_previous_number", previousBuildNumber);
        return result;
    }
}

