/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.ErrorPage;
import net.masterthought.cucumber.generators.FeatureOverviewPage;
import net.masterthought.cucumber.generators.FeatureReportPage;
import net.masterthought.cucumber.generators.StepOverviewPage;
import net.masterthought.cucumber.generators.TagOverviewPage;
import net.masterthought.cucumber.generators.TagReportPage;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportBuilder {
    private static final Logger LOG = LogManager.getLogger(ReportBuilder.class);
    private ReportResult reportResult;
    private Configuration configuration;
    private List<String> jsonFiles;

    public ReportBuilder(List<String> jsonFiles, Configuration configuration) {
        try {
            this.jsonFiles = jsonFiles;
            this.configuration = configuration;
        }
        catch (Exception e) {
            this.generateErrorPage(e);
        }
    }

    public boolean hasBuildPassed() {
        return this.reportResult != null && this.reportResult.getAllFailedSteps() == 0;
    }

    public void generateReports() {
        try {
            ReportParser reportParser = new ReportParser(this.configuration);
            List<Feature> features = reportParser.parseJsonResults(this.jsonFiles);
            this.reportResult = new ReportResult(features);
            this.copyResource("theme", "blue.zip", true);
            this.copyResource("chart", "Highcharts-4.2.1.zip", true);
            this.copyResource("styles", "reporting.css", false);
            new FeatureOverviewPage(this.reportResult, this.configuration).generatePage();
            new FeatureReportPage(this.reportResult, this.configuration).generatePage();
            new TagReportPage(this.reportResult, this.configuration).generatePage();
            new TagOverviewPage(this.reportResult, this.configuration).generatePage();
            new StepOverviewPage(this.reportResult, this.configuration).generatePage();
        }
        catch (Exception e) {
            this.generateErrorPage(e);
        }
    }

    private void copyResource(String resourceLocation, String resourceName, boolean decompress) throws IOException, URISyntaxException {
        File tempFile = new File(this.configuration.getReportDirectory().getAbsoluteFile(), resourceName);
        FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/" + resourceLocation + "/" + resourceName), (File)tempFile);
        if (decompress) {
            Util.unzipToFile(tempFile, this.configuration.getReportDirectory().getAbsolutePath());
            tempFile.delete();
        }
    }

    private void generateErrorPage(Exception exception) {
        LOG.info((Object)exception);
        ErrorPage errorPage = new ErrorPage(this.reportResult, this.configuration, exception, this.jsonFiles);
        errorPage.generatePage();
    }
}

