/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.CloseableJVMKt;
import kotlinx.io.core.Input;
import kotlinx.io.core.StringsKt;
import net.mamoe.mirai.utils.ExternalImage;
import net.mamoe.mirai.utils.FileCacheStrategy_jvmKt;
import net.mamoe.mirai.utils.internal.AsReusableInput_jvmKt;
import net.mamoe.mirai.utils.internal.ReusableInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\f\r\u000eJ\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\bH&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\tH&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\nH&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u000bH&\u00a8\u0006\u000f"}, d2={"Lnet/mamoe/mirai/utils/FileCacheStrategy;", "", "newImageCache", "Lnet/mamoe/mirai/utils/ExternalImage;", "input", "Ljava/awt/image/BufferedImage;", "format", "", "Ljava/io/InputStream;", "Ljava/net/URL;", "", "Lkotlinx/io/core/Input;", "MemoryCache", "PlatformDefault", "TempCache", "mirai-core"})
public interface FileCacheStrategy {
    @NotNull
    public ExternalImage newImageCache(@NotNull Input var1) throws IOException;

    @NotNull
    public ExternalImage newImageCache(@NotNull InputStream var1) throws IOException;

    @NotNull
    public ExternalImage newImageCache(@NotNull byte[] var1) throws IOException;

    @NotNull
    public ExternalImage newImageCache(@NotNull BufferedImage var1, @NotNull String var2) throws IOException;

    @NotNull
    public ExternalImage newImageCache(@NotNull URL var1) throws IOException;

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0096\u0001J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0096\u0001J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0096\u0001J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0096\u0001J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0096\u0001\u00a8\u0006\r"}, d2={"Lnet/mamoe/mirai/utils/FileCacheStrategy$PlatformDefault;", "Lnet/mamoe/mirai/utils/FileCacheStrategy;", "()V", "newImageCache", "Lnet/mamoe/mirai/utils/ExternalImage;", "input", "Ljava/awt/image/BufferedImage;", "format", "", "Ljava/io/InputStream;", "Ljava/net/URL;", "", "Lkotlinx/io/core/Input;", "mirai-core"})
    public static final class PlatformDefault
    implements FileCacheStrategy {
        public static final PlatformDefault INSTANCE;
        private final /* synthetic */ TempCache $$delegate_0;

        private PlatformDefault() {
            this.$$delegate_0 = new TempCache(null);
        }

        static {
            PlatformDefault platformDefault;
            INSTANCE = platformDefault = new PlatformDefault();
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull BufferedImage input2, @NotNull String format) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            return this.$$delegate_0.newImageCache(input2, format);
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull InputStream input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return this.$$delegate_0.newImageCache(input2);
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull URL input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return this.$$delegate_0.newImageCache(input2);
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull byte[] input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return this.$$delegate_0.newImageCache(input2);
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull Input input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return this.$$delegate_0.newImageCache(input2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/mamoe/mirai/utils/FileCacheStrategy$MemoryCache;", "Lnet/mamoe/mirai/utils/FileCacheStrategy;", "()V", "newImageCache", "Lnet/mamoe/mirai/utils/ExternalImage;", "input", "Ljava/awt/image/BufferedImage;", "format", "", "Ljava/io/InputStream;", "Ljava/net/URL;", "", "Lkotlinx/io/core/Input;", "mirai-core"})
    public static final class MemoryCache
    implements FileCacheStrategy {
        public static final MemoryCache INSTANCE;

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull Input input2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return this.newImageCache(StringsKt.readBytes((Input)input2));
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull InputStream input2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return this.newImageCache(ByteStreamsKt.readBytes((InputStream)input2));
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull byte[] input2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return new ExternalImage(AsReusableInput_jvmKt.asReusableInput(input2));
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull BufferedImage input2, @NotNull String format) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)input2, format, out);
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
            return this.newImageCache(byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull URL input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Closeable closeable = input2.openConnection().getInputStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                InputStream inputStream = it;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)out, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
            return this.newImageCache(byArray);
        }

        private MemoryCache() {
        }

        static {
            MemoryCache memoryCache;
            INSTANCE = memoryCache = new MemoryCache();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/mamoe/mirai/utils/FileCacheStrategy$TempCache;", "Lnet/mamoe/mirai/utils/FileCacheStrategy;", "directory", "Ljava/io/File;", "(Ljava/io/File;)V", "getDirectory", "()Ljava/io/File;", "newImageCache", "Lnet/mamoe/mirai/utils/ExternalImage;", "input", "Ljava/awt/image/BufferedImage;", "format", "", "Ljava/io/InputStream;", "Ljava/net/URL;", "", "Lkotlinx/io/core/Input;", "mirai-core"})
    public static final class TempCache
    implements FileCacheStrategy {
        @Nullable
        private final File directory;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull Input input2) throws IOException {
            void $this$withOut$iv;
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            File file = FilesKt.createTempFile$default(null, null, (File)this.directory, (int)3, null);
            boolean bl = false;
            boolean bl2 = false;
            File $this$apply = file;
            boolean bl3 = false;
            $this$apply.deleteOnExit();
            Closeable closeable = (Closeable)input2;
            File file2 = $this$apply;
            boolean bl4 = false;
            Closeable output$iv = new FileOutputStream(file2);
            boolean $i$f$withOut = false;
            boolean bl5 = false;
            void $this$use$iv$iv = $this$withOut$iv;
            boolean $i$f$use = false;
            boolean closed$iv$iv = false;
            try {
                Unit unit;
                FileOutputStream fileOutputStream;
                void it$iv = $this$use$iv$iv;
                boolean bl6 = false;
                Closeable $this$use$iv$iv2 = output$iv;
                boolean $i$f$use2 = false;
                boolean closed$iv$iv2 = false;
                try {
                    void it;
                    Closeable it$iv2 = $this$use$iv$iv2;
                    boolean bl7 = false;
                    fileOutputStream = (FileOutputStream)output$iv;
                    Input $this$withOut = (Input)$this$withOut$iv;
                    boolean bl8 = false;
                    FileCacheStrategy_jvmKt.copyTo$default($this$withOut, (OutputStream)it, 0, 2, null);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable first$iv$iv) {
                    try {
                        try {
                            closed$iv$iv2 = true;
                            $this$use$iv$iv2.close();
                        }
                        catch (Throwable second$iv$iv) {
                            CloseableJVMKt.addSuppressedInternal((Throwable)first$iv$iv, (Throwable)second$iv$iv);
                        }
                        throw first$iv$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv$iv2) {
                            $this$use$iv$iv2.close();
                        }
                        throw throwable;
                    }
                }
                $this$use$iv$iv2.close();
                fileOutputStream = unit;
            }
            catch (Throwable first$iv$iv) {
                try {
                    try {
                        closed$iv$iv = true;
                        $this$use$iv$iv.close();
                    }
                    catch (Throwable second$iv$iv) {
                        CloseableJVMKt.addSuppressedInternal((Throwable)first$iv$iv, (Throwable)second$iv$iv);
                    }
                    throw first$iv$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv$iv) {
                        $this$use$iv$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv$iv.close();
            Unit unit = Unit.INSTANCE;
            ReusableInput reusableInput = AsReusableInput_jvmKt.asReusableInput(file, true);
            return new ExternalImage(reusableInput);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull InputStream input2) throws IOException {
            void $this$withOut$iv;
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            File file = FilesKt.createTempFile$default(null, null, (File)this.directory, (int)3, null);
            boolean bl = false;
            boolean bl2 = false;
            File $this$apply = file;
            boolean bl3 = false;
            $this$apply.deleteOnExit();
            Closeable closeable = input2;
            File file2 = $this$apply;
            boolean bl4 = false;
            Closeable output$iv = new FileOutputStream(file2);
            boolean $i$f$withOut = false;
            boolean bl5 = false;
            void $this$use$iv$iv = $this$withOut$iv;
            boolean $i$f$use = false;
            boolean closed$iv$iv = false;
            try {
                Unit unit;
                FileOutputStream fileOutputStream;
                void it$iv = $this$use$iv$iv;
                boolean bl6 = false;
                Closeable $this$use$iv$iv2 = output$iv;
                boolean $i$f$use2 = false;
                boolean closed$iv$iv2 = false;
                try {
                    void it;
                    Closeable it$iv2 = $this$use$iv$iv2;
                    boolean bl7 = false;
                    fileOutputStream = (FileOutputStream)output$iv;
                    InputStream $this$withOut = (InputStream)$this$withOut$iv;
                    boolean bl8 = false;
                    ByteStreamsKt.copyTo$default((InputStream)$this$withOut, (OutputStream)((OutputStream)it), (int)0, (int)2, null);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable first$iv$iv) {
                    try {
                        try {
                            closed$iv$iv2 = true;
                            $this$use$iv$iv2.close();
                        }
                        catch (Throwable second$iv$iv) {
                            CloseableJVMKt.addSuppressedInternal((Throwable)first$iv$iv, (Throwable)second$iv$iv);
                        }
                        throw first$iv$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv$iv2) {
                            $this$use$iv$iv2.close();
                        }
                        throw throwable;
                    }
                }
                $this$use$iv$iv2.close();
                fileOutputStream = unit;
            }
            catch (Throwable first$iv$iv) {
                try {
                    try {
                        closed$iv$iv = true;
                        $this$use$iv$iv.close();
                    }
                    catch (Throwable second$iv$iv) {
                        CloseableJVMKt.addSuppressedInternal((Throwable)first$iv$iv, (Throwable)second$iv$iv);
                    }
                    throw first$iv$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv$iv) {
                        $this$use$iv$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv$iv.close();
            Unit unit = Unit.INSTANCE;
            ReusableInput reusableInput = AsReusableInput_jvmKt.asReusableInput(file, true);
            return new ExternalImage(reusableInput);
        }

        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull byte[] input2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return new ExternalImage(AsReusableInput_jvmKt.asReusableInput(input2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull BufferedImage input2, @NotNull String format) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            File file = FilesKt.createTempFile$default(null, null, (File)this.directory, (int)3, null);
            boolean bl = false;
            boolean bl2 = false;
            File $this$apply = file;
            boolean bl3 = false;
            $this$apply.deleteOnExit();
            File file2 = file;
            MessageDigest digest = MessageDigest.getInstance("md5");
            digest.reset();
            Object object = file2;
            bl2 = false;
            object = new FileOutputStream((File)object);
            bl2 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                FileOutputStream out = (FileOutputStream)object;
                boolean bl5 = false;
                boolean bl6 = ImageIO.write((RenderedImage)input2, format, new OutputStream(out, input2, format, digest){
                    final /* synthetic */ FileOutputStream $out;
                    final /* synthetic */ BufferedImage $input$inlined;
                    final /* synthetic */ String $format$inlined;
                    final /* synthetic */ MessageDigest $digest$inlined;
                    {
                        this.$out = $captured_local_variable$1;
                        this.$input$inlined = bufferedImage;
                        this.$format$inlined = string;
                        this.$digest$inlined = messageDigest;
                    }

                    public void write(int b) {
                        this.$out.write(b);
                        this.$digest$inlined.update((byte)b);
                    }

                    public void write(@NotNull byte[] b) {
                        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                        this.$out.write(b);
                        this.$digest$inlined.update(b);
                    }

                    public void write(@NotNull byte[] b, int off, int len) {
                        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                        this.$out.write(b, off, len);
                        this.$digest$inlined.update(b, off, len);
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
            return new ExternalImage(AsReusableInput_jvmKt.asReusableInput(file2, true, byArray));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ExternalImage newImageCache(@NotNull URL input2) {
            void $this$withOut$iv;
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            File file = FilesKt.createTempFile$default(null, null, (File)this.directory, (int)3, null);
            boolean bl = false;
            boolean bl2 = false;
            File $this$apply = file;
            boolean bl3 = false;
            $this$apply.deleteOnExit();
            Closeable closeable = input2.openConnection().getInputStream();
            File file2 = $this$apply;
            boolean bl4 = false;
            Closeable output$iv = new FileOutputStream(file2);
            boolean $i$f$withOut = false;
            boolean bl5 = false;
            void $this$use$iv$iv = $this$withOut$iv;
            boolean $i$f$use = false;
            boolean closed$iv$iv = false;
            try {
                Unit unit;
                FileOutputStream fileOutputStream;
                void it$iv = $this$use$iv$iv;
                boolean bl6 = false;
                Closeable $this$use$iv$iv2 = output$iv;
                boolean $i$f$use2 = false;
                boolean closed$iv$iv2 = false;
                try {
                    void it;
                    Closeable it$iv2 = $this$use$iv$iv2;
                    boolean bl7 = false;
                    fileOutputStream = (FileOutputStream)output$iv;
                    InputStream $this$withOut = (InputStream)$this$withOut$iv;
                    boolean bl8 = false;
                    ByteStreamsKt.copyTo$default((InputStream)$this$withOut, (OutputStream)((OutputStream)it), (int)0, (int)2, null);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable first$iv$iv) {
                    try {
                        try {
                            closed$iv$iv2 = true;
                            $this$use$iv$iv2.close();
                        }
                        catch (Throwable second$iv$iv) {
                            CloseableJVMKt.addSuppressedInternal((Throwable)first$iv$iv, (Throwable)second$iv$iv);
                        }
                        throw first$iv$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv$iv2) {
                            $this$use$iv$iv2.close();
                        }
                        throw throwable;
                    }
                }
                $this$use$iv$iv2.close();
                fileOutputStream = unit;
            }
            catch (Throwable first$iv$iv) {
                try {
                    try {
                        closed$iv$iv = true;
                        $this$use$iv$iv.close();
                    }
                    catch (Throwable second$iv$iv) {
                        CloseableJVMKt.addSuppressedInternal((Throwable)first$iv$iv, (Throwable)second$iv$iv);
                    }
                    throw first$iv$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv$iv) {
                        $this$use$iv$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv$iv.close();
            Unit unit = Unit.INSTANCE;
            ReusableInput reusableInput = AsReusableInput_jvmKt.asReusableInput(file, true);
            return new ExternalImage(reusableInput);
        }

        @Nullable
        public final File getDirectory() {
            return this.directory;
        }

        @JvmOverloads
        public TempCache(@Nullable File directory) {
            this.directory = directory;
        }

        public /* synthetic */ TempCache(File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                file = null;
            }
            this(file);
        }

        @JvmOverloads
        public TempCache() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static /* synthetic */ ExternalImage newImageCache$default(FileCacheStrategy fileCacheStrategy, BufferedImage bufferedImage, String string, int n, Object object) throws IOException {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newImageCache");
            }
            if ((n & 2) != 0) {
                string = "png";
            }
            return fileCacheStrategy.newImageCache(bufferedImage, string);
        }
    }
}

