/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.war.WarArchiver;

@Mojo(name="package-app", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PackageAppMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String warName;
    @Parameter(property="war.forceCreation", defaultValue="false")
    private boolean forceCreation;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component(role=Archiver.class, hint="war")
    private WarArchiver warArchiver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.warArchiver.setExpectWebXml(false);
        File warFile = new File(this.outputDirectory, this.warName + ".war");
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setOutputFile(warFile);
        this.archive.setForced(this.forceCreation);
        try {
            File prepackagedApp = new File(this.outputDirectory, this.warName);
            if (prepackagedApp.exists()) {
                this.warArchiver.addDirectory(prepackagedApp);
            }
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packaging GWT application", e);
        }
        this.project.getArtifact().setFile(warFile);
    }
}

