/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.util.List;
import net.ltgt.gwt.maven.SourcesAsResourcesHelper;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="package-lib", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class JarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="maven.jar.forceCreation", defaultValue="false")
    private boolean forceCreation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File jarFile = new File(this.outputDirectory, this.finalName + ".jar");
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        this.archive.setForced(this.forceCreation);
        List<String> sourceRoots = SourcesAsResourcesHelper.filterSourceRoots(this.getLog(), this.project.getResources(), this.project.getCompileSourceRoots());
        try {
            for (String sourceRoot : sourceRoots) {
                File f = new File(sourceRoot);
                if (!f.exists()) continue;
                this.jarArchiver.addDirectory(f);
            }
            if (this.classesDirectory.exists()) {
                this.jarArchiver.addDirectory(this.classesDirectory);
            }
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packaging GWT library", e);
        }
        this.project.getArtifact().setFile(jarFile);
    }
}

