/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="enforce-encoding", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class EnforceEncodingMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String encoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
        if (encoding == null) {
            this.getLog().info((CharSequence)"Setting project.build.sourceEncoding to UTF-8");
        } else if (!encoding.equalsIgnoreCase("UTF-8")) {
            this.getLog().warn((CharSequence)("Encoding was set to " + encoding + "; forcing it to UTF-8"));
        }
        this.project.getProperties().setProperty("project.build.sourceEncoding", "UTF-8");
    }
}

