/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.Objects;

class FastISOTimestampFormatter {
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private static ThreadLocal<StringBuilder> STRING_BUILDERS = ThreadLocal.withInitial(() -> new StringBuilder(30));
    private final DateTimeFormatter formatter;
    private ZoneOffsetState zoneOffsetState;
    private final boolean trimMillis;

    FastISOTimestampFormatter(DateTimeFormatter formatter, boolean trimMillis) {
        this.formatter = Objects.requireNonNull(formatter);
        this.trimMillis = trimMillis;
        if (formatter.getZone() == null) {
            throw new IllegalArgumentException("formatter must be configured with a Zone override to format millis");
        }
    }

    public String format(long timestampInMillis) {
        ZoneOffsetState current = this.zoneOffsetState;
        if (current == null || !current.canFormat(timestampInMillis)) {
            this.zoneOffsetState = current = new ZoneOffsetState(timestampInMillis);
        }
        return current.format(timestampInMillis);
    }

    public static FastISOTimestampFormatter isoOffsetDateTime(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(zoneId), true);
    }

    public static FastISOTimestampFormatter isoZonedDateTime(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_ZONED_DATE_TIME.withZone(zoneId), true);
    }

    public static FastISOTimestampFormatter isoLocalDateTime(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(zoneId), true);
    }

    public static FastISOTimestampFormatter isoDateTime(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_DATE_TIME.withZone(zoneId), true);
    }

    public static FastISOTimestampFormatter isoInstant(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_INSTANT.withZone(zoneId), false);
    }

    String buildFromFormatter(long timestampInMillis) {
        return this.formatter.format(Instant.ofEpochMilli(timestampInMillis));
    }

    private class TimestampPeriod {
        private final long periodStartInMillis;
        private final long periodStopInMillis;
        private final String suffix;
        private final String prefix;

        TimestampPeriod(long periodStartInMillis, long periodStopInMillis, String prefix, String suffix) {
            this.periodStartInMillis = periodStartInMillis;
            this.periodStopInMillis = periodStopInMillis;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public boolean canFormat(long timestampInMillis) {
            return timestampInMillis >= this.periodStartInMillis && timestampInMillis < this.periodStopInMillis;
        }

        public String format(long timestampInMillis) {
            StringBuilder sb = (StringBuilder)STRING_BUILDERS.get();
            sb.setLength(0);
            sb.append(this.prefix);
            int millisSincePeriodStart = (int)(timestampInMillis - this.periodStartInMillis);
            int seconds = millisSincePeriodStart / 1000;
            int millis = millisSincePeriodStart % 1000;
            if (seconds < 10) {
                sb.append('0');
            }
            sb.append(seconds);
            if (millis > 0) {
                int dotPos = sb.length();
                sb.append('.');
                if (millis < 100) {
                    sb.append('0');
                }
                if (millis < 10) {
                    sb.append('0');
                }
                sb.append(millis);
                if (FastISOTimestampFormatter.this.trimMillis) {
                    while (sb.length() > dotPos && sb.charAt(sb.length() - 1) == '0') {
                        sb.setLength(sb.length() - 1);
                    }
                }
            }
            sb.append(this.suffix);
            return sb.toString();
        }
    }

    private class ZoneOffsetState {
        private final long zoneTransitionStart;
        private final long zoneTransitionStop;
        private final boolean cachingEnabled;
        private TimestampPeriod cachedTimestampPeriod;

        ZoneOffsetState(long timestampInMillis) {
            Instant now = Instant.ofEpochMilli(timestampInMillis);
            ZoneRules rules = FastISOTimestampFormatter.this.formatter.getZone().getRules();
            if (rules.isFixedOffset()) {
                this.zoneTransitionStart = Long.MIN_VALUE;
                this.zoneTransitionStop = Long.MAX_VALUE;
            } else {
                ZoneOffsetTransition previousZoneOffsetTransition = rules.previousTransition(now);
                this.zoneTransitionStart = previousZoneOffsetTransition == null ? Long.MIN_VALUE : previousZoneOffsetTransition.toEpochSecond() * 1000L;
                ZoneOffsetTransition zoneOffsetTransition = rules.nextTransition(now);
                this.zoneTransitionStop = zoneOffsetTransition == null ? Long.MAX_VALUE : zoneOffsetTransition.toEpochSecond() * 1000L;
            }
            int offsetSeconds = rules.getOffset(now).getTotalSeconds();
            this.cachingEnabled = offsetSeconds % 60 == 0;
        }

        public boolean canFormat(long timestampInMillis) {
            return timestampInMillis >= this.zoneTransitionStart && timestampInMillis < this.zoneTransitionStop;
        }

        public String format(long timestampInMillis) {
            if (!this.cachingEnabled) {
                return FastISOTimestampFormatter.this.buildFromFormatter(timestampInMillis);
            }
            TimestampPeriod currentTimestampPeriod = this.cachedTimestampPeriod;
            if (currentTimestampPeriod != null && currentTimestampPeriod.canFormat(timestampInMillis)) {
                return this.buildFromCache(currentTimestampPeriod, timestampInMillis);
            }
            String formatted = FastISOTimestampFormatter.this.buildFromFormatter(timestampInMillis);
            this.cachedTimestampPeriod = this.createNewCache(timestampInMillis, formatted);
            return formatted;
        }

        private TimestampPeriod createNewCache(long timestampInMillis, String formatted) {
            String prefix = formatted.substring(0, 17);
            String suffix = this.findSuffix(formatted, 17);
            long timstampInMinutes = timestampInMillis / 60000L;
            long minuteStartInMillis = timstampInMinutes * 60000L;
            long minuteStopInMillis = (timstampInMinutes + 1L) * 60000L;
            return new TimestampPeriod(minuteStartInMillis, minuteStopInMillis, prefix, suffix);
        }

        private String findSuffix(String formatted, int beginIndex) {
            int pos;
            boolean dotFound = false;
            for (pos = beginIndex; pos < formatted.length(); ++pos) {
                char c = formatted.charAt(pos);
                if (c == '.') {
                    if (dotFound) break;
                    dotFound = true;
                    continue;
                }
                if (!Character.isDigit(c)) break;
            }
            if (pos < formatted.length()) {
                return formatted.substring(pos);
            }
            return "";
        }

        private String buildFromCache(TimestampPeriod cache, long timestampInMillis) {
            return cache.format(timestampInMillis);
        }
    }
}

