/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender.listener;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.logstash.logback.appender.listener.TcpAppenderListener;

public abstract class FailureSummaryAppenderListener<Event extends DeferredProcessingAware>
implements TcpAppenderListener<Event> {
    private final AtomicReference<State> appendState = new AtomicReference<State>(SUCCEEDING_STATE);
    private final AtomicReference<State> sendState = new AtomicReference<State>(SUCCEEDING_STATE);
    private final AtomicReference<State> connectState = new AtomicReference<State>(SUCCEEDING_STATE);
    private static final State SUCCEEDING_STATE = () -> true;

    @Override
    public void eventAppended(Appender<Event> appender, Event event, long durationInNanos) {
        this.recordSuccess(this.appendState, CallbackType.APPEND);
    }

    @Override
    public void eventAppendFailed(Appender<Event> appender, Event event, Throwable reason) {
        this.recordFailure(this.appendState, reason);
    }

    @Override
    public void eventSent(Appender<Event> appender, Socket socket, Event event, long durationInNanos) {
        this.recordSuccess(this.sendState, CallbackType.SEND);
    }

    @Override
    public void eventSendFailure(Appender<Event> appender, Event event, Throwable reason) {
        this.recordFailure(this.sendState, reason);
    }

    @Override
    public void connectionOpened(Appender<Event> appender, Socket socket) {
        this.recordSuccess(this.connectState, CallbackType.CONNECT);
    }

    @Override
    public void connectionFailed(Appender<Event> appender, InetSocketAddress address, Throwable reason) {
        this.recordFailure(this.connectState, reason);
    }

    private void recordSuccess(AtomicReference<State> stateRef, CallbackType callbackType) {
        State currentState = stateRef.get();
        if (!currentState.isSucceeding() && stateRef.compareAndSet(currentState, SUCCEEDING_STATE)) {
            FailingState oldFailingState = (FailingState)currentState;
            this.handleFailureSummary(oldFailingState, callbackType);
        }
    }

    private void recordFailure(AtomicReference<State> stateRef, Throwable reason) {
        State currentState = stateRef.get();
        if (currentState.isSucceeding()) {
            if (!stateRef.compareAndSet(currentState, new FailingState(reason))) {
                this.recordFailure(stateRef, reason);
            }
        } else {
            ((FailingState)currentState).recordThrowable(reason);
        }
    }

    protected abstract void handleFailureSummary(FailureSummary var1, CallbackType var2);

    private static class FailingState
    implements State,
    FailureSummary {
        private final Throwable firstThrowable;
        private final long firstFailureTime;
        private final AtomicLong consecutiveFailures = new AtomicLong();
        private volatile Throwable mostRecentThrowable;

        private FailingState(Throwable firstThrowable) {
            this.firstThrowable = firstThrowable;
            this.firstFailureTime = System.currentTimeMillis();
            this.recordThrowable(firstThrowable);
        }

        @Override
        public boolean isSucceeding() {
            return false;
        }

        @Override
        public Throwable getFirstFailure() {
            return this.firstThrowable;
        }

        @Override
        public long getFirstFailureTime() {
            return this.firstFailureTime;
        }

        @Override
        public Throwable getMostRecentFailure() {
            return this.mostRecentThrowable;
        }

        @Override
        public long getConsecutiveFailures() {
            return this.consecutiveFailures.get();
        }

        private void recordThrowable(Throwable throwable) {
            this.consecutiveFailures.incrementAndGet();
            this.mostRecentThrowable = throwable;
        }
    }

    private static interface State {
        public boolean isSucceeding();
    }

    public static interface FailureSummary {
        public long getFirstFailureTime();

        public Throwable getFirstFailure();

        public Throwable getMostRecentFailure();

        public long getConsecutiveFailures();
    }

    public static enum CallbackType {
        APPEND,
        SEND,
        CONNECT;

    }
}

