/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.logstash.logback.composite.CompositeJsonFormatter;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.encoder.SeparatorParser;

public abstract class CompositeJsonEncoder<Event extends DeferredProcessingAware>
extends EncoderBase<Event> {
    private boolean immediateFlush = true;
    private Encoder<Event> prefix;
    private Encoder<Event> suffix;
    private final CompositeJsonFormatter<Event> formatter;
    private String lineSeparator = System.getProperty("line.separator");
    private byte[] lineSeparatorBytes;
    private Charset charset;

    public CompositeJsonEncoder() {
        this.formatter = this.createFormatter();
    }

    protected abstract CompositeJsonFormatter<Event> createFormatter();

    public void init(OutputStream os) throws IOException {
        this.initWrapped(this.prefix, os);
        super.init(os);
        this.initWrapped(this.suffix, os);
    }

    private void initWrapped(Encoder<Event> wrapped, OutputStream os) throws IOException {
        if (wrapped != null) {
            wrapped.init(os);
        }
    }

    public void doEncode(Event event) throws IOException {
        this.doEncodeWrapped(this.prefix, event);
        this.formatter.writeEventToOutputStream(event, this.outputStream);
        this.doEncodeWrapped(this.suffix, event);
        if (this.lineSeparatorBytes != null) {
            this.outputStream.write(this.lineSeparatorBytes);
        }
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    private void doEncodeWrapped(Encoder<Event> wrapped, Event event) throws IOException {
        if (wrapped != null) {
            wrapped.doEncode(event);
        }
    }

    public void start() {
        super.start();
        this.formatter.setContext(this.getContext());
        this.formatter.start();
        this.charset = Charset.forName(this.formatter.getEncoding());
        this.lineSeparatorBytes = this.lineSeparator == null ? null : this.lineSeparator.getBytes(this.charset);
        this.startWrapped(this.prefix);
        this.startWrapped(this.suffix);
    }

    private void startWrapped(Encoder<Event> wrapped) {
        if (wrapped instanceof LayoutWrappingEncoder) {
            LayoutWrappingEncoder layoutWrappedEncoder = (LayoutWrappingEncoder)wrapped;
            layoutWrappedEncoder.setCharset(this.charset);
            if (layoutWrappedEncoder.getLayout() instanceof PatternLayoutBase) {
                PatternLayoutBase layout = (PatternLayoutBase)layoutWrappedEncoder.getLayout();
                layout.setPostCompileProcessor(null);
                layout.start();
            }
        }
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.start();
        }
    }

    public void stop() {
        super.stop();
        this.formatter.stop();
        this.stopWrapped(this.prefix);
        this.stopWrapped(this.suffix);
    }

    private void stopWrapped(Encoder<Event> wrapped) {
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.stop();
        }
    }

    public void close() throws IOException {
        this.closeWrapped(this.prefix);
        this.closeWrapped(this.suffix);
    }

    private void closeWrapped(Encoder<Event> wrapped) throws IOException {
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.close();
        }
    }

    public JsonProviders<Event> getProviders() {
        return this.formatter.getProviders();
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.formatter.setProviders(jsonProviders);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.formatter.getJsonFactoryDecorator();
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.formatter.setJsonFactoryDecorator(jsonFactoryDecorator);
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.formatter.getJsonGeneratorDecorator();
    }

    public String getEncoding() {
        return this.formatter.getEncoding();
    }

    public void setEncoding(String encodingName) {
        this.formatter.setEncoding(encodingName);
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.formatter.setJsonGeneratorDecorator(jsonGeneratorDecorator);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = SeparatorParser.parseSeparator(lineSeparator);
    }

    protected CompositeJsonFormatter<Event> getFormatter() {
        return this.formatter;
    }

    public Encoder<Event> getPrefix() {
        return this.prefix;
    }

    public void setPrefix(Encoder<Event> prefix) {
        this.prefix = prefix;
    }

    public Encoder<Event> getSuffix() {
        return this.suffix;
    }

    public void setSuffix(Encoder<Event> suffix) {
        this.suffix = suffix;
    }
}

