/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.util;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.LogSupport;
import net.lightbody.bmp.proxy.jetty.util.MultiMap;
import net.lightbody.bmp.proxy.jetty.util.StringUtil;
import net.lightbody.bmp.proxy.jetty.util.TypeUtil;
import net.lightbody.bmp.proxy.jetty.util.UrlEncoded;
import org.apache.commons.logging.Log;

public class URI
implements Cloneable {
    private static Log log = LogFactory.getLog(URI.class);
    public static final String __CHARSET = System.getProperty("net.lightbody.bmp.proxy.jetty.util.URI.charset", "UTF-8");
    public static final boolean __CHARSET_IS_DEFAULT = __CHARSET.equals("UTF-8");
    private String _uri;
    private String _scheme;
    private String _host;
    private int _port;
    private String _path;
    private String _encodedPath;
    private String _query;
    private UrlEncoded _parameters;
    private boolean _dirty;

    public URI(URI uri) throws IllegalArgumentException {
        this._uri = uri.toString();
        this._scheme = uri._scheme;
        this._host = uri._host;
        this._port = uri._port;
        this._path = uri._path;
        this._encodedPath = uri._encodedPath;
        this._query = uri._query;
        if (uri._parameters != null) {
            this._parameters = (UrlEncoded)uri._parameters.clone();
        }
        this._dirty = false;
    }

    public URI(String uri) throws IllegalArgumentException {
        this.setURI(uri);
    }

    public void setURI(String uri) throws IllegalArgumentException {
        try {
            char c;
            this._uri = uri;
            this._scheme = null;
            this._host = null;
            this._port = 0;
            this._path = null;
            this._encodedPath = null;
            this._query = null;
            if (this._parameters != null) {
                this._parameters.clear();
            }
            int maxi = uri.length() - 1;
            int mark = 0;
            int state = 0;
            int i = 0;
            if (maxi == 0 || uri.charAt(0) == '/' && uri.charAt(1) != '/') {
                state = 3;
                this._scheme = null;
                this._host = null;
                this._port = 0;
            } else {
                block15: for (i = 0; state < 3 && i <= maxi; ++i) {
                    c = uri.charAt(i);
                    switch (state) {
                        case 0: {
                            if (c == ':' && uri.charAt(i + 1) == '/' && uri.charAt(i + 2) == '/') {
                                this._scheme = uri.substring(mark, i);
                                mark = (i += 2) + 1;
                                state = 1;
                                continue block15;
                            }
                            if (i == 0 && c == '/') {
                                state = 3;
                                continue block15;
                            }
                            if (i != 0 || c != '*') continue block15;
                            state = 5;
                            this._path = "*";
                            this._encodedPath = "*";
                            continue block15;
                        }
                        case 1: {
                            if (c == ':') {
                                this._host = uri.substring(mark, i);
                                mark = i + 1;
                                state = 2;
                                continue block15;
                            }
                            if (c != '/') continue block15;
                            this._host = uri.substring(mark, i);
                            mark = i;
                            state = 3;
                            continue block15;
                        }
                        case 2: {
                            if (c != '/') continue block15;
                            this._port = TypeUtil.parseInt(uri, mark, i - mark, 10);
                            mark = i;
                            state = 3;
                            continue block15;
                        }
                    }
                }
            }
            this._query = null;
            ++i;
            while (i <= maxi) {
                c = uri.charAt(i);
                if (c == '?') {
                    this._encodedPath = uri.substring(mark, i);
                    this._path = URI.decodePath(this._encodedPath);
                    mark = i + 1;
                    state = 4;
                    break;
                }
                ++i;
            }
            switch (state) {
                case 0: {
                    this._dirty = false;
                    this._encodedPath = this._uri;
                    this._path = URI.decodePath(this._encodedPath);
                    break;
                }
                case 1: {
                    this._dirty = true;
                    this._path = this._encodedPath = "/";
                    this._host = uri.substring(mark);
                    break;
                }
                case 2: {
                    this._dirty = true;
                    this._path = this._encodedPath = "/";
                    this._port = TypeUtil.parseInt(uri, mark, -1, 10);
                    break;
                }
                case 3: {
                    this._dirty = mark == maxi;
                    this._encodedPath = uri.substring(mark);
                    this._path = URI.decodePath(this._encodedPath);
                    break;
                }
                case 4: {
                    this._dirty = false;
                    if (mark > maxi) break;
                    this._query = uri.substring(mark);
                    break;
                }
                case 5: {
                    this._dirty = false;
                }
            }
            if (this._query != null && this._query.length() > 0) {
                if (this._parameters == null) {
                    this._parameters = new UrlEncoded();
                } else {
                    this._parameters.clear();
                }
                this._parameters.decode(this._query, __CHARSET);
            } else {
                this._query = null;
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
            throw new IllegalArgumentException("Malformed URI '" + uri + "' : " + e.toString());
        }
    }

    public boolean isAbsolute() {
        return this._scheme != null || this._host != null;
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
        this._dirty = true;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
        this._dirty = true;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
        this._dirty = true;
    }

    public String getPath() {
        return this._path;
    }

    public String getEncodedPath() {
        return this._encodedPath;
    }

    public void setPath(String path) {
        this._path = path;
        this._encodedPath = URI.encodePath(this._path);
        this._dirty = true;
    }

    public String getQuery() {
        if (this._dirty && this._parameters != null) {
            this._query = this._parameters.encode(__CHARSET);
            if (this._query != null && this._query.length() == 0) {
                this._query = null;
            }
        }
        return this._query;
    }

    public void setQuery(String query) {
        this._query = query;
        if (this._parameters != null) {
            this._parameters.clear();
        } else if (query != null) {
            this._parameters = new UrlEncoded();
        }
        if (query != null) {
            this._parameters.decode(query, __CHARSET);
        }
        this.cleanURI();
    }

    public Set getParameterNames() {
        if (this._parameters == null) {
            return Collections.EMPTY_SET;
        }
        return this._parameters.keySet();
    }

    public MultiMap getParameters() {
        if (this._parameters == null) {
            this._parameters = new UrlEncoded();
        }
        this._dirty = true;
        return this._parameters;
    }

    public Map getUnmodifiableParameters() {
        if (this._parameters == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this._parameters);
    }

    public void putParametersTo(MultiMap map) {
        if (this._parameters != null && this._parameters.size() > 0) {
            map.putAll((Map)this._parameters);
        }
    }

    public void clearParameters() {
        if (this._parameters != null) {
            this._dirty = true;
            this._parameters.clear();
        }
    }

    public void put(String encoded) {
        UrlEncoded params = new UrlEncoded(encoded);
        this.put(params);
    }

    public Object put(Object name, Object value) {
        return this.getParameters().put(name, value);
    }

    public void put(Map values) {
        this.getParameters().putAll(values);
    }

    public String get(String name) {
        if (this._parameters == null) {
            return null;
        }
        return (String)this._parameters.get(name);
    }

    public List getValues(String name) {
        if (this._parameters == null) {
            return null;
        }
        return this._parameters.getValues(name);
    }

    public void remove(String name) {
        if (this._parameters != null) {
            this._dirty = this._parameters.remove(name) != null;
        }
    }

    public String toString() {
        if (this._dirty) {
            this.getQuery();
            this.cleanURI();
        }
        return this._uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanURI() {
        StringBuffer buf;
        StringBuffer stringBuffer = buf = new StringBuffer(this._uri.length() * 2);
        synchronized (stringBuffer) {
            if (this._scheme != null) {
                buf.append(this._scheme);
                buf.append("://");
                buf.append(this._host);
                if (this._port > 0) {
                    buf.append(':');
                    buf.append(this._port);
                }
            }
            buf.append(this._encodedPath);
            if (this._query != null && this._query.length() > 0) {
                buf.append('?');
                buf.append(this._query);
            }
            this._uri = buf.toString();
            this._dirty = false;
        }
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuffer buf = URI.encodePath(null, path);
        return buf == null ? path : buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer encodePath(StringBuffer buf, String path) {
        if (buf == null) {
            block13: for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ' ': 
                    case '#': 
                    case '%': 
                    case ';': 
                    case '?': {
                        buf = new StringBuffer(path.length() << 1);
                        break block13;
                    }
                    default: {
                        continue block13;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            block14: for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        buf.append("%25");
                        continue block14;
                    }
                    case '?': {
                        buf.append("%3F");
                        continue block14;
                    }
                    case ';': {
                        buf.append("%3B");
                        continue block14;
                    }
                    case '#': {
                        buf.append("%23");
                        continue block14;
                    }
                    case ' ': {
                        buf.append("%20");
                        continue block14;
                    }
                    default: {
                        buf.append(c);
                        continue block14;
                    }
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer encodeString(StringBuffer buf, String path, String encode) {
        if (buf == null) {
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c != '%' && encode.indexOf(c) < 0) continue;
                buf = new StringBuffer(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c == '%' || encode.indexOf(c) >= 0) {
                    buf.append('%');
                    StringUtil.append(buf, (byte)(0xFF & c), 16);
                    continue;
                }
                buf.append(c);
            }
        }
        return buf;
    }

    public static String decodePath(String path) {
        int len = path.length();
        byte[] bytes = null;
        int n = 0;
        boolean noDecode = true;
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            byte b = (byte)(0xFF & c);
            if (c == '%' && i + 2 < len) {
                noDecode = false;
                b = (byte)(0xFF & TypeUtil.parseInt(path, i + 1, 2, 16));
                i += 2;
            } else if (bytes == null) {
                ++n;
                continue;
            }
            if (bytes == null) {
                noDecode = false;
                bytes = new byte[len];
                for (int j = 0; j < n; ++j) {
                    bytes[j] = (byte)(0xFF & path.charAt(j));
                }
            }
            bytes[n++] = b;
        }
        if (noDecode) {
            return path;
        }
        try {
            return new String(bytes, 0, n, __CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            return new String(bytes, 0, n);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        URI u = (URI)super.clone();
        if (this._parameters != null) {
            u._parameters = (UrlEncoded)this._parameters.clone();
        }
        this._dirty = false;
        return u;
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p2 == null || p2.length() == 0) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuffer buf = new StringBuffer(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith("/")) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith("/")) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String parentPath(String p) {
        if (p == null || "/".equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    public static String stripPath(String path) {
        if (path == null) {
            return null;
        }
        int semi = path.indexOf(59);
        if (semi < 0) {
            return path;
        }
        return path.substring(0, semi);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int end = path.length();
        int queryIdx = path.indexOf(63);
        int start = path.lastIndexOf(47, queryIdx > 0 ? queryIdx : end);
        block8: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (path.charAt(start + 1) == '.') break block8;
                    break;
                }
                case 3: {
                    if (path.charAt(start + 1) == '.' && path.charAt(start + 2) == '.') break block8;
                }
            }
            end = start;
            start = path.lastIndexOf(47, end - 1);
        }
        if (start >= end) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path);
        int delStart = -1;
        int delEnd = -1;
        int skip = 0;
        block9: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (buf.charAt(start + 1) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    if (start < 0 && buf.length() > 2 && buf.charAt(1) == '/' && buf.charAt(2) == '/') break;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if ((delStart = start) < 0 || delStart == 0 && buf.charAt(delStart) == '/') {
                        ++delStart;
                        if (delEnd >= buf.length() || buf.charAt(delEnd) != '/') break;
                        ++delEnd;
                        break;
                    }
                    if (end == buf.length()) {
                        ++delStart;
                    }
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                case 3: {
                    if (buf.charAt(start + 1) != '.' || buf.charAt(start + 2) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    ++skip;
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                default: {
                    if (skip <= 0 || --skip != 0) break;
                    int n = delStart = start >= 0 ? start : 0;
                    if (delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                    ++delStart;
                }
            }
            if (skip <= 0 && delStart >= 0 && delStart >= 0) {
                buf.delete(delStart, delEnd);
                delEnd = -1;
                delStart = -1;
                if (skip > 0) {
                    delEnd = end;
                }
            }
            end = start--;
            while (start >= 0 && buf.charAt(start) != '/') {
                --start;
            }
        }
        if (skip > 0) {
            return null;
        }
        if (delEnd >= 0) {
            buf.delete(delStart, delEnd);
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }
}

