/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.InclusiveByteRange;
import net.lightbody.bmp.proxy.jetty.http.MultiPartResponse;
import net.lightbody.bmp.proxy.jetty.http.ResourceCache;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHandler;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHttpResponse;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.CachedResource;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.LogSupport;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.util.URI;
import net.lightbody.bmp.proxy.jetty.util.WriterOutputStream;
import org.apache.commons.logging.Log;

public class Default
extends HttpServlet {
    private static Log log = LogFactory.getLog(Default.class);
    private HttpContext _httpContext;
    private ServletHandler _servletHandler;
    private String _AllowString = "GET, POST, HEAD, OPTIONS, TRACE";
    private boolean _acceptRanges = true;
    private boolean _dirAllowed;
    private boolean _putAllowed;
    private boolean _delAllowed;
    private boolean _redirectWelcomeFiles;
    private int _minGzipLength = -1;
    private Resource _resourceBase;

    public void init() throws UnavailableException {
        ServletContext config = this.getServletContext();
        this._servletHandler = ((ServletHandler.Context)config).getServletHandler();
        this._httpContext = this._servletHandler.getHttpContext();
        this._acceptRanges = this.getInitBoolean("acceptRanges");
        this._dirAllowed = this.getInitBoolean("dirAllowed");
        this._putAllowed = this.getInitBoolean("putAllowed");
        this._delAllowed = this.getInitBoolean("delAllowed");
        this._redirectWelcomeFiles = this.getInitBoolean("redirectWelcome");
        this._minGzipLength = this.getInitInt("minGzipLength");
        String rrb = this.getInitParameter("relativeResourceBase");
        if (rrb != null) {
            try {
                this._resourceBase = this._httpContext.getBaseResource().addPath(rrb);
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                throw new UnavailableException(e.toString());
            }
        }
        String rb = this.getInitParameter("resourceBase");
        if (rrb != null && rb != null) {
            throw new UnavailableException("resourceBase & relativeResourceBase");
        }
        if (rb != null) {
            try {
                this._resourceBase = Resource.newResource(rb);
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                throw new UnavailableException(e.toString());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("resource base = " + this._resourceBase));
        }
        if (this._putAllowed) {
            this._AllowString = this._AllowString + ", PUT";
        }
        if (this._delAllowed) {
            this._AllowString = this._AllowString + ", DELETE";
        }
        if (this._putAllowed && this._delAllowed) {
            this._AllowString = this._AllowString + ", MOVE";
        }
    }

    private boolean getInitBoolean(String name) {
        String value = this.getInitParameter(name);
        return value != null && value.length() > 0 && (value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1"));
    }

    private int getInitInt(String name) {
        String value = this.getInitParameter(name);
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    protected Resource getResource(String pathInContext) throws IOException {
        Resource r;
        Resource resource = r = this._resourceBase == null ? this._httpContext.getResource(pathInContext) : this._resourceBase.addPath(pathInContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESOURCE=" + r));
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block20: {
            String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String pathInfo = null;
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            } else {
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            }
            String pathInContext = URI.addPaths(servletPath, pathInfo);
            boolean endsWithSlash = pathInContext.endsWith("/");
            Resource resource = this.getResource(pathInContext);
            String method = request.getMethod();
            if (this._AllowString.indexOf(method) < 0) {
                if (resource != null && resource.exists()) {
                    response.setHeader("Allow", this._AllowString);
                    response.sendError(405);
                } else {
                    response.sendError(404);
                }
                return;
            }
            try {
                if (method.equals("GET") || method.equals("POST") || method.equals("HEAD")) {
                    this.handleGet(request, response, pathInContext, resource, endsWithSlash);
                    break block20;
                }
                if (this._putAllowed && method.equals("PUT")) {
                    this.handlePut(request, response, pathInContext, resource);
                    break block20;
                }
                if (this._delAllowed && method.equals("DELETE")) {
                    this.handleDelete(request, response, pathInContext, resource);
                    break block20;
                }
                if (this._putAllowed && this._delAllowed && method.equals("MOVE")) {
                    this.handleMove(request, response, pathInContext, resource);
                    break block20;
                }
                if (method.equals("OPTIONS")) {
                    this.handleOptions(request, response);
                    break block20;
                }
                if (method.equals("TRACE")) {
                    this._servletHandler.handleTrace(request, response);
                    break block20;
                }
                try {
                    if (resource.exists()) {
                        response.sendError(501);
                        break block20;
                    }
                    this._servletHandler.notFound(request, response);
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
            }
            catch (IllegalArgumentException e) {
                LogSupport.ignore(log, e);
            }
            finally {
                if (resource != null && !(resource instanceof CachedResource)) {
                    resource.release();
                }
            }
        }
    }

    public void handleGet(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource, boolean endsWithSlash) throws ServletException, IOException {
        if (resource == null || !resource.exists()) {
            response.sendError(404);
        } else if (resource.isDirectory()) {
            if (!endsWithSlash && !pathInContext.equals("/")) {
                String q = request.getQueryString();
                StringBuffer buf = request.getRequestURL();
                if (q != null && q.length() != 0) {
                    buf.append('?');
                    buf.append(q);
                }
                response.setContentLength(0);
                response.sendRedirect(response.encodeRedirectURL(URI.addPaths(buf.toString(), "/")));
                return;
            }
            String welcome = this._httpContext.getWelcomeFile(resource);
            if (welcome != null) {
                String ipath = URI.addPaths(pathInContext, welcome);
                if (this._redirectWelcomeFiles) {
                    response.setContentLength(0);
                    response.sendRedirect(URI.addPaths(this._httpContext.getContextPath(), ipath));
                } else {
                    RequestDispatcher dispatcher = this._servletHandler.getRequestDispatcher(ipath);
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
                return;
            }
            if (!this.passConditionalHeaders(request, response, resource)) {
                return;
            }
            this.sendDirectory(request, response, resource, pathInContext.length() > 1);
        } else {
            if (!this.passConditionalHeaders(request, response, resource)) {
                return;
            }
            this.sendData(request, response, pathInContext, resource);
        }
    }

    public void handlePut(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource) throws ServletException, IOException {
        boolean exists;
        boolean bl = exists = resource != null && resource.exists();
        if (exists && !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        if (pathInContext.endsWith("/")) {
            if (!exists) {
                if (!resource.getFile().mkdirs()) {
                    response.sendError(403, "Directories could not be created");
                } else {
                    response.setStatus(201);
                    response.flushBuffer();
                }
            } else {
                response.setStatus(200);
                response.flushBuffer();
            }
        } else {
            try {
                int toRead = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                OutputStream out = resource.getOutputStream();
                if (toRead >= 0) {
                    IO.copy((InputStream)in, out, (long)toRead);
                } else {
                    IO.copy((InputStream)in, out);
                }
                out.close();
                response.setStatus(exists ? 200 : 201);
                response.flushBuffer();
            }
            catch (Exception ex) {
                log.warn((Object)"EXCEPTION ", (Throwable)ex);
                response.sendError(403, ex.getMessage());
            }
        }
    }

    public void handleDelete(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource) throws ServletException, IOException {
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        try {
            if (resource.delete()) {
                response.setStatus(204);
                response.flushBuffer();
            } else {
                response.sendError(403);
            }
        }
        catch (SecurityException sex) {
            log.warn((Object)"EXCEPTION ", (Throwable)sex);
            response.sendError(403, sex.getMessage());
        }
    }

    public void handleMove(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource) throws ServletException, IOException {
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        String newPath = URI.canonicalPath(request.getHeader("new-uri"));
        if (newPath == null) {
            response.sendError(400, "No new-uri");
            return;
        }
        String contextPath = this._httpContext.getContextPath();
        if (contextPath != null && !newPath.startsWith(contextPath)) {
            response.sendError(405, "Not in context");
            return;
        }
        try {
            String newInfo = newPath;
            if (contextPath != null) {
                newInfo = newInfo.substring(contextPath.length());
            }
            Resource newFile = this._httpContext.getBaseResource().addPath(newInfo);
            resource.renameTo(newFile);
            response.setStatus(204);
            response.flushBuffer();
        }
        catch (Exception ex) {
            log.warn((Object)"EXCEPTION ", (Throwable)ex);
            response.sendError(500, "Error:" + ex);
            return;
        }
    }

    public void handleOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setIntHeader("Content-Length", 0);
        response.setHeader("Allow", this._AllowString);
        response.flushBuffer();
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals("HEAD") && request.getAttribute("javax.servlet.include.request_uri") == null) {
            ResourceCache.ResourceMetaData metaData = this._httpContext.getResourceMetaData(resource);
            if (metaData != null) {
                String ifms = request.getHeader("If-Modified-Since");
                String mdlm = metaData.getLastModified();
                if (ifms != null && mdlm != null && ifms.equals(mdlm)) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
            }
            long date = 0L;
            date = request.getDateHeader("If-Unmodified-Since");
            if (date > 0L && resource.lastModified() / 1000L > date / 1000L) {
                response.sendError(412);
                return false;
            }
            date = request.getDateHeader("If-Modified-Since");
            if (date > 0L && resource.lastModified() / 1000L <= date / 1000L) {
                response.reset();
                response.setStatus(304);
                response.flushBuffer();
                return false;
            }
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, boolean parent) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        if (resource instanceof CachedResource) {
            data = ((CachedResource)resource).getCachedData();
        }
        if (data == null) {
            String base = URI.addPaths(request.getRequestURI(), "/");
            String dir = resource.getListHTML(base, parent);
            if (dir == null) {
                response.sendError(403, "No directory");
                return;
            }
            data = dir.getBytes("UTF-8");
            if (resource instanceof CachedResource) {
                ((CachedResource)resource).setCachedData(data);
            }
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        if (!request.getMethod().equals("HEAD")) {
            response.getOutputStream().write(data);
        }
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource) throws IOException {
        Enumeration reqRanges;
        long resLength = resource.length();
        boolean include = request.getAttribute("javax.servlet.include.request_uri") != null;
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        Enumeration enumeration = reqRanges = include ? null : request.getHeaders("Range");
        if (reqRanges == null || !reqRanges.hasMoreElements()) {
            Resource data = resource;
            if (!include) {
                Resource gz;
                String accept;
                if (this._minGzipLength > 0 && (accept = request.getHeader("Accept-Encoding")) != null && resLength > (long)this._minGzipLength && !pathInContext.endsWith(".gz") && (gz = this.getResource(pathInContext + ".gz")).exists() && accept.indexOf("gzip") >= 0 && request.getAttribute("javax.servlet.include.request_uri") == null) {
                    response.setHeader("Content-Encoding", "gzip");
                    data = gz;
                    resLength = data.length();
                }
                this.writeHeaders(response, resource, resLength);
            }
            data.writeTo((OutputStream)out, 0L, resLength);
            return;
        }
        List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, resLength);
        if (ranges == null || ranges.size() == 0) {
            this.writeHeaders(response, resource, resLength);
            response.setStatus(416);
            response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(resLength));
            resource.writeTo((OutputStream)out, 0L, resLength);
            return;
        }
        if (ranges.size() == 1) {
            InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
            long singleLength = singleSatisfiableRange.getSize(resLength);
            this.writeHeaders(response, resource, singleLength);
            response.setStatus(206);
            response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(resLength));
            resource.writeTo((OutputStream)out, singleSatisfiableRange.getFirst(resLength), singleLength);
            return;
        }
        this.writeHeaders(response, resource, -1L);
        ResourceCache.ResourceMetaData metaData = this._httpContext.getResourceMetaData(resource);
        String encoding = metaData.getMimeType();
        MultiPartResponse multi = new MultiPartResponse((OutputStream)response.getOutputStream());
        response.setStatus(206);
        String ctp = request.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
        response.setContentType(ctp + multi.getBoundary());
        InputStream in = resource instanceof CachedResource ? null : resource.getInputStream();
        long pos = 0L;
        for (int i = 0; i < ranges.size(); ++i) {
            InclusiveByteRange ibr = (InclusiveByteRange)ranges.get(i);
            String header = "Content-Range: " + ibr.toHeaderRangeString(resLength);
            multi.startPart(encoding, new String[]{header});
            long start = ibr.getFirst(resLength);
            long size = ibr.getSize(resLength);
            if (in != null) {
                if (start < pos) {
                    in.close();
                    in = resource.getInputStream();
                    pos = 0L;
                }
                if (pos < start) {
                    in.skip(start - pos);
                    pos = start;
                }
                IO.copy(in, (OutputStream)out, size);
                pos += size;
                continue;
            }
            resource.writeTo((OutputStream)out, start, size);
        }
        if (in != null) {
            in.close();
        }
        multi.close();
    }

    protected void writeHeaders(HttpServletResponse response, Resource resource, long count) throws IOException {
        ResourceCache.ResourceMetaData metaData = this._httpContext.getResourceMetaData(resource);
        response.setContentType(metaData.getMimeType());
        if (count != -1L) {
            if (count == resource.length() && response instanceof ServletHttpResponse) {
                response.setHeader("Content-Length", metaData.getLength());
            } else {
                response.setContentLength((int)count);
            }
        }
        response.setHeader("Last-Modified", metaData.getLastModified());
        if (this._acceptRanges) {
            response.setHeader("Accept-Ranges", "bytes");
        }
    }
}

