/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http.handler;

import java.io.IOException;
import java.util.Map;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.PathMap;
import net.lightbody.bmp.proxy.jetty.http.handler.AbstractHttpHandler;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.URI;
import net.lightbody.bmp.proxy.jetty.util.UrlEncoded;
import org.apache.commons.logging.Log;

public class ForwardHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(ForwardHandler.class);
    PathMap _forward = new PathMap();
    String _root;
    boolean _handleQueries = false;

    public ForwardHandler() {
    }

    public ForwardHandler(String rootForward) {
        this._root = rootForward;
    }

    public void addForward(String pathSpecInContext, String newPath) {
        this._forward.put(pathSpecInContext, newPath);
    }

    public void setRootForward(String newPath) {
        this._root = newPath;
    }

    public void setHandleQueries(boolean b) {
        this._handleQueries = b;
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Look for " + pathInContext + " in " + this._forward));
        }
        String newPath = null;
        String query = null;
        if (this._root != null && ("/".equals(pathInContext) || pathInContext.startsWith("/;"))) {
            newPath = this._root;
        } else {
            Map.Entry entry = this._forward.getMatch(pathInContext);
            if (entry != null) {
                int hook;
                String match = (String)entry.getValue();
                if (this._handleQueries && (hook = match.indexOf(63)) != -1) {
                    query = match.substring(hook + 1);
                    match = match.substring(0, hook);
                }
                String info = PathMap.pathInfo((String)entry.getKey(), pathInContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Forward: match:\"" + match + "\" info:" + info + "\" query:" + query));
                }
                String string = newPath = info == null ? match : URI.addPaths(match, info);
            }
        }
        if (newPath != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Forward from " + pathInContext + " to " + newPath));
            }
            int last = request.setState(0);
            String context = this.getHttpContext().getContextPath();
            if (context.length() == 1) {
                request.setPath(newPath);
            } else {
                request.setPath(URI.addPaths(context, newPath));
            }
            if (this._handleQueries && query != null) {
                UrlEncoded.decodeTo(query, request.getParameters());
            }
            request.setState(last);
            this.getHttpContext().getHttpServer().service(request, response);
            return;
        }
    }
}

