/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;

public class RepeatableInputStreamRequestEntity
extends InputStreamEntity {
    private static final int BUFFER_SIZE = 2048;
    private BufferedInputStream content;

    public RepeatableInputStreamRequestEntity(InputStream instream, long length, ContentType contentType) {
        super(instream, length, contentType);
        this.content = new BufferedInputStream(instream, 2048);
    }

    public RepeatableInputStreamRequestEntity(InputStream instream, long length) {
        super(instream, length);
        this.content = new BufferedInputStream(instream, 2048);
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outstream) throws IOException {
        block8: {
            if (outstream == null) {
                throw new IllegalArgumentException("Output stream may not be null");
            }
            this.content.mark((int)this.getContentLength());
            try {
                int l;
                byte[] buffer = new byte[2048];
                if (this.getContentLength() < 0L) {
                    int l2;
                    while ((l2 = this.content.read(buffer)) != -1) {
                        outstream.write(buffer, 0, l2);
                    }
                    break block8;
                }
                for (long remaining = this.getContentLength(); remaining > 0L; remaining -= (long)l) {
                    l = this.content.read(buffer, 0, (int)Math.min(2048L, remaining));
                    if (l == -1) {
                        break;
                    }
                    outstream.write(buffer, 0, l);
                }
            }
            finally {
                this.content.reset();
            }
        }
    }
}

