/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.bricks;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.sitebricks.At;
import com.google.sitebricks.client.transport.Json;
import com.google.sitebricks.client.transport.Text;
import com.google.sitebricks.headless.Reply;
import com.google.sitebricks.headless.Request;
import com.google.sitebricks.headless.Service;
import com.google.sitebricks.http.Delete;
import com.google.sitebricks.http.Get;
import com.google.sitebricks.http.Post;
import com.google.sitebricks.http.Put;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.proxy.ProxyExistsException;
import net.lightbody.bmp.proxy.ProxyManager;
import net.lightbody.bmp.proxy.ProxyPortsExhaustedException;
import net.lightbody.bmp.proxy.ProxyServer;
import net.lightbody.bmp.proxy.http.BrowserMobHttpRequest;
import net.lightbody.bmp.proxy.http.BrowserMobHttpResponse;
import net.lightbody.bmp.proxy.http.RequestInterceptor;
import net.lightbody.bmp.proxy.http.ResponseInterceptor;
import org.java_bandwidthlimiter.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@At(value="/proxy")
@Service
public class ProxyResource {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyResource.class);
    private final ProxyManager proxyManager;

    @Inject
    public ProxyResource(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @Get
    public Reply<?> getProxies() {
        ArrayList<ProxyDescriptor> proxyList = new ArrayList<ProxyDescriptor>();
        for (ProxyServer proxy : this.proxyManager.get()) {
            proxyList.add(new ProxyDescriptor(proxy.getPort()));
        }
        return Reply.with((Object)new ProxyListDescriptor(proxyList)).as(Json.class);
    }

    @Post
    public Reply<?> newProxy(Request<String> request) {
        ProxyServer proxy;
        String systemProxyHost = System.getProperty("http.proxyHost");
        String systemProxyPort = System.getProperty("http.proxyPort");
        String httpProxy = (String)request.param("httpProxy");
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (httpProxy != null) {
            options.put("httpProxy", httpProxy);
        } else if (systemProxyHost != null && systemProxyPort != null) {
            options.put("httpProxy", String.format("%s:%s", systemProxyHost, systemProxyPort));
        }
        String paramBindAddr = (String)request.param("bindAddress");
        Integer paramPort = request.param("port") == null ? null : Integer.valueOf(Integer.parseInt((String)request.param("port")));
        LOG.debug("POST proxy instance on bindAddress `{}` & port `{}`", (Object)paramBindAddr, (Object)paramPort);
        try {
            proxy = this.proxyManager.create(options, paramPort, paramBindAddr);
        }
        catch (ProxyExistsException ex) {
            return Reply.with((Object)new ProxyDescriptor(ex.getPort())).status(455).as(Json.class);
        }
        catch (ProxyPortsExhaustedException ex) {
            return Reply.saying().status(456);
        }
        catch (Exception ex) {
            StringWriter s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            return Reply.with((Object)s).as(Text.class).status(550);
        }
        return Reply.with((Object)new ProxyDescriptor(proxy.getPort())).as(Json.class);
    }

    @Get
    @At(value="/:port/har")
    public Reply<?> getHar(@Named(value="port") int port) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        Har har = proxy.getHar();
        return Reply.with((Object)har).as(Json.class);
    }

    @Put
    @At(value="/:port/har")
    public Reply<?> newHar(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String initialPageRef = (String)request.param("initialPageRef");
        Har oldHar = proxy.newHar(initialPageRef);
        String captureHeaders = (String)request.param("captureHeaders");
        String captureContent = (String)request.param("captureContent");
        String captureBinaryContent = (String)request.param("captureBinaryContent");
        proxy.setCaptureHeaders(Boolean.parseBoolean(captureHeaders));
        proxy.setCaptureContent(Boolean.parseBoolean(captureContent));
        proxy.setCaptureBinaryContent(Boolean.parseBoolean(captureBinaryContent));
        if (oldHar != null) {
            return Reply.with((Object)oldHar).as(Json.class);
        }
        return Reply.saying().noContent();
    }

    @Put
    @At(value="/:port/har/pageRef")
    public Reply<?> setPage(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String pageRef = (String)request.param("pageRef");
        proxy.newPage(pageRef);
        return Reply.saying().ok();
    }

    @Get
    @At(value="/:port/blacklist")
    public Reply<?> getBlacklist(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        return Reply.with(proxy.getBlacklistedUrls()).as(Json.class);
    }

    @Put
    @At(value="/:port/blacklist")
    public Reply<?> blacklist(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String blacklist = (String)request.param("regex");
        int responseCode = this.parseResponseCode((String)request.param("status"));
        String method = (String)request.param("method");
        proxy.blacklistRequests(blacklist, responseCode, method);
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/blacklist")
    public Reply<?> clearBlacklist(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.clearBlacklist();
        return Reply.saying().ok();
    }

    @Get
    @At(value="/:port/whitelist")
    public Reply<?> getWhitelist(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        return Reply.with(proxy.getWhitelistUrls()).as(Json.class);
    }

    @Put
    @At(value="/:port/whitelist")
    public Reply<?> whitelist(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String regex = (String)request.param("regex");
        int responseCode = this.parseResponseCode((String)request.param("status"));
        proxy.whitelistRequests(regex.split(","), responseCode);
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/whitelist")
    public Reply<?> clearWhitelist(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.clearWhitelist();
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/auth/basic/:domain")
    public Reply<?> autoBasicAuth(@Named(value="port") int port, @Named(value="domain") String domain, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        Map credentials = (Map)request.read(HashMap.class).as(Json.class);
        proxy.autoBasicAuthorization(domain, (String)credentials.get("username"), (String)credentials.get("password"));
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/headers")
    public Reply<?> updateHeaders(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        Map headers = (Map)request.read(Map.class).as(Json.class);
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            proxy.addHeader(key, value);
        }
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/interceptor/response")
    public Reply<?> addResponseInterceptor(@Named(value="port") int port, Request<String> request) throws IOException, ScriptException {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        request.readTo((OutputStream)baos);
        ScriptEngineManager mgr = new ScriptEngineManager();
        final ScriptEngine engine = mgr.getEngineByName("JavaScript");
        Compilable compilable = (Compilable)((Object)engine);
        final CompiledScript script = compilable.compile(baos.toString());
        proxy.addResponseInterceptor(new ResponseInterceptor(){

            @Override
            public void process(BrowserMobHttpResponse response, Har har) {
                Bindings bindings = engine.createBindings();
                bindings.put("response", (Object)response);
                bindings.put("har", (Object)har);
                bindings.put("log", (Object)LOG);
                try {
                    script.eval(bindings);
                }
                catch (ScriptException e) {
                    LOG.error("Could not execute JS-based response interceptor", (Throwable)e);
                }
            }
        });
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/interceptor/request")
    public Reply<?> addRequestInterceptor(@Named(value="port") int port, Request<String> request) throws IOException, ScriptException {
        ProxyServer proxy = this.proxyManager.get(port);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        request.readTo((OutputStream)baos);
        ScriptEngineManager mgr = new ScriptEngineManager();
        final ScriptEngine engine = mgr.getEngineByName("JavaScript");
        Compilable compilable = (Compilable)((Object)engine);
        final CompiledScript script = compilable.compile(baos.toString());
        proxy.addRequestInterceptor(new RequestInterceptor(){

            @Override
            public void process(BrowserMobHttpRequest request, Har har) {
                Bindings bindings = engine.createBindings();
                bindings.put("request", (Object)request);
                bindings.put("har", (Object)har);
                bindings.put("log", (Object)LOG);
                try {
                    script.eval(bindings);
                }
                catch (ScriptException e) {
                    LOG.error("Could not execute JS-based response interceptor", (Throwable)e);
                }
            }
        });
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/limit")
    public Reply<?> limit(@Named(value="port") int port, Request<String> request) {
        String enable;
        String maxBitsPerSecond;
        String payloadPercentage;
        String latency;
        String downstreamMaxKB;
        String upstreamMaxKB;
        String downstreamKbps;
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        StreamManager streamManager = proxy.getStreamManager();
        String upstreamKbps = (String)request.param("upstreamKbps");
        if (upstreamKbps != null) {
            try {
                streamManager.setUpstreamKbps(Integer.parseInt(upstreamKbps));
                streamManager.enable();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((downstreamKbps = (String)request.param("downstreamKbps")) != null) {
            try {
                streamManager.setDownstreamKbps(Integer.parseInt(downstreamKbps));
                streamManager.enable();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((upstreamMaxKB = (String)request.param("upstreamMaxKB")) != null) {
            try {
                streamManager.setUpstreamMaxKB(Integer.parseInt(upstreamMaxKB));
                streamManager.enable();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((downstreamMaxKB = (String)request.param("downstreamMaxKB")) != null) {
            try {
                streamManager.setDownstreamMaxKB(Integer.parseInt(downstreamMaxKB));
                streamManager.enable();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((latency = (String)request.param("latency")) != null) {
            try {
                streamManager.setLatency(Integer.parseInt(latency));
                streamManager.enable();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((payloadPercentage = (String)request.param("payloadPercentage")) != null) {
            try {
                streamManager.setPayloadPercentage(Integer.parseInt(payloadPercentage));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((maxBitsPerSecond = (String)request.param("maxBitsPerSecond")) != null) {
            try {
                streamManager.setMaxBitsPerSecondThreshold(Integer.parseInt(maxBitsPerSecond));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((enable = (String)request.param("enable")) != null) {
            if (Boolean.parseBoolean(enable)) {
                streamManager.enable();
            } else {
                streamManager.disable();
            }
        }
        return Reply.saying().ok();
    }

    @Get
    @At(value="/:port/limit")
    public Reply<?> getLimits(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        return Reply.with((Object)new BandwidthLimitDescriptor(proxy.getStreamManager())).as(Json.class);
    }

    @Put
    @At(value="/:port/timeout")
    public Reply<?> timeout(@Named(value="port") int port, Request<String> request) {
        String dnsCacheTimeout;
        String connectionTimeout;
        String readTimeout;
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String requestTimeout = (String)request.param("requestTimeout");
        if (requestTimeout != null) {
            try {
                proxy.setRequestTimeout(Integer.parseInt(requestTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((readTimeout = (String)request.param("readTimeout")) != null) {
            try {
                proxy.setSocketOperationTimeout(Integer.parseInt(readTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((connectionTimeout = (String)request.param("connectionTimeout")) != null) {
            try {
                proxy.setConnectionTimeout(Integer.parseInt(connectionTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((dnsCacheTimeout = (String)request.param("dnsCacheTimeout")) != null) {
            try {
                proxy.setDNSCacheTimeout(Integer.parseInt(dnsCacheTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port")
    public Reply<?> delete(@Named(value="port") int port) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        this.proxyManager.delete(port);
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/hosts")
    public Reply<?> remapHosts(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        Map headers = (Map)request.read(Map.class).as(Json.class);
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            proxy.remapHost(key, value);
            proxy.setDNSCacheTimeout(0);
            proxy.clearDNSCache();
        }
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/wait")
    public Reply<?> wait(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String quietPeriodInMs = (String)request.param("quietPeriodInMs");
        String timeoutInMs = (String)request.param("timeoutInMs");
        proxy.waitForNetworkTrafficToStop(Integer.parseInt(quietPeriodInMs), Integer.parseInt(timeoutInMs));
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/dns/cache")
    public Reply<?> clearDnsCache(@Named(value="port") int port) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.clearDNSCache();
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/rewrite")
    public Reply<?> rewriteUrl(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String match = (String)request.param("matchRegex");
        String replace = (String)request.param("replace");
        proxy.rewriteUrl(match, replace);
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/rewrite")
    public Reply<?> clearRewriteRules(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.clearRewriteRules();
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/retry")
    public Reply<?> retryCount(@Named(value="port") int port, Request<String> request) {
        ProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String count = (String)request.param("retrycount");
        proxy.setRetryCount(Integer.parseInt(count));
        return Reply.saying().ok();
    }

    private int parseResponseCode(String response) {
        int responseCode = 200;
        if (response != null) {
            try {
                responseCode = Integer.parseInt(response);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return responseCode;
    }

    public static class BandwidthLimitDescriptor {
        private long maxUpstreamKB;
        private long remainingUpstreamKB;
        private long maxDownstreamKB;
        private long remainingDownstreamKB;

        public BandwidthLimitDescriptor() {
        }

        public BandwidthLimitDescriptor(StreamManager manager) {
            this.maxDownstreamKB = manager.getMaxDownstreamKB();
            this.remainingDownstreamKB = manager.getRemainingDownstreamKB();
            this.maxUpstreamKB = manager.getMaxUpstreamKB();
            this.remainingUpstreamKB = manager.getRemainingUpstreamKB();
        }

        public long getMaxUpstreamKB() {
            return this.maxUpstreamKB;
        }

        public void setMaxUpstreamKB(long maxUpstreamKB) {
            this.maxUpstreamKB = maxUpstreamKB;
        }

        public long getRemainingUpstreamKB() {
            return this.remainingUpstreamKB;
        }

        public void setRemainingUpstreamKB(long remainingUpstreamKB) {
            this.remainingUpstreamKB = remainingUpstreamKB;
        }

        public long getMaxDownstreamKB() {
            return this.maxDownstreamKB;
        }

        public void setMaxDownstreamKB(long maxDownstreamKB) {
            this.maxDownstreamKB = maxDownstreamKB;
        }

        public long getRemainingDownstreamKB() {
            return this.remainingDownstreamKB;
        }

        public void setRemainingDownstreamKB(long remainingDownstreamKB) {
            this.remainingDownstreamKB = remainingDownstreamKB;
        }
    }

    public static class ProxyListDescriptor {
        private Collection<ProxyDescriptor> proxyList;

        public ProxyListDescriptor() {
        }

        public ProxyListDescriptor(Collection<ProxyDescriptor> proxyList) {
            this.proxyList = proxyList;
        }

        public Collection<ProxyDescriptor> getProxyList() {
            return this.proxyList;
        }

        public void setProxyList(Collection<ProxyDescriptor> proxyList) {
            this.proxyList = proxyList;
        }
    }

    public static class ProxyDescriptor {
        private int port;

        public ProxyDescriptor() {
        }

        public ProxyDescriptor(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

