/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarNameVersion;
import net.lightbody.bmp.core.har.HarPage;
import net.lightbody.bmp.core.util.ThreadUtils;
import net.lightbody.bmp.exception.JettyException;
import net.lightbody.bmp.exception.NameResolutionException;
import net.lightbody.bmp.proxy.BlacklistEntry;
import net.lightbody.bmp.proxy.BrowserMobProxyHandler;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import net.lightbody.bmp.proxy.http.RequestInterceptor;
import net.lightbody.bmp.proxy.http.ResponseInterceptor;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.SocketListener;
import net.lightbody.bmp.proxy.jetty.jetty.Server;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.java_bandwidthlimiter.StreamManager;
import org.openqa.selenium.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer {
    private static final HarNameVersion CREATOR = new HarNameVersion("BrowserMob Proxy", "2.0");
    private static final Logger LOG = LoggerFactory.getLogger(ProxyServer.class);
    private Server server;
    private int port = -1;
    private InetAddress localHost;
    private BrowserMobHttpClient client;
    private StreamManager streamManager;
    private HarPage currentPage;
    private BrowserMobProxyHandler handler;
    private AtomicInteger pageCount = new AtomicInteger(1);
    private AtomicInteger requestCounter = new AtomicInteger(0);
    private String httpProxy;

    public ProxyServer() {
    }

    public ProxyServer(int port) {
        this.port = port;
    }

    public void start() {
        if (this.port == -1) {
            throw new IllegalStateException("Must set port before starting");
        }
        this.streamManager = new StreamManager(100000000L);
        this.server = new Server();
        SocketListener listener = new SocketListener(new InetAddrPort(this.getLocalHost(), this.getPort()));
        this.server.addListener(listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        this.server.addContext(context);
        this.handler = new BrowserMobProxyHandler();
        this.handler.setJettyServer(this.server);
        this.handler.setShutdownLock(new Object());
        this.client = new BrowserMobHttpClient(this.streamManager, this.requestCounter);
        if (this.httpProxy != null) {
            this.client.setHttpProxy(this.httpProxy);
        }
        this.client.prepareForBrowser();
        this.handler.setHttpClient(this.client);
        context.addHandler(this.handler);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new JettyException("Exception occurred when starting the server", e);
        }
        this.setPort(listener.getPort());
    }

    public Proxy seleniumProxy() throws NameResolutionException {
        InetAddress connectableLocalHost;
        Proxy proxy = new Proxy();
        proxy.setProxyType(Proxy.ProxyType.MANUAL);
        try {
            connectableLocalHost = this.getConnectableLocalHost();
        }
        catch (UnknownHostException e) {
            throw new NameResolutionException("Error getting local host when creating seleniumProxy", e);
        }
        String proxyStr = String.format("%s:%d", connectableLocalHost.getCanonicalHostName(), this.getPort());
        proxy.setHttpProxy(proxyStr);
        proxy.setSslProxy(proxyStr);
        return proxy;
    }

    public void cleanup() {
        this.handler.cleanup();
    }

    public void stop() {
        this.cleanup();
        this.client.shutdown();
        try {
            this.server.stop();
        }
        catch (InterruptedException e) {
            throw new JettyException("Exception occurred when stopping the server", e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getLocalHost() {
        if (this.localHost == null) {
            try {
                this.localHost = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("InetAddress.getByName failed to look up 0.0.0.0", e);
            }
        }
        return this.localHost;
    }

    public InetAddress getConnectableLocalHost() throws UnknownHostException {
        if (this.getLocalHost().equals(InetAddress.getByName("0.0.0.0"))) {
            return InetAddress.getLocalHost();
        }
        return this.getLocalHost();
    }

    public void setLocalHost(InetAddress localHost) {
        if (localHost.isAnyLocalAddress() || localHost.isLoopbackAddress()) {
            this.localHost = localHost;
        } else {
            NetworkInterface localInterface;
            try {
                localInterface = NetworkInterface.getByInetAddress(localHost);
            }
            catch (SocketException e) {
                throw new IllegalArgumentException("localHost address must be address of a local adapter (attempted to use: " + localHost + ")", e);
            }
            if (localInterface != null) {
                this.localHost = localHost;
            } else {
                throw new IllegalArgumentException("localHost address must be address of a local adapter (attempted to use: " + localHost + ")");
            }
        }
    }

    public Har getHar() {
        boolean success = ThreadUtils.waitFor(new ThreadUtils.WaitCondition(){

            @Override
            public boolean checkCondition(long elapsedTimeInMs) {
                return ProxyServer.this.requestCounter.get() == 0;
            }
        }, TimeUnit.SECONDS, 5L);
        if (!success) {
            LOG.warn("Waited 5 seconds for requests to cease before returning HAR; giving up!");
        }
        return this.client.getHar();
    }

    public Har newHar(String initialPageRef) {
        this.pageCount.set(0);
        Har oldHar = this.getHar();
        Har har = new Har(new HarLog(CREATOR));
        this.client.setHar(har);
        this.newPage(initialPageRef);
        return oldHar;
    }

    public void newPage(String pageRef) {
        if (pageRef == null) {
            pageRef = "Page " + this.pageCount.get();
        }
        this.client.setHarPageRef(pageRef);
        this.currentPage = new HarPage(pageRef);
        this.client.getHar().getLog().addPage(this.currentPage);
        this.pageCount.incrementAndGet();
    }

    public void endPage() {
        if (this.currentPage == null) {
            return;
        }
        this.currentPage.getPageTimings().setOnLoad(new Date().getTime() - this.currentPage.getStartedDateTime().getTime());
        this.client.setHarPageRef(null);
        this.currentPage = null;
    }

    public void setRetryCount(int count) {
        this.client.setRetryCount(count);
    }

    public void remapHost(String source, String target) {
        this.client.remapHost(source, target);
    }

    @Deprecated
    public void addRequestInterceptor(HttpRequestInterceptor i) {
        this.client.addRequestInterceptor(i);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.client.addRequestInterceptor(interceptor);
    }

    @Deprecated
    public void addResponseInterceptor(HttpResponseInterceptor i) {
        this.client.addResponseInterceptor(i);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.client.addResponseInterceptor(interceptor);
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Deprecated
    public void setDownstreamKbps(long downstreamKbps) {
        this.streamManager.setDownstreamKbps(downstreamKbps);
        this.streamManager.enable();
    }

    @Deprecated
    public void setUpstreamKbps(long upstreamKbps) {
        this.streamManager.setUpstreamKbps(upstreamKbps);
        this.streamManager.enable();
    }

    @Deprecated
    public void setLatency(long latency) {
        this.streamManager.setLatency(latency);
        this.streamManager.enable();
    }

    public void setRequestTimeout(int requestTimeout) {
        this.client.setRequestTimeout(requestTimeout);
    }

    public void setSocketOperationTimeout(int readTimeout) {
        this.client.setSocketOperationTimeout(readTimeout);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.client.setConnectionTimeout(connectionTimeout);
    }

    public void autoBasicAuthorization(String domain, String username, String password) {
        this.client.autoBasicAuthorization(domain, username, password);
    }

    public void rewriteUrl(String match, String replace) {
        this.client.rewriteUrl(match, replace);
    }

    public void clearRewriteRules() {
        this.client.clearRewriteRules();
    }

    public void blacklistRequests(String pattern, int responseCode) {
        this.client.blacklistRequests(pattern, responseCode, null);
    }

    public void blacklistRequests(String pattern, int responseCode, String method) {
        this.client.blacklistRequests(pattern, responseCode, method);
    }

    @Deprecated
    public List<BlacklistEntry> getBlacklistedRequests() {
        return this.client.getBlacklistedRequests();
    }

    public Collection<BlacklistEntry> getBlacklistedUrls() {
        return this.client.getBlacklistedUrls();
    }

    public boolean isWhitelistEnabled() {
        return this.client.isWhitelistEnabled();
    }

    @Deprecated
    public List<Pattern> getWhitelistRequests() {
        return this.client.getWhitelistRequests();
    }

    public Collection<Pattern> getWhitelistUrls() {
        return this.client.getWhitelistUrls();
    }

    public int getWhitelistResponseCode() {
        return this.client.getWhitelistResponseCode();
    }

    public void clearBlacklist() {
        this.client.clearBlacklist();
    }

    public void whitelistRequests(String[] patterns, int responseCode) {
        this.client.whitelistRequests(patterns, responseCode);
    }

    public void enableEmptyWhitelist(int responseCode) {
        this.client.whitelistRequests(new String[0], responseCode);
    }

    public void clearWhitelist() {
        this.client.clearWhitelist();
    }

    public void addHeader(String name, String value) {
        this.client.addHeader(name, value);
    }

    public void setCaptureHeaders(boolean captureHeaders) {
        this.client.setCaptureHeaders(captureHeaders);
    }

    public void setCaptureContent(boolean captureContent) {
        this.client.setCaptureContent(captureContent);
    }

    public void setCaptureBinaryContent(boolean captureBinaryContent) {
        this.client.setCaptureBinaryContent(captureBinaryContent);
    }

    public void clearDNSCache() {
        this.client.clearDNSCache();
    }

    public void setDNSCacheTimeout(int timeout) {
        this.client.setDNSCacheTimeout(timeout);
    }

    public void waitForNetworkTrafficToStop(final long quietPeriodInMs, long timeoutInMs) {
        boolean result = ThreadUtils.waitFor(new ThreadUtils.WaitCondition(){

            @Override
            public boolean checkCondition(long elapsedTimeInMs) {
                Date lastCompleted = null;
                Har har = ProxyServer.this.client.getHar();
                if (har == null || har.getLog() == null) {
                    return true;
                }
                for (HarEntry entry : har.getLog().getEntries()) {
                    if (entry.getResponse().getStatus() < 0) {
                        return false;
                    }
                    Date end = new Date(entry.getStartedDateTime().getTime() + entry.getTime());
                    if (lastCompleted == null) {
                        lastCompleted = end;
                        continue;
                    }
                    if (!end.after(lastCompleted)) continue;
                    lastCompleted = end;
                }
                return lastCompleted != null && System.currentTimeMillis() - lastCompleted.getTime() >= quietPeriodInMs;
            }
        }, TimeUnit.MILLISECONDS, timeoutInMs);
        if (!result) {
            throw new RuntimeException("Timed out after " + timeoutInMs + " ms while waiting for network traffic to stop");
        }
    }

    public void setOptions(Map<String, String> options) {
        if (options.containsKey("httpProxy")) {
            this.httpProxy = options.get("httpProxy");
        }
    }
}

