/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.serialization;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.encoding.Base64Decoder;
import net.lecousin.framework.io.serialization.AbstractDeserializer;
import net.lecousin.framework.io.serialization.Deserializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.math.IntegerUnit;
import net.lecousin.framework.util.ClassUtil;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamEventsAsync;
import net.lecousin.framework.xml.XMLStreamReaderAsync;
import net.lecousin.framework.xml.serialization.XMLCustomSerialization;
import net.lecousin.framework.xml.serialization.XMLCustomSerializer;

public class XMLDeserializer
extends AbstractDeserializer {
    protected String expectedRootNamespaceURI;
    protected String expectedRootLocalName;
    protected Charset forceEncoding;
    protected XMLStreamEventsAsync input;
    private LinkedList<CollectionValueContext> colValueContext = new LinkedList();
    private LinkedList<XMLObjectContext> objects = new LinkedList();

    public XMLDeserializer(String expectedRootNamespaceURI, String expectedRootLocalName) {
        this(expectedRootNamespaceURI, expectedRootLocalName, null);
    }

    public XMLDeserializer(String expectedRootNamespaceURI, String expectedRootLocalName, Charset encoding) {
        this.expectedRootNamespaceURI = expectedRootNamespaceURI;
        this.expectedRootLocalName = expectedRootLocalName;
        this.forceEncoding = encoding;
    }

    public XMLDeserializer(XMLStreamEventsAsync input, String expectedRootNamespaceURI, String expectedRootLocalName) {
        this.input = input;
        this.expectedRootNamespaceURI = expectedRootNamespaceURI;
        this.expectedRootLocalName = expectedRootLocalName;
    }

    public static <T> AsyncWork<T, Exception> deserializeResource(String resourcePath, Class<T> type, byte priority) {
        IO.Readable io = LCCore.getApplication().getResource(resourcePath, priority);
        if (io == null) {
            return new AsyncWork<Object, FileNotFoundException>(null, new FileNotFoundException("Resource not found: " + resourcePath));
        }
        AsyncWork<T, Exception> result = XMLDeserializer.deserialize(io, type);
        result.listenInline(() -> io.closeAsync());
        return result;
    }

    public static <T> AsyncWork<T, Exception> deserializeFile(File file, Class<T> type, byte priority) {
        FileIO.ReadOnly io = new FileIO.ReadOnly(file, priority);
        AsyncWork<T, Exception> result = XMLDeserializer.deserialize(io, type);
        result.listenInline(() -> io.closeAsync());
        return result;
    }

    public static <T> AsyncWork<T, Exception> deserialize(IO.Readable input, Class<T> type) {
        XMLDeserializer deserializer = new XMLDeserializer(null, type.getSimpleName());
        AsyncWork<Object, Exception> res = deserializer.deserialize(new TypeDefinition(type, new TypeDefinition[0]), input, new ArrayList<SerializationRule>(0));
        AsyncWork result = new AsyncWork();
        res.listenInline(obj -> result.unblockSuccess(obj), result);
        return result;
    }

    protected ISynchronizationPoint<Exception> createAndStartReader(IO.Readable input) {
        XMLStreamReaderAsync reader = new XMLStreamReaderAsync(input, this.forceEncoding, 8192);
        this.input = reader;
        reader.setMaximumTextSize(this.maxTextSize);
        reader.setMaximumCDataSize(this.maxTextSize);
        return reader.startRootElement();
    }

    @Override
    public void setMaximumTextSize(int max) {
        super.setMaximumTextSize(max);
        this.input.setMaximumTextSize(this.maxTextSize);
        this.input.setMaximumCDataSize(this.maxTextSize);
    }

    @Override
    protected ISynchronizationPoint<Exception> initializeDeserialization(IO.Readable input) {
        ISynchronizationPoint<Exception> start = this.createAndStartReader(input);
        if (start.isUnblocked()) {
            if (start.hasError()) {
                return start;
            }
            if (this.expectedRootLocalName != null && !this.input.event.localName.equals(this.expectedRootLocalName)) {
                return new SynchronizationPoint<Exception>(new Exception("Expected root XML element is " + this.expectedRootLocalName + ", found is " + this.input.event.localName.asString()));
            }
            if (this.expectedRootNamespaceURI != null && !this.input.getNamespaceURI(this.input.event.namespacePrefix).equals(this.expectedRootNamespaceURI)) {
                return new SynchronizationPoint<Exception>(new Exception("Expected root XML element namespace is " + this.expectedRootNamespaceURI + ", found is " + this.input.getNamespaceURI(this.input.event.namespacePrefix)));
            }
            return start;
        }
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        start.listenInline(() -> {
            if (this.expectedRootLocalName != null && !this.input.event.localName.equals(this.expectedRootLocalName)) {
                sp.error(new Exception("Expected root XML element is " + this.expectedRootLocalName + ", found is " + this.input.event.localName.asString()));
            } else if (this.expectedRootNamespaceURI != null && !this.input.getNamespaceURI(this.input.event.namespacePrefix).equals(this.expectedRootNamespaceURI)) {
                sp.error(new Exception("Expected root XML element namespace is " + this.expectedRootNamespaceURI + ", found is " + this.input.getNamespaceURI(this.input.event.namespacePrefix)));
            } else {
                sp.unblock();
            }
        }, sp);
        return sp;
    }

    @Override
    protected ISynchronizationPoint<Exception> finalizeDeserialization() {
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    protected AsyncWork<Boolean, Exception> deserializeBooleanValue(boolean nullable) {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            if (nullable) {
                return new AsyncWork<Object, Object>(null, null);
            }
            return new AsyncWork<Object, Exception>(null, new Exception("null value found but boolean expected"));
        }
        AsyncWork<UnprotectedStringBuffer, Exception> read = this.input.readInnerText();
        AsyncWork<Boolean, Exception> result = new AsyncWork<Boolean, Exception>();
        read.listenInline(text -> {
            text.toLowerCase();
            if (text.equals("true") || text.equals("yes") || text.equals("1")) {
                result.unblockSuccess(Boolean.TRUE);
            } else if (text.equals("false") || text.equals("no") || text.equals("0")) {
                result.unblockSuccess(Boolean.FALSE);
            } else {
                result.error(new Exception("Invalid boolean value: " + text.asString()));
            }
        }, result);
        return result;
    }

    @Override
    protected AsyncWork<? extends Number, Exception> deserializeNumericValue(Class<?> type, boolean nullable, Class<? extends IntegerUnit> targetUnit) {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            if (nullable) {
                return new AsyncWork<Object, Object>(null, null);
            }
            return new AsyncWork<Object, Exception>(null, new Exception("null value found but number expected"));
        }
        AsyncWork<UnprotectedStringBuffer, Exception> read = this.input.readInnerText();
        AsyncWork result = new AsyncWork();
        read.listenInline(text -> {
            try {
                if (targetUnit != null) {
                    result.unblockSuccess(XMLDeserializer.convertStringToInteger(type, text.asString(), targetUnit));
                } else {
                    XMLDeserializer.convertBigDecimalValue(new BigDecimal(text.asString()), type, result);
                }
            }
            catch (Exception e) {
                result.error(e);
            }
        }, result);
        return result;
    }

    @Override
    protected AsyncWork<? extends CharSequence, Exception> deserializeStringValue() {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            return new AsyncWork<Object, Object>(null, null);
        }
        return this.input.readInnerText();
    }

    @Override
    protected AsyncWork<Boolean, Exception> startCollectionValue() {
        CollectionValueContext ctx = new CollectionValueContext();
        ctx.parent = this.input.event.context.getFirst();
        this.colValueContext.addFirst(ctx);
        return new AsyncWork<Boolean, Object>(Boolean.TRUE, null);
    }

    @Override
    protected AsyncWork<Pair<Object, Boolean>, Exception> deserializeCollectionValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules) {
        CollectionValueContext ctx = this.colValueContext.getFirst();
        AsyncWork<Boolean, Exception> read = this.input.nextInnerElement(ctx.parent, "element");
        if (read.isUnblocked()) {
            if (read.hasError()) {
                return new AsyncWork<Object, Exception>(null, read.getError());
            }
            if (!read.getResult().booleanValue()) {
                this.colValueContext.removeFirst();
                return new AsyncWork<Pair<Object, Boolean>, Object>(new Pair<Object, Boolean>(null, Boolean.FALSE), null);
            }
            AsyncWork element = this.deserializeValue(context, context.getElementType(), colPath + '[' + elementIndex + ']', rules);
            if (element.isUnblocked()) {
                if (element.hasError()) {
                    return new AsyncWork<Object, Exception>(null, element.getError());
                }
                return new AsyncWork(new Pair(element.getResult(), Boolean.TRUE), null);
            }
            AsyncWork<Pair<Object, Boolean>, Exception> result = new AsyncWork<Pair<Object, Boolean>, Exception>();
            element.listenInline(() -> result.unblockSuccess(new Pair(element.getResult(), Boolean.TRUE)), result);
            return result;
        }
        AsyncWork<Pair<Object, Boolean>, Exception> result = new AsyncWork<Pair<Object, Boolean>, Exception>();
        read.listenAsync(new AbstractDeserializer.DeserializationTask(this, () -> {
            if (!((Boolean)read.getResult()).booleanValue()) {
                this.colValueContext.removeFirst();
                result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                return;
            }
            AsyncWork element = this.deserializeValue(context, context.getElementType(), colPath + '[' + elementIndex + ']', rules);
            if (element.isUnblocked()) {
                if (element.hasError()) {
                    result.error(element.getError());
                } else {
                    result.unblockSuccess(new Pair(element.getResult(), Boolean.TRUE));
                }
                return;
            }
            element.listenInline(() -> result.unblockSuccess(new Pair(element.getResult(), Boolean.TRUE)), (ISynchronizationPoint<Exception>)result);
        }), result);
        return result;
    }

    @Override
    protected AsyncWork<Object, Exception> startObjectValue(SerializationContext context, TypeDefinition type, List<SerializationRule> rules) {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            ISynchronizationPoint<Exception> close = this.input.closeElement();
            if (close.isUnblocked()) {
                return new AsyncWork<Object, Exception>(null, close.getError());
            }
            AsyncWork<Object, Exception> res = new AsyncWork<Object, Exception>();
            close.listenInline(() -> res.unblockSuccess(null), res);
            return res;
        }
        XMLObjectContext ctx = new XMLObjectContext();
        ctx.element = this.input.event.context.getFirst();
        ctx.attributes = this.input.event.attributes;
        ctx.endOfAttributes = this.input.event.isClosed;
        this.objects.addFirst(ctx);
        String attrName = "class";
        while (XMLDeserializer.hasAttribute(type.getBase(), attrName)) {
            attrName = "_" + attrName;
        }
        a = this.input.removeAttributeByLocalName(attrName);
        if (a != null) {
            String className = a.value.asString();
            try {
                Class<?> cl = Class.forName(className);
                return new AsyncWork<Object, Object>(SerializationClass.instantiate(new TypeDefinition(cl, new TypeDefinition[0]), context, rules, true), null);
            }
            catch (Exception e) {
                return new AsyncWork<Object, Exception>(null, e);
            }
        }
        try {
            return new AsyncWork<Object, Object>(SerializationClass.instantiate(type, context, rules, false), null);
        }
        catch (Exception e) {
            return new AsyncWork<Object, Exception>(null, e);
        }
    }

    public static boolean hasAttribute(Class<?> type, String name) {
        if (type.equals(Object.class)) {
            return false;
        }
        for (Field f : type.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return true;
        }
        Method m = ClassUtil.getGetter(type, name);
        if (m != null && !m.getDeclaringClass().equals(Object.class)) {
            return true;
        }
        m = ClassUtil.getSetter(type, name);
        if (m != null && !m.getDeclaringClass().equals(Object.class)) {
            return true;
        }
        if (type.getSuperclass() != null) {
            return XMLDeserializer.hasAttribute(type.getSuperclass(), name);
        }
        return false;
    }

    @Override
    protected AsyncWork<String, Exception> deserializeObjectAttributeName(SerializationContext.ObjectContext context) {
        AsyncWork<Boolean, Object> next;
        XMLObjectContext ctx = this.objects.getFirst();
        if (ctx.attributeIndex < ctx.attributes.size()) {
            return new AsyncWork<String, Object>(((XMLStreamEvents.Attribute)((XMLObjectContext)ctx).attributes.get((int)((XMLObjectContext)ctx).attributeIndex)).localName.asString(), null);
        }
        if (ctx.endOfAttributes) {
            try {
                XMLDeserializer.endOfAttributes(ctx, context);
            }
            catch (Exception e) {
                return new AsyncWork<Object, Exception>(null, e);
            }
            this.objects.removeFirst();
            return new AsyncWork<Object, Object>(null, null);
        }
        if (ctx.onNextAttribute) {
            next = new AsyncWork<Boolean, Object>(Boolean.TRUE, null);
            ctx.onNextAttribute = false;
        } else {
            next = this.input.nextInnerElement(ctx.element);
        }
        AsyncWork<String, Exception> result = new AsyncWork<String, Exception>();
        next.listenInline(() -> {
            if (next.hasError()) {
                if (next.getError() instanceof EOFException) {
                    this.objects.removeFirst();
                    result.unblockSuccess(null);
                    return;
                }
                result.error((Exception)next.getError());
                return;
            }
            if (((Boolean)next.getResult()).booleanValue()) {
                String name = this.input.event.text.asString();
                ctx.attributesDone.add(name);
                result.unblockSuccess(name);
            } else {
                try {
                    XMLDeserializer.endOfAttributes(ctx, context);
                }
                catch (Exception e) {
                    result.error(e);
                    return;
                }
                this.objects.removeFirst();
                result.unblockSuccess(null);
            }
        });
        return result;
    }

    private static void endOfAttributes(XMLObjectContext ctx, SerializationContext.ObjectContext context) throws Exception {
        for (SerializationClass.Attribute a : context.getSerializationClass().getAttributes()) {
            String name = a.getName();
            if (!a.canSet() || a.ignore() || ctx.attributesDone.contains(name)) continue;
            boolean found = false;
            for (XMLStreamEvents.Attribute xmlAttr : ctx.attributes) {
                if (!xmlAttr.localName.equals(name)) continue;
                found = true;
                break;
            }
            if (found || a.getType().getBase().isPrimitive() || Collection.class.isAssignableFrom(a.getType().getBase())) continue;
            a.setValue(context.getInstance(), null);
        }
    }

    @Override
    protected AsyncWork<Boolean, Exception> deserializeBooleanAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        XMLObjectContext ctx = this.objects.getFirst();
        if (ctx.attributeIndex < ctx.attributes.size()) {
            XMLStreamEvents.Attribute attr = (XMLStreamEvents.Attribute)ctx.attributes.get(ctx.attributeIndex++);
            attr.value.toLowerCase();
            if (attr.value.equals("true") || attr.value.equals("yes") || attr.value.equals("1")) {
                return new AsyncWork<Boolean, Object>(Boolean.TRUE, null);
            }
            if (attr.value.equals("false") || attr.value.equals("no") || attr.value.equals("0")) {
                return new AsyncWork<Boolean, Object>(Boolean.FALSE, null);
            }
            return new AsyncWork<Object, Exception>(null, new Exception("Invalid boolean value: " + attr.value.asString()));
        }
        return this.deserializeBooleanValue(nullable);
    }

    @Override
    protected AsyncWork<? extends Number, Exception> deserializeNumericAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        XMLObjectContext ctx = this.objects.getFirst();
        IntegerUnit.Unit unit = context.getAttribute().getAnnotation(false, IntegerUnit.Unit.class);
        if (ctx.attributeIndex < ctx.attributes.size()) {
            XMLStreamEvents.Attribute attr = (XMLStreamEvents.Attribute)ctx.attributes.get(ctx.attributeIndex++);
            if (unit != null) {
                try {
                    return new AsyncWork<Number, Object>(XMLDeserializer.convertStringToInteger(context.getAttribute().getType().getBase(), attr.value.asString(), unit.value()), null);
                }
                catch (Exception e) {
                    return new AsyncWork<Object, Exception>(null, e);
                }
            }
            AsyncWork<Number, Exception> result = new AsyncWork<Number, Exception>();
            try {
                BigDecimal n = new BigDecimal(attr.value.asString());
                XMLDeserializer.convertBigDecimalValue(n, context.getAttribute().getType().getBase(), result);
            }
            catch (Exception e) {
                result.error(e);
            }
            return result;
        }
        return this.deserializeNumericValue(context.getAttribute().getType().getBase(), nullable, unit != null ? unit.value() : null);
    }

    @Override
    protected AsyncWork<? extends CharSequence, Exception> deserializeStringAttributeValue(SerializationContext.AttributeContext context) {
        XMLObjectContext ctx = this.objects.getFirst();
        if (ctx.attributeIndex < ctx.attributes.size()) {
            XMLStreamEvents.Attribute attr = (XMLStreamEvents.Attribute)ctx.attributes.get(ctx.attributeIndex++);
            return new AsyncWork<UnprotectedStringBuffer, Object>(attr.value, null);
        }
        return this.deserializeStringValue();
    }

    @Override
    protected AsyncWork<Pair<Object, Boolean>, Exception> deserializeCollectionAttributeValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules) {
        XMLObjectContext ctx = this.objects.getFirst();
        SerializationClass.Attribute colAttr = ((SerializationContext.AttributeContext)context.getParent()).getAttribute();
        AsyncWork<Pair<Object, Boolean>, Exception> result = new AsyncWork<Pair<Object, Boolean>, Exception>();
        if (elementIndex > 0) {
            AsyncWork<Boolean, Exception> next = this.input.nextInnerElement(ctx.element);
            if (next.isUnblocked()) {
                if (next.hasError()) {
                    result.error(next.getError());
                    return result;
                }
                if (!next.getResult().booleanValue()) {
                    ctx.endOfAttributes = true;
                    result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                    return result;
                }
                if (!this.input.event.text.equals(colAttr.getName())) {
                    ctx.onNextAttribute = true;
                    result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                    return result;
                }
            } else {
                next.listenAsync(new AbstractDeserializer.DeserializationTask(this, () -> {
                    if (!((Boolean)next.getResult()).booleanValue()) {
                        ctx.endOfAttributes = true;
                        result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                        return;
                    }
                    if (!this.input.event.text.equals(colAttr.getName())) {
                        ctx.onNextAttribute = true;
                        result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                        return;
                    }
                    this.readColElement(context, colPath + '[' + elementIndex + ']', rules, result);
                }), result);
                return result;
            }
        }
        this.readColElement(context, colPath + '[' + elementIndex + ']', rules, result);
        return result;
    }

    private void readColElement(SerializationContext.CollectionContext context, String elementPath, List<SerializationRule> rules, AsyncWork<Pair<Object, Boolean>, Exception> result) {
        SerializationClass.Attribute a = null;
        for (SerializationContext c = context.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof SerializationContext.AttributeContext)) continue;
            a = ((SerializationContext.AttributeContext)c).getAttribute();
            break;
        }
        XMLCustomSerialization custom = a != null ? a.getAnnotation(false, XMLCustomSerialization.class) : null;
        AsyncWork<Object, Exception> value = null;
        if (custom != null) {
            try {
                XMLCustomSerializer s = custom.value().newInstance();
                if (s.type().equals(context.getElementType())) {
                    value = s.deserialize(this, this.input, rules);
                }
            }
            catch (Exception e) {
                result.error(e);
                return;
            }
        }
        if (value == null) {
            value = this.deserializeValue(context, context.getElementType(), elementPath, rules);
        }
        if (value.isUnblocked()) {
            if (value.hasError()) {
                result.error(value.getError());
            } else {
                result.unblockSuccess(new Pair(value.getResult(), Boolean.TRUE));
            }
        } else {
            value.listenInline(obj -> result.unblockSuccess(new Pair<Object, Boolean>(obj, Boolean.TRUE)), result);
        }
    }

    @Override
    protected AsyncWork<IO.Readable, Exception> deserializeIOReadableValue(SerializationContext context, List<SerializationRule> rules) {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            return new AsyncWork<Object, Object>(null, null);
        }
        SynchronizationPoint<Exception> next = this.input.next();
        AsyncWork<IO.Readable, Exception> result = new AsyncWork<IO.Readable, Exception>();
        next.listenAsync(new AbstractDeserializer.DeserializationTask(this, () -> {
            if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.input.event.type)) {
                String ref = this.input.event.text.asString();
                for (Deserializer.StreamReferenceHandler h : this.streamReferenceHandlers) {
                    if (!h.isReference(ref)) continue;
                    h.getStreamFromReference(ref).listenInline(result);
                    return;
                }
            }
            IOInMemoryOrFile io = new IOInMemoryOrFile(131072, this.priority, "base 64 encoded from XML");
            Base64Decoder decoder = new Base64Decoder(io);
            this.readBase64(decoder, io, result);
        }), result);
        return result;
    }

    private void readNextBase64(Base64Decoder decoder, IOInMemoryOrFile io, AsyncWork<IO.Readable, Exception> result) {
        SynchronizationPoint<Exception> next = this.input.next();
        if (next.isUnblocked()) {
            if (next.hasError()) {
                result.error((Exception)next.getError());
            } else {
                this.readBase64(decoder, io, result);
            }
            return;
        }
        next.listenAsync(new AbstractDeserializer.DeserializationTask(this, () -> this.readBase64(decoder, io, result)), result);
    }

    private void readBase64(Base64Decoder decoder, IOInMemoryOrFile io, AsyncWork<IO.Readable, Exception> result) {
        if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.input.event.type)) {
            this.input.event.text.trim();
            if (this.input.event.text.length() == 0) {
                this.readNextBase64(decoder, io, result);
                return;
            }
            CharBuffer[] buffers = this.input.event.text.asCharBuffers();
            this.decodeBase64(decoder, io, result, buffers, 0);
            return;
        }
        if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.input.event.type)) {
            this.input.closeElement().listenAsync(new AbstractDeserializer.DeserializationTask(this, () -> this.readNextBase64(decoder, io, result)), result);
            return;
        }
        if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.input.event.type)) {
            decoder.flush().listenInlineSP(() -> io.seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, 0L).listenInlineSP(() -> result.unblockSuccess(io), result), result);
            return;
        }
        this.readNextBase64(decoder, io, result);
    }

    private void decodeBase64(Base64Decoder decoder, IOInMemoryOrFile io, AsyncWork<IO.Readable, Exception> result, CharBuffer[] buffers, int index) {
        ISynchronizationPoint<IOException> decode = decoder.decode(buffers[index]);
        decode.listenAsync(new AbstractDeserializer.DeserializationTask(this, () -> {
            if (decode.hasError()) {
                result.error((Exception)decode.getError());
            } else if (index == buffers.length - 1) {
                this.readNextBase64(decoder, io, result);
            } else {
                this.decodeBase64(decoder, io, result, buffers, index + 1);
            }
        }), true);
    }

    @Override
    protected AsyncWork<IO.Readable, Exception> deserializeIOReadableAttributeValue(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        return this.deserializeIOReadableValue(context, rules);
    }

    @Override
    protected AsyncWork<?, Exception> deserializeObjectAttributeValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        XMLCustomSerialization custom = context.getAttribute().getAnnotation(false, XMLCustomSerialization.class);
        if (custom != null) {
            try {
                XMLCustomSerializer s = custom.value().newInstance();
                if (s.type().equals(context.getAttribute().getType())) {
                    return s.deserialize(this, this.input, rules);
                }
            }
            catch (Exception e) {
                return new AsyncWork<Object, Exception>(null, e);
            }
        }
        return super.deserializeObjectAttributeValue(context, path, rules);
    }

    private static class XMLObjectContext {
        private XMLStreamEvents.ElementContext element;
        private int attributeIndex = 0;
        private List<XMLStreamEvents.Attribute> attributes;
        private boolean endOfAttributes = false;
        private boolean onNextAttribute = false;
        private List<String> attributesDone = new LinkedList<String>();

        private XMLObjectContext() {
        }
    }

    private static class CollectionValueContext {
        public XMLStreamEvents.ElementContext parent;

        private CollectionValueContext() {
        }
    }
}

