/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import net.lecousin.framework.xml.dom.XMLCharacterData;
import net.lecousin.framework.xml.dom.XMLDocument;
import net.lecousin.framework.xml.dom.XMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class XMLText
extends XMLCharacterData
implements Text {
    public XMLText(XMLDocument doc, String text) {
        super(doc, text);
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    @Override
    public XMLText cloneNode(boolean deep) {
        XMLText clone = new XMLText(this.doc, this.text);
        this.cloned(clone);
        return clone;
    }

    @Override
    public XMLText splitText(int offset) throws DOMException {
        String s;
        if (this.parent == null) {
            throw new DOMException(4, "Cannot split a text node which has no parent");
        }
        if (offset >= this.text.length()) {
            s = "";
        } else {
            s = this.text.substring(offset);
            this.text = this.text.substring(0, offset);
        }
        XMLNode next = this.getNextSibling();
        XMLText t = new XMLText(this.doc, s);
        if (next == null) {
            this.parent.appendChild(new XMLText(this.doc, s));
        } else {
            this.parent.insertBefore(t, next);
        }
        return t;
    }

    @Override
    public boolean isElementContentWhitespace() {
        for (int i = 0; i < this.text.length(); ++i) {
            if (XMLText.isXMLSpace(this.text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isXMLSpace(char c) {
        return c <= ' ' && (4294977024L >> c & 1L) != 0L;
    }

    @Override
    public String getWholeText() {
        if (this.parent == null) {
            return this.text;
        }
        XMLText first = this;
        while (first.getPreviousSibling() instanceof XMLText) {
            first = (XMLText)first.getPreviousSibling();
        }
        StringBuilder s = new StringBuilder();
        while (true) {
            s.append(first.text);
            if (!(first.getNextSibling() instanceof XMLText)) break;
            first = (XMLText)first.getNextSibling();
        }
        return s.toString();
    }

    @Override
    public XMLText replaceWholeText(String content) throws DOMException {
        this.setData(content);
        if (this.parent == null) {
            return this;
        }
        while (this.getPreviousSibling() instanceof XMLText) {
            this.parent.removeChild(this.getPreviousSibling());
        }
        while (this.getNextSibling() instanceof XMLText) {
            this.parent.removeChild(this.getNextSibling());
        }
        return this;
    }
}

