/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DOMUtil {
    public static Element getChild(Element parent, String childName) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(childName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getChildren(Element parent, String childName) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(childName)) continue;
            children.add((Element)node);
        }
        return children;
    }

    public static String getInnerText(Node node) {
        if (node instanceof Element) {
            return ((Element)node).getTextContent();
        }
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node instanceof Text) {
            return ((Text)node).getData();
        }
        return null;
    }

    public static String getChildText(Element parent, String childName) {
        Element child = DOMUtil.getChild(parent, childName);
        if (child == null) {
            return null;
        }
        return DOMUtil.getInnerText(child);
    }
}

