/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.util.IString;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class UnprotectedString
implements IString {
    private char[] chars;
    private int start;
    private int end;
    private int usableEnd;

    public UnprotectedString(int initialCapacity) {
        this.chars = new char[initialCapacity];
        this.start = 0;
        this.end = -1;
        this.usableEnd = initialCapacity - 1;
    }

    public UnprotectedString(char singleChar) {
        this.chars = new char[]{singleChar};
        this.start = 0;
        this.end = 0;
        this.usableEnd = 0;
    }

    public UnprotectedString(char[] chars, int offset, int len, int usableLength) {
        this.chars = chars;
        this.start = offset;
        this.end = offset + len - 1;
        this.usableEnd = offset + usableLength - 1;
    }

    public UnprotectedString(char[] chars) {
        this(chars, 0, chars.length, chars.length);
    }

    public UnprotectedString(String s) {
        this.chars = s.toCharArray();
        this.start = 0;
        this.usableEnd = this.end = this.chars.length - 1;
    }

    public UnprotectedString(IString s) {
        this.chars = new char[s.length()];
        s.fill(this.chars);
        this.start = 0;
        this.usableEnd = this.end = this.chars.length - 1;
    }

    public UnprotectedString(CharSequence s) {
        this(s.toString());
    }

    @Override
    public int length() {
        return this.end - this.start + 1;
    }

    public void reset() {
        this.end = this.start - 1;
    }

    @Override
    public char charAt(int index) {
        return this.chars[this.start + index];
    }

    @Override
    public void setCharAt(int index, char c) throws IllegalArgumentException {
        if (index < 0 || index > this.end - this.start) {
            throw new IllegalArgumentException("Character index " + index + " does not exist");
        }
        this.chars[this.start + index] = c;
    }

    public int firstChar() {
        if (this.end >= this.start) {
            return this.chars[this.start];
        }
        return -1;
    }

    public int lastChar() {
        if (this.end >= this.start) {
            return this.chars[this.end];
        }
        return -1;
    }

    public int canAppendWithoutEnlarging() {
        return this.usableEnd - this.end;
    }

    private void enlarge(int add) {
        char[] a = new char[this.chars.length + add];
        System.arraycopy(this.chars, this.start, a, 0, this.end - this.start + 1);
        this.end -= this.start;
        this.start = 0;
        this.usableEnd = a.length - 1;
        this.chars = a;
    }

    public void trimToSize() {
        char[] a = new char[this.end - this.start + 1];
        System.arraycopy(this.chars, this.start, a, 0, a.length);
        this.chars = a;
        this.start = 0;
        this.end = a.length - 1;
        this.usableEnd = 0;
    }

    @Override
    public UnprotectedString append(char c) {
        if (this.end == this.usableEnd) {
            this.enlarge(this.chars.length < 1024 ? 512 : this.chars.length >> 1);
        }
        this.chars[++this.end] = c;
        return this;
    }

    @Override
    public UnprotectedString append(char[] chars, int offset, int len) {
        if (this.usableEnd - this.end < len) {
            int l;
            int n = l = chars.length < 1024 ? 512 : chars.length >> 1;
            if (l < len) {
                l = len;
            }
            this.enlarge(l);
        }
        System.arraycopy(chars, offset, this.chars, this.end + 1, len);
        this.end += len;
        return this;
    }

    @Override
    public UnprotectedString append(CharSequence s) {
        if (s instanceof UnprotectedString) {
            UnprotectedString us = (UnprotectedString)s;
            this.append(us.chars, us.start, us.end - us.start + 1);
            return this;
        }
        if (s instanceof UnprotectedStringBuffer) {
            UnprotectedStringBuffer usb = (UnprotectedStringBuffer)s;
            int l = usb.length();
            if (l == 0) {
                return this;
            }
            if (l >= this.usableEnd - this.end) {
                this.enlarge(l);
            }
            int i = 0;
            do {
                UnprotectedString us = usb.getUnprotectedString(i);
                System.arraycopy(us.chars, us.start, this.chars, this.end + 1, us.length());
                this.end += us.length();
            } while (++i < usb.getNbUsableUnprotectedStrings());
            return this;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            this.append(s.charAt(i));
        }
        return this;
    }

    @Override
    public int indexOf(char c, int pos) {
        for (int i = this.start + pos; i <= this.end; ++i) {
            if (this.chars[i] != c) continue;
            return i - this.start;
        }
        return -1;
    }

    @Override
    public int indexOf(CharSequence s, int pos) {
        int l = s.length();
        if (this.start + pos + l - 1 > this.end) {
            return -1;
        }
        char first = s.charAt(0);
        for (int i = this.start + pos; i <= this.end - l + 1; ++i) {
            int j;
            if (this.chars[i] != first) continue;
            for (j = 1; j < l && s.charAt(j) == this.chars[i + j]; ++j) {
            }
            if (j != l) continue;
            return i - this.start;
        }
        return -1;
    }

    @Override
    public String subSequence(int start, int end) {
        if (end <= start) {
            throw new IllegalArgumentException("Cannot create substring from " + start + " to " + end);
        }
        return new String(this.chars, this.start + start, end - start);
    }

    @Override
    public UnprotectedString substring(int start, int end) {
        if (this.start + end > this.end) {
            end = this.end - this.start + 1;
        }
        if (end <= start) {
            return new UnprotectedString(0);
        }
        return new UnprotectedString(this.chars, this.start + start, end - start, end - start);
    }

    @Override
    public UnprotectedString substring(int start) {
        if (this.start + start > this.end) {
            return new UnprotectedString(0);
        }
        return new UnprotectedString(this.chars, this.start + start, this.end - (this.start + start) + 1, this.end - (this.start + start) + 1);
    }

    @Override
    public UnprotectedString trimBeginning() {
        while (this.start <= this.end && Character.isWhitespace(this.chars[this.start])) {
            ++this.start;
        }
        return this;
    }

    @Override
    public UnprotectedString trimEnd() {
        while (this.end >= this.start && Character.isWhitespace(this.chars[this.end])) {
            --this.end;
        }
        return this;
    }

    @Override
    public UnprotectedString replace(char oldChar, char newChar) {
        for (int i = this.start; i <= this.end; ++i) {
            if (this.chars[i] != oldChar) continue;
            this.chars[i] = newChar;
        }
        return this;
    }

    @Override
    public UnprotectedString removeEndChars(int nb) {
        this.end -= nb;
        if (this.end < this.start - 1) {
            this.end = this.start - 1;
        }
        return this;
    }

    @Override
    public UnprotectedString removeStartChars(int nb) {
        this.start += nb;
        if (this.start > this.end) {
            this.start = this.end + 1;
        }
        return this;
    }

    public void moveForward(int skip) {
        this.start += skip;
    }

    @Override
    public int fill(char[] chars, int start) {
        int pos = 0;
        for (int i = this.start; i <= this.end; ++i) {
            chars[start + pos++] = this.chars[i];
        }
        return pos;
    }

    @Override
    public int fillUsAsciiBytes(byte[] bytes, int start) {
        int pos = 0;
        for (int i = this.start; i <= this.end; ++i) {
            bytes[start + pos++] = (byte)this.chars[i];
        }
        return pos;
    }

    public List<UnprotectedString> split(char sep) {
        LinkedList<UnprotectedString> list = new LinkedList<UnprotectedString>();
        int pos = this.start;
        while (pos <= this.end) {
            int found;
            for (found = pos; found <= this.end && this.chars[found] != sep; ++found) {
            }
            list.add(this.substring(pos - this.start, found - this.start));
            pos = found + 1;
        }
        return list;
    }

    @Override
    public UnprotectedString toLowerCase() {
        for (int i = this.start; i <= this.end; ++i) {
            this.chars[i] = Character.toLowerCase(this.chars[i]);
        }
        return this;
    }

    @Override
    public UnprotectedString toUpperCase() {
        for (int i = this.start; i <= this.end; ++i) {
            this.chars[i] = Character.toUpperCase(this.chars[i]);
        }
        return this;
    }

    @Override
    public boolean startsWith(CharSequence start) {
        int l = start.length();
        if (this.end - this.start + 1 < l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.chars[this.start + i] == start.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(CharSequence end) {
        int l = end.length();
        if (this.end - this.start + 1 < l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.chars[this.end - i] == end.charAt(l - 1 - i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.end < this.start) {
            return "";
        }
        return new String(this.chars, this.start, this.end - this.start + 1);
    }

    public CharBuffer asCharBuffer() {
        return CharBuffer.wrap(this.chars, this.start, this.end - this.start + 1);
    }

    @Override
    public CharBuffer[] asCharBuffers() {
        return new CharBuffer[]{this.asCharBuffer()};
    }

    public char[] charArray() {
        return this.chars;
    }

    public int charArrayStart() {
        return this.start;
    }

    public int countChar(char c) {
        int count = 0;
        for (int i = this.start; i <= this.end; ++i) {
            if (this.chars[i] != c) continue;
            ++count;
        }
        return count;
    }
}

