/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.ParseException;
import net.lecousin.framework.util.StringFormat;

public interface StringParser<T> {
    public T parse(String var1) throws ParseException;

    public static <T> T parse(Class<T> type, StringFormat format, String string) throws ParseException, IllegalArgumentException {
        StringParser<?> parser;
        if (!format.pattern().isEmpty()) {
            try {
                parser = format.parser().getConstructor(String.class).newInstance(format.pattern());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instantiate StringParser class " + format.parser().getName() + " with pattern " + format.pattern(), e);
            }
        }
        try {
            parser = format.parser().newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate StringParser class " + format.parser().getName(), e);
        }
        Object o = parser.parse(string);
        if (o != null && !type.isAssignableFrom(o.getClass())) {
            throw new IllegalArgumentException("StringParser class " + format.parser().getName() + " is not compatible with target type " + type.getName());
        }
        return (T)o;
    }

    public static <T> T parse(Class<T> type, String string) throws IllegalArgumentException {
        Constructor<Parse> ctor;
        Object o;
        Method parse;
        try {
            parse = type.getMethod("parse", String.class);
            if ((parse.getModifiers() & 8) == 0 || !type.isAssignableFrom(parse.getReturnType())) {
                parse = null;
            }
        }
        catch (Exception e) {
            parse = null;
        }
        if (parse != null) {
            try {
                o = parse.invoke(null, string);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Method parse on class " + type.getName() + " error", e);
            }
        }
        try {
            ctor = type.getConstructor(String.class);
            if (ctor.getAnnotation(Parse.class) == null) {
                ctor = null;
            }
        }
        catch (Exception e) {
            ctor = null;
        }
        if (ctor == null) {
            throw new IllegalArgumentException("Class " + type.getName() + " does not provide a static parse method neither a Parse constructor");
        }
        try {
            o = ctor.newInstance(string);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Constructor of class " + type.getName() + " error", e);
        }
        return (T)o;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.CONSTRUCTOR})
    public static @interface Parse {
    }
}

