/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.util.ArrayList;
import java.util.HashSet;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.Event;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.util.CloseableListenable;
import net.lecousin.framework.util.IConcurrentCloseable;

public abstract class ConcurrentCloseable
implements IConcurrentCloseable {
    private boolean open = true;
    private HashSet<ISynchronizationPoint<?>> pendingOperations = new HashSet(5);
    private SynchronizationPoint<Exception> closing = null;
    private Event<CloseableListenable> closeEvent = null;
    private int closeLocked = 0;
    private SynchronizationPoint<Exception> waitForClose = null;

    public abstract byte getPriority();

    protected abstract ISynchronizationPoint<?> closeUnderlyingResources();

    protected abstract void closeResources(SynchronizationPoint<Exception> var1);

    public boolean isClosing() {
        return this.open && this.closing != null;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCloseListener(Listener<CloseableListenable> listener) {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closing == null && this.open) {
                if (this.closeEvent == null) {
                    this.closeEvent = new Event();
                }
                this.closeEvent.addListener(listener);
                return;
            }
        }
        listener.fire(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCloseListener(Runnable listener) {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closing == null && this.open) {
                if (this.closeEvent == null) {
                    this.closeEvent = new Event();
                }
                this.closeEvent.addListener(listener);
                return;
            }
        }
        listener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCloseListener(Listener<CloseableListenable> listener) {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closeEvent == null) {
                return;
            }
            this.closeEvent.removeListener(listener);
            if (!this.closeEvent.hasListeners()) {
                this.closeEvent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCloseListener(Runnable listener) {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closeEvent == null) {
                return;
            }
            this.closeEvent.removeListener(listener);
            if (!this.closeEvent.hasListeners()) {
                this.closeEvent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockClose() {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closing != null) {
                return false;
            }
            ++this.closeLocked;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockClose() {
        boolean unblock = false;
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (--this.closeLocked == 0) {
                unblock = this.waitForClose != null;
            }
        }
        if (unblock) {
            this.closeAsync();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closeLocked > 0) {
            return;
        }
        this.closeAsync();
        this.closing.blockThrow(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISynchronizationPoint<Exception> closeAsync() {
        ArrayList pending;
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closeLocked > 0) {
                if (this.waitForClose == null) {
                    this.waitForClose = new SynchronizationPoint();
                }
                return this.waitForClose;
            }
            if (this.closing != null) {
                return this.closing;
            }
            this.closing = new SynchronizationPoint();
        }
        byte prio = this.getPriority();
        JoinPoint jp = new JoinPoint();
        HashSet<ISynchronizationPoint<?>> hashSet = this.pendingOperations;
        synchronized (hashSet) {
            pending = new ArrayList(this.pendingOperations);
            this.pendingOperations.clear();
        }
        for (ISynchronizationPoint iSynchronizationPoint : pending) {
            jp.addToJoinNoException(iSynchronizationPoint);
        }
        ISynchronizationPoint<?> underlying = this.closeUnderlyingResources();
        if (underlying != null) {
            jp.addToJoinNoException(underlying);
        }
        jp.start();
        jp.listenAsync(new Task.Cpu.FromRunnable("Closing resources", prio, () -> {
            ConcurrentCloseable concurrentCloseable = this;
            synchronized (concurrentCloseable) {
                this.open = false;
            }
            if (this.closeEvent != null) {
                this.closeEvent.fire(this);
                this.closeEvent = null;
            }
            this.closeResources(this.closing);
        }), true);
        jp.listenTime(60000L, () -> {
            StringBuilder s = new StringBuilder();
            s.append("Closeable still waiting for pending operations: ").append(this);
            for (ISynchronizationPoint op : pending) {
                if (op.isUnblocked()) continue;
                s.append("\r\n - ").append(op);
                for (Object o : op.getAllListeners()) {
                    s.append("\r\n    - ").append(o);
                }
            }
            if (underlying != null && !underlying.isUnblocked()) {
                s.append("\r\n - closeUnderlyingResources");
            }
            LCCore.getApplication().getDefaultLogger().error(s.toString());
            jp.error(new Exception("Closeable still waiting for pending operations after 1 minute, close forced"));
        });
        if (this.waitForClose != null) {
            this.closing.listenInline(this.waitForClose);
        }
        return this.closing;
    }

    private static CancelException createCancellation() {
        return new CancelException("Resource closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ISynchronizationPoint<?>> T operation(T op) {
        if (op.isUnblocked()) {
            return op;
        }
        if (this.closing != null) {
            op.cancel(ConcurrentCloseable.createCancellation());
            return op;
        }
        HashSet<ISynchronizationPoint<?>> hashSet = this.pendingOperations;
        synchronized (hashSet) {
            if (this.closing == null) {
                this.pendingOperations.add(op);
            }
        }
        if (this.closing != null) {
            op.cancel(ConcurrentCloseable.createCancellation());
            return op;
        }
        op.listenInline(() -> {
            HashSet<ISynchronizationPoint<?>> hashSet = this.pendingOperations;
            synchronized (hashSet) {
                this.pendingOperations.remove(op);
            }
        });
        return op;
    }

    protected <T extends Task<?, ?>> T operation(T task) {
        this.operation(task.getOutput());
        return task;
    }
}

