/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import net.lecousin.framework.event.Event;
import net.lecousin.framework.event.Listener;

public interface CloseableListenable {
    public void close() throws Exception;

    public boolean isClosed();

    public void addCloseListener(Listener<CloseableListenable> var1);

    public void addCloseListener(Runnable var1);

    public void removeCloseListener(Listener<CloseableListenable> var1);

    public void removeCloseListener(Runnable var1);

    public static class Impl
    implements CloseableListenable {
        private Event<CloseableListenable> event = new Event();
        private boolean closed = false;

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            this.closed = true;
            this.event.fire(this);
        }

        @Override
        public void addCloseListener(Listener<CloseableListenable> listener) {
            this.event.addListener(listener);
        }

        @Override
        public void addCloseListener(Runnable listener) {
            this.event.addListener(listener);
        }

        @Override
        public void removeCloseListener(Listener<CloseableListenable> listener) {
            this.event.removeListener(listener);
        }

        @Override
        public void removeCloseListener(Runnable listener) {
            this.event.removeListener(listener);
        }
    }
}

