/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.progress;

import java.util.List;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.mutable.MutableLong;

public interface WorkProgress {
    public void setAmount(long var1);

    public long getAmount();

    public void setPosition(long var1);

    public long getPosition();

    public long getRemainingWork();

    public void progress(long var1);

    public void done();

    public void error(Exception var1);

    public void cancel(CancelException var1);

    public ISynchronizationPoint<Exception> getSynch();

    public void listen(Runnable var1);

    public void unlisten(Runnable var1);

    public void interruptEvents();

    public void resumeEvents(boolean var1);

    public String getText();

    public void setText(String var1);

    public String getSubText();

    public void setSubText(String var1);

    public static void linkTo(final WorkProgress progress, final ISynchronizationPoint<?> sp) {
        sp.listenInline(new Runnable(){

            @Override
            public void run() {
                if (sp.hasError()) {
                    progress.error((Exception)sp.getError());
                } else if (sp.isCancelled()) {
                    progress.cancel(sp.getCancelEvent());
                } else {
                    progress.done();
                }
            }
        });
    }

    public static void linkTo(WorkProgress progress, Task<?, ?> task) {
        WorkProgress.linkTo(progress, task.getOutput());
    }

    public static void link(final WorkProgress subTask, final WorkProgress progress, final long work) {
        final MutableLong sent = new MutableLong(0L);
        subTask.getSynch().listenInline(new Runnable(){

            @Override
            public void run() {
                if (subTask.getSynch().hasError()) {
                    progress.error(subTask.getSynch().getError());
                } else if (subTask.getSynch().isCancelled()) {
                    progress.cancel(subTask.getSynch().getCancelEvent());
                } else {
                    progress.progress(work - sent.get());
                    sent.set(work);
                }
            }
        });
        if (subTask.getSynch().isUnblocked()) {
            return;
        }
        Runnable listener = () -> {
            long done = subTask.getPosition() * work / subTask.getAmount();
            if (sent.get() < done && !progress.getSynch().isUnblocked()) {
                progress.progress(done - sent.get());
                sent.set(done);
            }
        };
        listener.run();
        subTask.listen(listener);
    }

    public static interface MultiTask {
        public List<? extends SubTask> getTasks();

        public SubTask addTask(WorkProgress var1, long var2);

        public void removeTask(SubTask var1);

        public static interface SubTask {
            public long getWorkOnParent();

            public WorkProgress getProgress();

            public static class Wrapper
            implements SubTask {
                protected WorkProgress progress;
                protected long amount;

                public Wrapper(WorkProgress progress, long amount) {
                    this.progress = progress;
                    this.amount = amount;
                }

                @Override
                public long getWorkOnParent() {
                    return this.amount;
                }

                @Override
                public WorkProgress getProgress() {
                    return this.progress;
                }
            }
        }
    }
}

