/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Provider;

public class SimpleCache<Key, Data>
implements IMemoryManageable,
Closeable {
    private String description;
    private Provider.FromValue<Key, Data> provider;
    private HashMap<Key, Pair<Data, Long>> cache = new HashMap();

    public SimpleCache(String description, Provider.FromValue<Key, Data> provider) {
        this.description = description;
        this.provider = provider;
        MemoryManager.register(this);
    }

    @Override
    public void close() {
        MemoryManager.unregister(this);
        this.cache = null;
        this.provider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data get(Key key) {
        HashMap<Key, Pair<Data, Long>> hashMap = this.cache;
        synchronized (hashMap) {
            Pair<Data, Long> p = this.cache.get(key);
            if (p != null) {
                p.setValue2(System.currentTimeMillis());
                return p.getValue1();
            }
            p = new Pair<Data, Long>(this.provider.provide(key), System.currentTimeMillis());
            this.cache.put(key, p);
            return p.getValue1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Key key) {
        HashMap<Key, Pair<Data, Long>> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.remove(key);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getItemsDescription() {
        HashMap<Key, Pair<Data, Long>> hashMap = this.cache;
        synchronized (hashMap) {
            ArrayList<String> list = new ArrayList<String>(this.cache.size());
            for (Pair<Data, Long> p : this.cache.values()) {
                list.add("Last usage " + (System.currentTimeMillis() - p.getValue2()) + "ms. ago: " + p.getValue1());
            }
            return list;
        }
    }

    @Override
    public void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        switch (level) {
            default: {
                this.free(System.currentTimeMillis() - 600000L);
                break;
            }
            case LOW: {
                this.free(System.currentTimeMillis() - 120000L);
                break;
            }
            case MEDIUM: {
                this.free(System.currentTimeMillis() - 30000L);
                break;
            }
            case URGENT: {
                this.free(System.currentTimeMillis() - 3000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void free(long keepTime) {
        ArrayList<Key> toRemove = new ArrayList<Key>();
        HashMap<Key, Pair<Data, Long>> hashMap = this.cache;
        synchronized (hashMap) {
            for (Map.Entry<Key, Pair<Data, Long>> e : this.cache.entrySet()) {
                if (e.getValue().getValue2() >= keepTime) continue;
                toRemove.add(e.getKey());
            }
            for (Map.Entry<Object, Pair<Object, Long>> k : toRemove) {
                this.cache.remove(k);
            }
        }
    }
}

