/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.util.StringParser;

public class FragmentedRangeLong
extends LinkedList<RangeLong> {
    private static final long serialVersionUID = -2633315842445860994L;

    public FragmentedRangeLong() {
    }

    public FragmentedRangeLong(RangeLong r) {
        this.add(r);
    }

    @StringParser.Parse
    public FragmentedRangeLong(String string) throws ParseException, NumberFormatException {
        String[] ranges;
        if (string == null || string.isEmpty()) {
            return;
        }
        char c = string.charAt(0);
        if (c == '{') {
            int end = string.indexOf(125);
            if (end < 0) {
                throw new ParseException("Missing }", 0);
            }
            string = string.substring(1, end);
        }
        for (String range : ranges = string.split(",")) {
            if ((range = range.trim()).isEmpty()) continue;
            this.addRange(new RangeLong(range));
        }
    }

    public static FragmentedRangeLong intersect(FragmentedRangeLong list1, FragmentedRangeLong list2) {
        FragmentedRangeLong result = new FragmentedRangeLong();
        if (list1.isEmpty() || list2.isEmpty()) {
            return result;
        }
        block0: for (RangeLong r1 : list1) {
            for (RangeLong r2 : list2) {
                if (r2.max < r1.min) continue;
                if (r2.min > r1.max) continue block0;
                long min = r1.min < r2.min ? r2.min : r1.min;
                long max = r1.max > r2.max ? r2.max : r1.max;
                result.addRange(min, max);
            }
        }
        return result;
    }

    public FragmentedRangeLong copy() {
        FragmentedRangeLong c = new FragmentedRangeLong();
        for (RangeLong r : this) {
            c.add(new RangeLong(r));
        }
        return c;
    }

    public void addRange(RangeLong r) {
        this.addRange(r.min, r.max);
    }

    public void addRange(long start, long end) {
        if (this.isEmpty()) {
            this.add(new RangeLong(start, end));
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            RangeLong r = (RangeLong)this.get(i);
            if (end < r.min) {
                if (end == r.min - 1L) {
                    r.min = start;
                } else {
                    this.add(i, new RangeLong(start, end));
                }
                return;
            }
            if (start == r.max + 1L) {
                r.max = end;
                int j = i + 1;
                while (j < this.size()) {
                    RangeLong r2 = (RangeLong)this.get(j);
                    if (end < r2.min - 1L) break;
                    if (end == r2.min - 1L) {
                        r.max = r2.max;
                        this.remove(j);
                        break;
                    }
                    if (end >= r2.max) {
                        this.remove(j);
                        continue;
                    }
                    r.max = r2.max;
                    this.remove(j);
                    break;
                }
                return;
            }
            if (start > r.max) continue;
            if (start < r.min) {
                r.min = start;
            }
            if (end <= r.max) {
                return;
            }
            r.max = end;
            int j = i + 1;
            while (j < this.size()) {
                RangeLong r2 = (RangeLong)this.get(j);
                if (end >= r2.max) {
                    this.remove(j);
                    continue;
                }
                if (end < r2.min - 1L) break;
                r.max = r2.max;
                this.remove(j);
                break;
            }
            return;
        }
        this.add(new RangeLong(start, end));
    }

    public void addRanges(Collection<RangeLong> ranges) {
        for (RangeLong r : ranges) {
            this.addRange(r);
        }
    }

    public void addValue(long value) {
        if (this.isEmpty()) {
            this.add(new RangeLong(value, value));
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            RangeLong r = (RangeLong)this.get(i);
            if (value < r.min) {
                if (value == r.min - 1L) {
                    r.min = value;
                } else {
                    this.add(i, new RangeLong(value, value));
                }
                return;
            }
            if (value == r.max + 1L) {
                r.max = value;
                if (i < this.size() - 1) {
                    RangeLong r2 = (RangeLong)this.get(i + 1);
                    if (r2.min == value + 1L) {
                        r.max = r2.max;
                        this.remove(i + 1);
                    }
                }
                return;
            }
            if (value > r.max) continue;
            return;
        }
        this.add(new RangeLong(value, value));
    }

    public boolean containsValue(long val) {
        for (RangeLong r : this) {
            if (val >= r.min && val <= r.max) {
                return true;
            }
            if (val >= r.min) continue;
            return false;
        }
        return false;
    }

    public boolean containsRange(long min, long max) {
        for (RangeLong r : this) {
            if (min >= r.min && max <= r.max) {
                return true;
            }
            if (min >= r.min) continue;
            return false;
        }
        return false;
    }

    public boolean containsOneValueIn(RangeLong range) {
        for (RangeLong r : this) {
            if (r.max < range.min) continue;
            if (r.min > range.max) break;
            return true;
        }
        return false;
    }

    public boolean containsOneValueIn(Collection<RangeLong> ranges) {
        for (RangeLong r : ranges) {
            if (!this.containsOneValueIn(r)) continue;
            return true;
        }
        return false;
    }

    public long getMin() {
        if (this.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return ((RangeLong)this.getFirst()).min;
    }

    public long getMax() {
        if (this.isEmpty()) {
            return Long.MIN_VALUE;
        }
        return ((RangeLong)this.getLast()).max;
    }

    public RangeLong removeBestRangeForSize(long size) {
        RangeLong best = null;
        long bestSize = Long.MAX_VALUE;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            long s;
            RangeLong r = (RangeLong)it.next();
            if (r.max - r.min + 1L == size) {
                it.remove();
                return r;
            }
            if (r.max - r.min + 1L < size || (s = r.max - r.min + 1L) >= bestSize) continue;
            best = r;
            bestSize = s;
        }
        if (best == null) {
            return null;
        }
        RangeLong res = new RangeLong(best.min, best.min + size - 1L);
        best.min += size;
        return res;
    }

    public RangeLong removeBiggestRange() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1) {
            return (RangeLong)this.remove(0);
        }
        int biggestIndex = 0;
        RangeLong r = (RangeLong)this.get(0);
        long biggestSize = r.max - r.min + 1L;
        for (int i = 1; i < this.size(); ++i) {
            r = (RangeLong)this.get(i);
            if (r.max - r.min + 1L <= biggestSize) continue;
            biggestSize = r.max - r.min + 1L;
            biggestIndex = i;
        }
        return (RangeLong)this.remove(biggestIndex);
    }

    public Long removeFirstValue() {
        if (this.isEmpty()) {
            return null;
        }
        RangeLong r = (RangeLong)this.getFirst();
        long value = r.min;
        if (r.min == r.max) {
            this.removeFirst();
        } else {
            ++r.min;
        }
        return value;
    }

    public void removeRange(long start, long end) {
        for (int i = 0; i < this.size(); ++i) {
            RangeLong r = (RangeLong)this.get(i);
            if (r.min > end) {
                return;
            }
            if (r.max < start) continue;
            if (r.min < start) {
                if (r.max == end) {
                    r.max = start - 1L;
                    return;
                }
                if (r.max < end) {
                    long j = r.max;
                    r.max = start - 1L;
                    start = j + 1L;
                    continue;
                }
                RangeLong nr = new RangeLong(end + 1L, r.max);
                r.max = start - 1L;
                this.add(i + 1, nr);
                return;
            }
            if (r.min == start) {
                if (r.max == end) {
                    this.remove(i);
                    return;
                }
                if (r.max < end) {
                    this.remove(i);
                    start = r.max + 1L;
                    --i;
                    continue;
                }
                r.min = end + 1L;
                return;
            }
            if (r.max == end) {
                this.remove(i);
                return;
            }
            if (r.max < end) {
                this.remove(i);
                start = r.max + 1L;
                --i;
                continue;
            }
            r.min = end + 1L;
            return;
        }
    }

    public void removeValue(long value) {
        this.removeRange(value, value);
    }

    public long getTotalSize() {
        long total = 0L;
        for (RangeLong r : this) {
            total += r.max - r.min + 1L;
        }
        return total;
    }

    public long removeValueAt(long index) throws NoSuchElementException {
        for (RangeLong r : this) {
            long nb = r.max - r.min + 1L;
            if (index >= nb) {
                index -= nb;
                continue;
            }
            long value = r.min + index;
            this.removeValue(value);
            return value;
        }
        throw new NoSuchElementException();
    }

    public void addCopy(Collection<RangeLong> col) {
        for (RangeLong r : col) {
            this.addRange(r.min, r.max);
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("{");
        boolean first = true;
        for (RangeLong r : this) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append("[").append(r.min).append("-").append(r.max).append("]");
        }
        s.append("}");
        return s.toString();
    }

    public static class Parser
    implements StringParser<FragmentedRangeLong> {
        @Override
        public FragmentedRangeLong parse(String string) throws ParseException {
            return new FragmentedRangeLong(string);
        }
    }
}

