/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log.appenders;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.util.LimitAsyncOperations;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;
import net.lecousin.framework.util.StringUtil;

public class RollingFileAppender
implements Appender,
Closeable {
    private LoggerFactory factory;
    private File file;
    private FileIO.WriteOnly output = null;
    private long maxSize;
    private int maxFiles;
    private LogPattern pattern;
    private Logger.Level level;
    private boolean closed = false;
    private LimitAsyncOperations<FileLogOperation, Void, Exception> opStack = new LimitAsyncOperations<FileLogOperation, Void, Exception>(100, new LimitAsyncOperations.Executor<FileLogOperation, Void, Exception>(){

        @Override
        public AsyncWork<Void, Exception> execute(FileLogOperation data) {
            return data.execute();
        }
    });
    private boolean first = true;

    public RollingFileAppender(LoggerFactory factory, String path, Logger.Level level, LogPattern pattern, long maxSize, int maxFiles) {
        this.factory = factory;
        this.file = new File(path);
        this.level = level;
        this.pattern = pattern;
        this.maxSize = maxSize;
        this.maxFiles = maxFiles;
        factory.getApplication().toClose(this);
    }

    public RollingFileAppender(LoggerFactory factory, XMLStreamReader reader, Map<String, Appender> appenders) throws Exception {
        this.factory = factory;
        String level = null;
        String pattern = null;
        String path = null;
        String size = null;
        String files = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            if ("level".equals(attrName)) {
                level = attrValue;
                continue;
            }
            if ("pattern".equals(attrName)) {
                pattern = attrValue;
                continue;
            }
            if ("path".equals(attrName)) {
                path = attrValue;
                continue;
            }
            if ("size".equals(attrName)) {
                size = attrValue;
                continue;
            }
            if ("files".equals(attrName)) {
                files = attrValue;
                continue;
            }
            if ("name".equals(attrName) || "class".equals(attrName)) continue;
            throw new Exception("Unknown attribute " + attrName);
        }
        if (level == null) {
            throw new Exception("Missing attribute level on rolling file Appender");
        }
        try {
            this.level = Logger.Level.valueOf(level);
        }
        catch (Throwable t) {
            throw new Exception("Invalid level " + level);
        }
        if (pattern == null) {
            throw new Exception("Missing attribute pattern on rolling file Appender");
        }
        this.pattern = new LogPattern(pattern);
        if (path == null) {
            throw new Exception("Missing attribute path on rolling file Appender");
        }
        this.file = new File(path);
        if (size == null) {
            throw new Exception("Missing attribute size on rolling file Appender");
        }
        try {
            this.maxSize = StringUtil.parseSize(size);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid rolling file size: " + size);
        }
        if (this.maxSize <= 0L) {
            throw new Exception("Invalid rolling file size: " + size);
        }
        if (files == null) {
            throw new Exception("Missing attribute files on rolling file Appender");
        }
        try {
            this.maxFiles = Integer.parseInt(files);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid maximum number of rolling files: " + files);
        }
        if (this.maxFiles <= 0) {
            throw new Exception("Invalid maximum number of rolling files: " + files);
        }
        reader.next();
        while (reader.getEventType() != 2) {
            if (reader.getEventType() == 1) {
                throw new Exception("Unexpected inner element " + reader.getLocalName());
            }
            reader.next();
            if (reader.hasNext()) continue;
        }
        factory.getApplication().toClose(this);
    }

    @Override
    public synchronized void append(LogPattern.Log log) {
        if (this.closed) {
            return;
        }
        try {
            if (this.first) {
                this.opStack.write(new OpenLogFile());
                this.first = false;
            }
            StringBuilder msg = this.pattern.generate(log);
            msg.append('\n');
            this.opStack.write(new AppendLog(ByteBuffer.wrap(msg.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            this.factory.getApplication().getConsole().err(new Exception("Error logging in file " + this.file.getAbsolutePath(), e));
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.output = null;
        }
    }

    @Override
    public int level() {
        return this.level.ordinal();
    }

    @Override
    public boolean needsThreadName() {
        return this.pattern.needsThreadName();
    }

    @Override
    public boolean needsLocation() {
        return this.pattern.needsLocation();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        if (!this.first) {
            try {
                this.opStack.flush().blockThrow(0L);
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Exception e) {
                throw IO.error(e);
            }
            this.output = null;
            this.first = true;
        }
    }

    @Override
    public ISynchronizationPoint<Exception> flush() {
        return this.opStack.flush();
    }

    private Void error(String message, Throwable cause, AsyncWork<Void, Exception> result) {
        Exception error = new Exception(message, cause);
        this.factory.getApplication().getConsole().err(error);
        result.error(error);
        return null;
    }

    private class AppendLog
    implements FileLogOperation {
        private ByteBuffer log;

        public AppendLog(ByteBuffer log) {
            this.log = log;
        }

        @Override
        public AsyncWork<Void, Exception> execute() {
            long fileSize;
            final AsyncWork<Void, Exception> result = new AsyncWork<Void, Exception>();
            try {
                fileSize = RollingFileAppender.this.output.getSizeSync();
            }
            catch (Exception e) {
                result.error(e);
                return result;
            }
            if (fileSize >= RollingFileAppender.this.maxSize) {
                RollingFileAppender.this.output.closeAsync().listenAsync(new Task.OnFile<Void, NoException>(RollingFileAppender.this.file, "Roll log file", 5){

                    @Override
                    public Void run() {
                        File dir = RollingFileAppender.this.file.getParentFile();
                        File f = new File(dir, RollingFileAppender.this.file.getName() + '.' + RollingFileAppender.this.maxFiles);
                        if (f.exists() && !f.delete()) {
                            return RollingFileAppender.this.error("Unable to remove log file " + f.getAbsolutePath(), null, result);
                        }
                        for (int i = RollingFileAppender.this.maxFiles - 1; i >= 1; --i) {
                            f = new File(dir, RollingFileAppender.this.file.getName() + '.' + i);
                            if (!f.exists() || f.renameTo(new File(dir, RollingFileAppender.this.file.getName() + '.' + (i + 1)))) continue;
                            return RollingFileAppender.this.error("Unable to rename log file " + f.getAbsolutePath(), null, result);
                        }
                        f = new File(dir, RollingFileAppender.this.file.getName() + ".1");
                        if (!RollingFileAppender.this.file.renameTo(f)) {
                            return RollingFileAppender.this.error("Cannot rename log file from " + RollingFileAppender.this.file.getAbsolutePath() + " to " + f.getAbsolutePath(), null, result);
                        }
                        try {
                            if (!RollingFileAppender.this.file.createNewFile()) {
                                return RollingFileAppender.this.error("Cannot create log file: " + RollingFileAppender.this.file.getAbsolutePath(), null, result);
                            }
                        }
                        catch (Throwable t) {
                            return RollingFileAppender.this.error("Cannot create log file: " + RollingFileAppender.this.file.getAbsolutePath(), t, result);
                        }
                        RollingFileAppender.this.output = new FileIO.WriteOnly(RollingFileAppender.this.file, 5);
                        RollingFileAppender.this.output.writeAsync(AppendLog.this.log).listenInlineSP(() -> result.unblockSuccess(null), result);
                        return null;
                    }
                }, result);
                return result;
            }
            RollingFileAppender.this.output.writeAsync(this.log).listenInlineSP(() -> result.unblockSuccess(null), result);
            return result;
        }
    }

    private class OpenLogFile
    implements FileLogOperation {
        private OpenLogFile() {
        }

        @Override
        public AsyncWork<Void, Exception> execute() {
            final AsyncWork<Void, Exception> result = new AsyncWork<Void, Exception>();
            new Task.OnFile<Void, NoException>(RollingFileAppender.this.file, "Open log file", 5){

                @Override
                public Void run() {
                    if (!RollingFileAppender.this.file.exists()) {
                        File dir = RollingFileAppender.this.file.getParentFile();
                        if (!dir.exists() && !dir.mkdirs()) {
                            return RollingFileAppender.this.error("Cannot create log directory: " + dir.getAbsolutePath(), null, result);
                        }
                        try {
                            if (!RollingFileAppender.this.file.createNewFile()) {
                                return RollingFileAppender.this.error("Cannot create log file: " + RollingFileAppender.this.file.getAbsolutePath(), null, result);
                            }
                        }
                        catch (Exception e) {
                            return RollingFileAppender.this.error("Cannot create log file: " + RollingFileAppender.this.file.getAbsolutePath(), e, result);
                        }
                    }
                    RollingFileAppender.this.output = new FileIO.WriteOnly(RollingFileAppender.this.file, 5);
                    RollingFileAppender.this.output.seekAsync(IO.Seekable.SeekType.FROM_END, 0L).listenInlineSP(() -> RollingFileAppender.this.output.writeAsync(ByteBuffer.wrap(("\nStart logging with max size = " + RollingFileAppender.this.maxSize + " and max files = " + RollingFileAppender.this.maxFiles + "\n\n").getBytes(StandardCharsets.UTF_8))).listenInlineSP(() -> result.unblockSuccess(null), result), result);
                    return null;
                }
            }.start();
            return result;
        }
    }

    private static interface FileLogOperation {
        public AsyncWork<Void, Exception> execute();
    }
}

