/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log;

import net.lecousin.framework.application.Application;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.appenders.Appender;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.Pair;

class LoggerThread {
    private Thread thread;
    private TurnArray<Pair<Appender, LogPattern.Log>> logs = new TurnArray(200);
    private boolean stop = false;
    private SynchronizationPoint<Exception> flushing = null;

    LoggerThread(final Application app) {
        final SynchronizationPoint stopped = new SynchronizationPoint();
        this.thread = app.getThreadFactory().newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Pair log;
                    TurnArray turnArray = LoggerThread.this.logs;
                    synchronized (turnArray) {
                        log = (Pair)LoggerThread.this.logs.pollFirst();
                        if (log == null) {
                            if (LoggerThread.this.flushing != null) {
                                LoggerThread.this.flushing.unblock();
                                LoggerThread.this.flushing = null;
                            }
                            if (LoggerThread.this.stop) {
                                break;
                            }
                            try {
                                LoggerThread.this.logs.wait();
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                    }
                    try {
                        ((Appender)log.getValue1()).append((LogPattern.Log)log.getValue2());
                    }
                    catch (Throwable t) {
                        app.getConsole().err("Error in log appender " + log.getValue1() + ": " + t.getMessage());
                        app.getConsole().err(t);
                    }
                }
                System.out.println("Logger Thread stopped.");
                stopped.unblock();
            }
        });
        this.thread.setName("Logger for " + app.getGroupId() + "." + app.getArtifactId() + " " + app.getVersion().toString());
        if (app.isStopping()) {
            return;
        }
        this.thread.start();
        app.toClose(new AsyncCloseable<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISynchronizationPoint<Exception> closeAsync() {
                LoggerThread.this.stop = true;
                TurnArray turnArray = LoggerThread.this.logs;
                synchronized (turnArray) {
                    LoggerThread.this.logs.notify();
                }
                return stopped;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(Appender appender, LogPattern.Log log) {
        Pair<Appender, LogPattern.Log> p = new Pair<Appender, LogPattern.Log>(appender, log);
        TurnArray<Pair<Appender, LogPattern.Log>> turnArray = this.logs;
        synchronized (turnArray) {
            this.logs.addLast(p);
            this.logs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISynchronizationPoint<Exception> flush() {
        TurnArray<Pair<Appender, LogPattern.Log>> turnArray = this.logs;
        synchronized (turnArray) {
            if (this.flushing != null) {
                return this.flushing;
            }
            this.flushing = new SynchronizationPoint();
            this.logs.notify();
            return this.flushing;
        }
    }
}

