/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.collections.ArrayUtil;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromPathUsingClassloader;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.io.text.PropertiesReader;
import net.lecousin.framework.locale.ILocalizableString;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.ClassUtil;
import net.lecousin.framework.util.ObjectUtil;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLException;

public class LocalizedProperties
implements IMemoryManageable {
    private Logger logger;
    private Map<String, Namespace> namespaces = new HashMap<String, Namespace>();

    public LocalizedProperties(Application application) {
        this.logger = application.getLoggerFactory().getLogger(LocalizedProperties.class);
        MemoryManager.register(this);
        this.registerNamespaceFrom(LocalizedProperties.class, "b", "b");
        this.registerNamespaceFrom(LocalizedProperties.class, "languages", "languages");
        this.registerNamespaceFrom(XMLException.class, "lc.xml.error", "error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISynchronizationPoint<Exception> registerNamespace(String namespace, String path, ClassLoader classLoader) {
        IO.Readable input;
        Namespace ns;
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            ns = this.namespaces.get(namespace);
            if (ns == null) {
                ns = new Namespace();
                ns.loading = sp;
                this.namespaces.put(namespace, ns);
            } else {
                ns.loading.cancel(new CancelException("Namespace overriden"));
                ns.loading = sp;
                Namespace.access$202(ns, null);
            }
        }
        ns.classLoader = classLoader;
        ns.path = path;
        IOProvider.Readable provider = new IOProviderFromPathUsingClassloader(classLoader).get(path + ".languages");
        try {
            input = provider == null ? null : provider.provideIOReadable((byte)3);
        }
        catch (IOException e) {
            sp.error(new Exception("Localized properties for namespace " + namespace + " cannot be loaded because the file " + path + ".languages does not exist", e));
            this.logger.error(((Throwable)sp.getError()).getMessage());
            return sp;
        }
        if (input == null) {
            sp.error(new Exception("Localized properties for namespace " + namespace + " cannot be loaded because the file " + path + ".languages does not exist"));
            this.logger.error(sp.getError().getMessage());
            return sp;
        }
        AsyncWork<UnprotectedStringBuffer, IOException> read = IOUtil.readFullyAsString(input, StandardCharsets.US_ASCII, (byte)3);
        Namespace toLoad = ns;
        read.listenAsyncSP(new Task.Cpu.FromRunnable("Read localized properties namespace file", 3, () -> {
            LinkedList<Namespace.Language> languages = new LinkedList<Namespace.Language>();
            UnprotectedStringBuffer str = (UnprotectedStringBuffer)read.getResult();
            for (UnprotectedStringBuffer s : str.split(',')) {
                s.trim().toLowerCase();
                if (s.length() == 0) continue;
                Namespace.Language l = new Namespace.Language();
                List list = s.split('-');
                Namespace.Language.access$502(l, new String[list.size()]);
                int i = 0;
                for (UnprotectedStringBuffer us : list) {
                    ((Namespace.Language)l).tag[i++] = us.asString();
                }
                languages.add(l);
            }
            languages.sort(new Comparator<Namespace.Language>(){

                @Override
                public int compare(Namespace.Language l1, Namespace.Language l2) {
                    int i = 0;
                    while (i != l1.tag.length) {
                        if (i == l2.tag.length) {
                            return -1;
                        }
                        int c = l1.tag[i].compareTo(l2.tag[i]);
                        if (c != 0) {
                            return c;
                        }
                        ++i;
                    }
                    return 1;
                }
            });
            Namespace.access$202(toLoad, languages.toArray(new Namespace.Language[languages.size()]));
            block2: for (int i = 0; i < toLoad.languages.length; ++i) {
                int nbI = toLoad.languages[i].tag.length;
                for (int j = i + 1; j < toLoad.languages.length; ++j) {
                    int nbJ = toLoad.languages[j].tag.length;
                    if (nbJ >= nbI) continue;
                    if (!ArrayUtil.equals(toLoad.languages[i].tag, 0, toLoad.languages[j].tag, 0, nbJ)) continue block2;
                    toLoad.languages[i].parent = toLoad.languages[j];
                    continue block2;
                }
            }
            sp.unblock();
            this.logger.info("Namespace " + namespace + " loaded with " + languages.size() + " languages from " + path);
        }), sp);
        sp.listenInline(() -> input.closeAsync());
        sp.onError(error -> this.logger.error("Error loading localized properties namespace file " + path + ".languages", (Throwable)error));
        return sp;
    }

    public ISynchronizationPoint<Exception> registerNamespaceFrom(Class<?> cl, String namespace, String subPath) {
        return this.registerNamespace(namespace, ClassUtil.getPackageName(cl).replace('.', '/') + '/' + subPath, cl.getClassLoader());
    }

    public Set<String> getDeclaredNamespaces() {
        return this.namespaces.keySet();
    }

    private void load(Namespace ns, final Namespace.Language lang) {
        IO.Readable input;
        String path = ns.path + '.' + String.join((CharSequence)"-", lang.tag);
        IOProvider.Readable provider = new IOProviderFromPathUsingClassloader(ns.classLoader).get(path);
        try {
            input = provider != null ? provider.provideIOReadable((byte)3) : null;
        }
        catch (IOException e) {
            lang.loading.error(new Exception("Localized properties file " + path + " does not exist", e));
            this.logger.error(((Throwable)lang.loading.getError()).getMessage());
            return;
        }
        if (input == null) {
            lang.loading.error(new Exception("Localized properties file " + path + " does not exist"));
            this.logger.error(((Throwable)lang.loading.getError()).getMessage());
            return;
        }
        if (!(input instanceof IO.Readable.Buffered)) {
            input = new PreBufferedReadable(input, 4096, 3, 4096, 3, 16);
        }
        IO.Readable.Buffered in = (IO.Readable.Buffered)input;
        BufferedReadableCharacterStream cs = new BufferedReadableCharacterStream((IO.Readable)in, StandardCharsets.UTF_8, 3000, 16);
        lang.properties = new HashMap();
        PropertiesReader<Map<String, String>> reader = new PropertiesReader<Map<String, String>>("Localized properties " + path, (ICharacterStream.Readable.Buffered)cs, 3, IO.OperationType.ASYNCHRONOUS){

            @Override
            protected void processProperty(UnprotectedStringBuffer key, UnprotectedStringBuffer value) {
                lang.properties.put(key.asString(), value.asString());
            }

            @Override
            protected Map<String, String> generateResult() {
                return lang.properties;
            }
        };
        reader.start().listenInline(lang.loading);
    }

    public String localizeSync(String[] languageTag, String namespace, String key, Object ... values) {
        try {
            return this.localize(languageTag, namespace, key, values).blockResult(0L);
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncWork<String, NoException> localize(final String[] languageTag, final String namespace, final String key, final Object ... values) {
        Namespace ns;
        final AsyncWork<String, NoException> result = new AsyncWork<String, NoException>();
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            ns = this.namespaces.get(namespace);
        }
        if (ns == null) {
            result.unblockSuccess("!! unknown namespace " + namespace + " !!");
            return result;
        }
        ns.loading.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ns.loading.hasError()) {
                    result.unblockSuccess("!! error loading namespace " + namespace + " !!");
                    return;
                }
                if (!ns.loading.isUnblocked()) {
                    ns.loading.listenInline(this);
                    return;
                }
                for (Namespace.Language l : ns.languages) {
                    if (!LocalizedProperties.languageTagCompatible(l.tag, languageTag)) continue;
                    LocalizedProperties.this.localize(ns, l, key, values, result);
                    return;
                }
                result.unblockSuccess("!! no compatible language in namespace " + namespace + "!!");
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localize(final Namespace ns, final Namespace.Language lang, final String key, final Object[] values, final AsyncWork<String, NoException> result) {
        boolean needsLoading = false;
        Namespace.Language language = lang;
        synchronized (language) {
            if (lang.loading == null) {
                lang.loading = new SynchronizationPoint();
                needsLoading = true;
            }
        }
        lang.loading.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Namespace.Language language = lang;
                synchronized (language) {
                    String content = null;
                    if (!lang.loading.hasError()) {
                        content = (String)lang.properties.get(key.toLowerCase());
                    }
                    if (content != null) {
                        LocalizedProperties.localize(lang.tag, key, content, values, result);
                        lang.lastUsage = System.currentTimeMillis();
                        return;
                    }
                }
                if (lang.parent != null) {
                    LocalizedProperties.this.localize(ns, lang.parent, key, values, result);
                } else {
                    result.unblockSuccess("!! missing key " + key + " !!");
                }
            }
        });
        if (needsLoading) {
            this.load(ns, lang);
        }
    }

    private static void localize(String[] languageTag, String key, String content, Object[] values, AsyncWork<String, NoException> result) {
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof ILocalizableString)) continue;
            AsyncWork<String, NoException> l = ((ILocalizableString)values[i]).localize(languageTag);
            Object[] newValues = new Object[values.length];
            System.arraycopy(values, 0, newValues, 0, values.length);
            int ii = i;
            l.listenAsync(new Task.Cpu.FromRunnable(() -> {
                newValues[ii] = l.getResult();
                LocalizedProperties.localize(languageTag, key, content, newValues, result);
            }, "Localization", 4), true);
            return;
        }
        result.unblockSuccess(LocalizedProperties.setCase(LocalizedProperties.replaceValues(content, values), key));
    }

    private static String replaceValues(String s, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            s = s.replace("{" + i + "}", ObjectUtil.toString(values[i]));
        }
        return s;
    }

    private static String setCase(String text, String key) {
        if (Character.isUpperCase(key.charAt(0))) {
            text = Character.toUpperCase(text.charAt(0)) + text.substring(1);
        }
        return text;
    }

    private static boolean languageTagCompatible(String[] tag, String[] requested) {
        if (tag.length > requested.length) {
            return false;
        }
        return ArrayUtil.equals(tag, 0, requested, 0, tag.length);
    }

    @Override
    public String getDescription() {
        return "Localized properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getItemsDescription() {
        ArrayList<String> items = new ArrayList<String>(this.namespaces.size());
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            for (String ns : this.namespaces.keySet()) {
                int loaded = 0;
                Namespace n = this.namespaces.get(ns);
                for (Namespace.Language lang : n.languages) {
                    if (lang.loading == null) continue;
                    ++loaded;
                }
                items.add("Localized properties for namespace " + ns + " (" + loaded + " language(s) loaded)");
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        long maxIdle;
        switch (level) {
            default: {
                maxIdle = 600000L;
                break;
            }
            case LOW: {
                maxIdle = 120000L;
                break;
            }
            case MEDIUM: {
                maxIdle = 45000L;
                break;
            }
            case URGENT: {
                maxIdle = 5000L;
            }
        }
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            for (Namespace ns : this.namespaces.values()) {
                if (ns.languages == null) continue;
                Namespace.Language[] languageArray = ns.languages;
                int n = languageArray.length;
                for (int i = 0; i < n; ++i) {
                    Namespace.Language lang;
                    Namespace.Language language = lang = languageArray[i];
                    synchronized (language) {
                        if (lang.loading == null) {
                            continue;
                        }
                        if (!lang.loading.isUnblocked()) {
                            continue;
                        }
                        if (lang.properties != null && System.currentTimeMillis() - lang.lastUsage > maxIdle) {
                            lang.loading = null;
                            lang.properties = null;
                            lang.lastUsage = 0L;
                        }
                        continue;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAvailableLanguageCodes() {
        LinkedList<String> avail = new LinkedList<String>();
        boolean first = true;
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            for (Namespace ns : this.namespaces.values()) {
                if (ns.languages == null) continue;
                LinkedList<String> found = new LinkedList<String>();
                for (Namespace.Language l : ns.languages) {
                    String tag = String.join((CharSequence)"-", l.tag);
                    if (first) {
                        avail.add(tag);
                        continue;
                    }
                    found.add(tag);
                }
                if (first) {
                    first = false;
                    continue;
                }
                Iterator it = avail.iterator();
                while (it.hasNext()) {
                    if (found.contains(it.next())) continue;
                    it.remove();
                }
            }
        }
        return avail;
    }

    public Set<String> getNamespaceLanguages(String namespace) {
        HashSet<String> list = new HashSet<String>();
        Namespace ns = this.namespaces.get(namespace);
        if (ns != null && ns.languages != null) {
            for (Namespace.Language l : ns.languages) {
                list.add(String.join((CharSequence)"-", l.tag));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncWork<Map<String, String>, Exception> getNamespaceContent(final String namespace, final String[] languageTag) {
        Namespace ns;
        final AsyncWork<Map<String, String>, Exception> result = new AsyncWork<Map<String, String>, Exception>();
        Map<String, Namespace> map = this.namespaces;
        synchronized (map) {
            ns = this.namespaces.get(namespace);
        }
        if (ns == null) {
            result.error(new Exception("Unknown namespace " + namespace));
            return result;
        }
        ns.loading.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!ns.loading.isUnblocked()) {
                    ns.loading.listenInline(this, result);
                    return;
                }
                for (final Namespace.Language l : ns.languages) {
                    if (!ArrayUtil.equals(l.tag, languageTag)) continue;
                    boolean needsLoading = false;
                    Namespace.Language language = l;
                    synchronized (language) {
                        if (l.loading == null) {
                            l.loading = new SynchronizationPoint();
                            needsLoading = true;
                        }
                    }
                    l.loading.listenInline(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Namespace.Language language = l;
                            synchronized (language) {
                                result.unblockSuccess(new HashMap(l.properties));
                            }
                        }
                    }, result);
                    if (needsLoading) {
                        LocalizedProperties.this.load(ns, l);
                    }
                    return;
                }
                result.error(new Exception("Language not found in namespace " + namespace));
            }
        }, result);
        return result;
    }

    private static class Namespace {
        private ClassLoader classLoader;
        private String path;
        private ISynchronizationPoint<Exception> loading;
        private Language[] languages;

        private Namespace() {
        }

        static /* synthetic */ Language[] access$202(Namespace x0, Language[] x1) {
            x0.languages = x1;
            return x1;
        }

        private static class Language {
            private String[] tag;
            private Language parent = null;
            private Map<String, String> properties = null;
            private SynchronizationPoint<Exception> loading = null;
            private long lastUsage = 0L;

            private Language() {
            }

            static /* synthetic */ String[] access$502(Language x0, String[] x1) {
                x0.tag = x1;
                return x1;
            }
        }
    }
}

