/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale;

import java.nio.charset.StandardCharsets;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.locale.LoadLibraryLocaleFile;
import net.lecousin.framework.plugins.CustomExtensionPoint;

public class LocaleExtensionPoint
implements CustomExtensionPoint {
    @Override
    public String getPluginConfigurationFilePath() {
        return "META-INF/net.lecousin/locale";
    }

    @Override
    public boolean keepAfterInit() {
        return false;
    }

    @Override
    public <T extends ClassLoader> ISynchronizationPoint<Exception> loadPluginConfiguration(final IO.Readable io, final T classLoader, ISynchronizationPoint<?> ... startOn) {
        final SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        Task.Cpu<Void, Exception> task = new Task.Cpu<Void, Exception>("Loading locale file", 4){

            @Override
            public Void run() {
                BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream(io, StandardCharsets.UTF_8, 256, 32);
                LoadLibraryLocaleFile load = new LoadLibraryLocaleFile(stream, classLoader);
                load.start().listenInline(sp);
                return null;
            }
        };
        task.startOn(false, startOn);
        return sp;
    }
}

