/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale;

import java.util.ArrayList;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.locale.ILocalizableString;

public class CompositeLocalizable
implements ILocalizableString {
    private String sep;
    private ILocalizableString[] elements;

    public CompositeLocalizable(String sep, ILocalizableString ... elements) {
        this.sep = sep;
        this.elements = elements;
    }

    @Override
    public AsyncWork<String, NoException> localize(String[] languageTag) {
        JoinPoint jp = new JoinPoint();
        final ArrayList<AsyncWork<String, NoException>> list = new ArrayList<AsyncWork<String, NoException>>(this.elements.length);
        for (ILocalizableString s : this.elements) {
            AsyncWork<String, NoException> l = s.localize(languageTag);
            jp.addToJoin(l);
            list.add(l);
        }
        final AsyncWork<String, NoException> result = new AsyncWork<String, NoException>();
        jp.start();
        jp.listenInline(new Runnable(){

            @Override
            public void run() {
                StringBuffer s = new StringBuffer();
                for (AsyncWork es : list) {
                    if (s.length() > 0) {
                        s.append(CompositeLocalizable.this.sep);
                    }
                    s.append((String)es.getResult());
                }
                result.unblockSuccess(s.toString());
            }
        });
        return result;
    }

    @Override
    public String localizeSync(String[] languageTag) {
        StringBuffer s = new StringBuffer();
        for (ILocalizableString ls : this.elements) {
            if (s.length() > 0) {
                s.append(this.sep);
            }
            s.append(ls.localizeSync(languageTag));
        }
        return s.toString();
    }
}

