/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.util.production.simple.Producer;
import net.lecousin.framework.concurrent.util.production.simple.Production;
import net.lecousin.framework.io.IO;

public class IOReaderAsProducer
implements Producer<ByteBuffer> {
    private IO.Readable io;
    private int bufferSize;
    private AsyncWork<Integer, IOException> read = null;

    public IOReaderAsProducer(IO.Readable io, int bufferSize) {
        this.io = io;
        this.bufferSize = bufferSize;
    }

    @Override
    public AsyncWork<ByteBuffer, IOException> produce(final Production<ByteBuffer> production) {
        final AsyncWork<ByteBuffer, IOException> sp = new AsyncWork<ByteBuffer, IOException>();
        final ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize);
        this.read = this.io.readFullyAsync(buffer);
        this.read.listenInline(new AsyncWork.AsyncWorkListener<Integer, IOException>(){

            @Override
            public void ready(Integer result) {
                IOReaderAsProducer.this.read = null;
                if (result <= 0) {
                    sp.unblockSuccess(null);
                    return;
                }
                if (buffer.hasRemaining()) {
                    production.endOfProduction();
                }
                buffer.flip();
                sp.unblockSuccess(buffer);
            }

            @Override
            public void cancelled(CancelException event) {
                IOReaderAsProducer.this.read = null;
                sp.unblockCancel(event);
            }

            @Override
            public void error(IOException error) {
                IOReaderAsProducer.this.read = null;
                sp.unblockError(error);
            }
        });
        return sp;
    }

    @Override
    public void cancel(CancelException event) {
        AsyncWork<Integer, IOException> r = this.read;
        if (r != null) {
            r.unblockCancel(event);
        }
    }
}

