/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.nio.ByteBuffer;
import net.lecousin.framework.collections.TurnArray;

public class Buffers {
    private int bufferSize;
    private TurnArray<ByteBuffer> buffers;

    public Buffers(int bufferSize, int maxBuffersToKeep) {
        this.bufferSize = bufferSize;
        this.buffers = new TurnArray(maxBuffersToKeep);
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buf = this.buffers.pollFirst();
        if (buf != null) {
            buf.clear();
            return buf;
        }
        return ByteBuffer.wrap(new byte[this.bufferSize]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeBuffer(ByteBuffer buf) {
        TurnArray<ByteBuffer> turnArray = this.buffers;
        synchronized (turnArray) {
            if (this.buffers.isFull()) {
                return;
            }
            this.buffers.addLast(buf);
        }
    }
}

