/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.FullReadLines;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public abstract class PropertiesReader<T>
extends FullReadLines<T> {
    private char commentChar;

    public PropertiesReader(char commentChar, String description, ICharacterStream.Readable.Buffered stream, byte priority, IO.OperationType closeStreamAtEnd) {
        super(description, stream, priority, closeStreamAtEnd);
        this.commentChar = commentChar;
    }

    public PropertiesReader(String description, ICharacterStream.Readable.Buffered stream, byte priority, IO.OperationType closeStreamAtEnd) {
        this('#', description, stream, priority, closeStreamAtEnd);
    }

    @Override
    protected void processLine(UnprotectedStringBuffer line) {
        if (line.length() == 0) {
            return;
        }
        if (line.charAt(0) == this.commentChar) {
            return;
        }
        int i = line.indexOf('=');
        if (i < 0) {
            return;
        }
        UnprotectedStringBuffer key = line.substring(0, i);
        key.trim();
        UnprotectedStringBuffer value = line.substring(i + 1);
        value.trim();
        this.processProperty(key, value);
    }

    protected abstract void processProperty(UnprotectedStringBuffer var1, UnprotectedStringBuffer var2);
}

