/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.util.List;
import java.util.ListIterator;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.util.Provider;

public class TypeFactory<T>
implements SerializationRule {
    private Class<T> type;
    private Provider<T> factory;

    public TypeFactory(Class<T> type, Provider<T> factory) {
        this.type = type;
        this.factory = factory;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Provider<T> getFactory() {
        return this.factory;
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) {
        ListIterator<SerializationClass.Attribute> it = type.getAttributes().listIterator();
        while (it.hasNext()) {
            SerializationClass.Attribute a = it.next();
            if (!a.getType().getBase().equals(this.type)) continue;
            it.set(new SerializationClass.Attribute(a){

                @Override
                public Object instantiate(SerializationContext.AttributeContext context) {
                    return TypeFactory.this.factory.provide();
                }

                @Override
                public boolean hasCustomInstantiation() {
                    return true;
                }
            });
        }
        return false;
    }

    @Override
    public boolean canInstantiate(TypeDefinition type, SerializationContext context) {
        return this.type.equals(type.getBase());
    }

    @Override
    public Object instantiate(TypeDefinition type, SerializationContext context) {
        return this.factory.provide();
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof TypeFactory)) {
            return false;
        }
        TypeFactory r = (TypeFactory)rule;
        return r.type.equals(this.type);
    }
}

