/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.util.List;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.util.Factory;

public class AttributeInstantiation
implements SerializationRule {
    private SerializationContextPattern.OnClassAttribute pattern;
    private Class<? extends Factory> factory;

    public AttributeInstantiation(SerializationContextPattern.OnClassAttribute pattern, Class<? extends Factory> factory) {
        this.pattern = pattern;
        this.factory = factory;
    }

    public AttributeInstantiation(Class<?> clazz, String name, Class<? extends Factory> factory) {
        this(new SerializationContextPattern.OnClassAttribute(clazz, name), factory);
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) throws Exception {
        SerializationClass.Attribute a = this.pattern.getAttribute(type, context);
        if (a == null) {
            return false;
        }
        try {
            type.replaceAttribute(a, new InstantiationAttribute(a, this.factory.newInstance()));
            return false;
        }
        catch (Throwable t) {
            throw new Exception("Unable to replace attribute by an InstantiationAttribute", t);
        }
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof AttributeInstantiation)) {
            return false;
        }
        AttributeInstantiation r = (AttributeInstantiation)rule;
        return r.pattern.isEquivalent(this.pattern);
    }

    private static class InstantiationAttribute
    extends SerializationClass.Attribute {
        private Factory factory;

        public InstantiationAttribute(SerializationClass.Attribute a, Factory factory) {
            super(a);
            this.factory = factory;
        }

        @Override
        public Object instantiate(SerializationContext.AttributeContext context) {
            return this.factory.create(context);
        }

        @Override
        public boolean hasCustomInstantiation() {
            return true;
        }
    }
}

