/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.encoding;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.SimpleBufferedReadable;
import net.lecousin.framework.io.text.ICharacterStream;

public final class Base64 {
    private Base64() {
    }

    public static int decode4BytesBase64(byte[] inputBuffer, byte[] outputBuffer) throws IOException {
        return Base64.decode4BytesBase64(inputBuffer, 0, outputBuffer, 0);
    }

    public static int decode4BytesBase64(byte[] inputBuffer, byte[] outputBuffer, int outputOffset) throws IOException {
        return Base64.decode4BytesBase64(inputBuffer, 0, outputBuffer, outputOffset);
    }

    public static int decode4BytesBase64(byte[] inputBuffer, int inputOffset, byte[] outputBuffer, int outputOffset) throws IOException {
        int v1 = Base64.decodeBase64Char(inputBuffer[inputOffset]);
        int v2 = Base64.decodeBase64Char(inputBuffer[inputOffset + 1]);
        int v3 = Base64.decodeBase64Char(inputBuffer[inputOffset + 2]);
        outputBuffer[outputOffset] = (byte)(v1 << 2 | v2 >>> 4);
        if (v3 == 64) {
            return 1;
        }
        int v4 = Base64.decodeBase64Char(inputBuffer[inputOffset + 3]);
        outputBuffer[outputOffset + 1] = (byte)((v2 & 0xF) << 4 | v3 >>> 2);
        if (v4 == 64) {
            return 2;
        }
        outputBuffer[outputOffset + 2] = (byte)((v3 & 3) << 6 | v4);
        return 3;
    }

    public static int decode4BytesBase64(ByteBuffer inputBuffer, byte[] outputBuffer, int outputOffset) throws IOException {
        int v1 = Base64.decodeBase64Char(inputBuffer.get());
        int v2 = Base64.decodeBase64Char(inputBuffer.get());
        int v3 = Base64.decodeBase64Char(inputBuffer.get());
        outputBuffer[outputOffset] = (byte)(v1 << 2 | v2 >>> 4);
        if (v3 == 64) {
            return 1;
        }
        int v4 = Base64.decodeBase64Char(inputBuffer.get());
        outputBuffer[outputOffset + 1] = (byte)((v2 & 0xF) << 4 | v3 >>> 2);
        if (v4 == 64) {
            return 2;
        }
        outputBuffer[outputOffset + 2] = (byte)((v3 & 3) << 6 | v4);
        return 3;
    }

    public static int decode4BytesBase64(CharBuffer inputBuffer, byte[] outputBuffer, int outputOffset) throws IOException {
        int v1 = Base64.decodeBase64Char((byte)inputBuffer.get());
        int v2 = Base64.decodeBase64Char((byte)inputBuffer.get());
        int v3 = Base64.decodeBase64Char((byte)inputBuffer.get());
        outputBuffer[outputOffset] = (byte)(v1 << 2 | v2 >>> 4);
        if (v3 == 64) {
            if (inputBuffer.hasRemaining() && inputBuffer.get() != '=') {
                throw new IOException("Unexpected character at the end of the base 64 input buffer");
            }
            return 1;
        }
        int v4 = Base64.decodeBase64Char((byte)inputBuffer.get());
        outputBuffer[outputOffset + 1] = (byte)((v2 & 0xF) << 4 | v3 >>> 2);
        if (v4 == 64) {
            return 2;
        }
        outputBuffer[outputOffset + 2] = (byte)((v3 & 3) << 6 | v4);
        return 3;
    }

    public static int decodeBase64Char(byte b) throws IOException {
        if (b >= 65 && b <= 90) {
            return b - 65;
        }
        if (b >= 97 && b <= 122) {
            return b - 97 + 26;
        }
        if (b >= 48 && b <= 57) {
            return b - 48 + 52;
        }
        if (b == 43) {
            return 62;
        }
        if (b == 47) {
            return 63;
        }
        if (b == 61) {
            return 64;
        }
        throw new IOException("Invalid Base64 character to decode: " + b);
    }

    public static byte[] decode(byte[] input) throws IOException {
        int l = input.length;
        if (l % 4 != 0) {
            l = l / 4 * 4;
        }
        if (l == 0) {
            return new byte[0];
        }
        int outLen = l * 3 / 4;
        if (input[l - 1] == 61) {
            outLen = input[l - 2] == 61 ? (outLen -= 2) : --outLen;
        }
        byte[] decoded = new byte[outLen];
        int pos = 0;
        int i = 0;
        while (i < l) {
            Base64.decode4BytesBase64(input, i, decoded, pos);
            i += 4;
            pos += 3;
        }
        return decoded;
    }

    public static byte[] decode(byte[] input, int offset, int length) throws IOException {
        int l = length;
        if (l % 4 != 0) {
            l = l / 4 * 4;
        }
        if (l == 0) {
            return new byte[0];
        }
        int outLen = l * 3 / 4;
        if (input[offset + l - 1] == 61) {
            outLen = input[offset + l - 2] == 61 ? (outLen -= 2) : --outLen;
        }
        byte[] decoded = new byte[outLen];
        int pos = 0;
        int i = 0;
        while (i < l) {
            Base64.decode4BytesBase64(input, i + offset, decoded, pos);
            i += 4;
            pos += 3;
        }
        return decoded;
    }

    public static byte[] decode(ByteBuffer input) throws IOException {
        int l = input.remaining();
        if (l % 4 != 0) {
            l = l / 4 * 4;
        }
        if (l == 0) {
            return new byte[0];
        }
        int outLen = l * 3 / 4;
        int p = input.position();
        if (input.get(p + l - 1) == 61) {
            outLen = input.get(p + l - 2) == 61 ? (outLen -= 2) : --outLen;
        }
        byte[] decoded = new byte[outLen];
        int pos = 0;
        int i = 0;
        while (i < l) {
            Base64.decode4BytesBase64(input, decoded, pos);
            i += 4;
            pos += 3;
        }
        return decoded;
    }

    public static byte[] decode(CharBuffer input) throws IOException {
        int l = input.remaining();
        if (l % 4 != 0) {
            l = l / 4 * 4;
        }
        if (l == 0) {
            return new byte[0];
        }
        int outLen = l * 3 / 4;
        int p = input.position();
        if (input.get(p + l - 1) == '=') {
            outLen = input.get(p + l - 2) == '=' ? (outLen -= 2) : --outLen;
        }
        byte[] decoded = new byte[outLen];
        int pos = 0;
        int i = 0;
        while (i < l) {
            Base64.decode4BytesBase64(input, decoded, pos);
            i += 4;
            pos += 3;
        }
        return decoded;
    }

    public static byte[] decode(String input) throws IOException {
        return Base64.decode(input.getBytes(StandardCharsets.US_ASCII));
    }

    public static void encode3BytesBase64(byte[] inputBuffer, int inputBufferOffset, byte[] outputBuffer, int outputBufferOffset) {
        try {
            outputBuffer[outputBufferOffset + 0] = Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 0xFC) >> 2);
            outputBuffer[outputBufferOffset + 1] = Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 3) << 4 | (inputBuffer[inputBufferOffset + 1] & 0xF0) >> 4);
            outputBuffer[outputBufferOffset + 2] = Base64.encodeBase64((inputBuffer[inputBufferOffset + 1] & 0xF) << 2 | (inputBuffer[inputBufferOffset + 2] & 0xC0) >> 6);
            outputBuffer[outputBufferOffset + 3] = Base64.encodeBase64(inputBuffer[inputBufferOffset + 2] & 0x3F);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void encode3BytesBase64(byte[] inputBuffer, int inputBufferOffset, char[] outputBuffer, int outputBufferOffset) {
        try {
            outputBuffer[outputBufferOffset + 0] = (char)Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 0xFC) >> 2);
            outputBuffer[outputBufferOffset + 1] = (char)Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 3) << 4 | (inputBuffer[inputBufferOffset + 1] & 0xF0) >> 4);
            outputBuffer[outputBufferOffset + 2] = (char)Base64.encodeBase64((inputBuffer[inputBufferOffset + 1] & 0xF) << 2 | (inputBuffer[inputBufferOffset + 2] & 0xC0) >> 6);
            outputBuffer[outputBufferOffset + 3] = (char)Base64.encodeBase64(inputBuffer[inputBufferOffset + 2] & 0x3F);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void encodeUpTo3BytesBase64(byte[] inputBuffer, int inputBufferOffset, byte[] outputBuffer, int outputBufferOffset, int nbInput) {
        try {
            outputBuffer[outputBufferOffset + 0] = Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 0xFC) >> 2);
            if (nbInput == 1) {
                outputBuffer[outputBufferOffset + 1] = Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 3) << 4);
                outputBuffer[outputBufferOffset + 2] = 61;
                outputBuffer[outputBufferOffset + 3] = 61;
            } else {
                outputBuffer[outputBufferOffset + 1] = Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 3) << 4 | (inputBuffer[inputBufferOffset + 1] & 0xF0) >> 4);
                if (nbInput == 2) {
                    outputBuffer[outputBufferOffset + 2] = Base64.encodeBase64((inputBuffer[inputBufferOffset + 1] & 0xF) << 2);
                    outputBuffer[outputBufferOffset + 3] = 61;
                } else {
                    outputBuffer[outputBufferOffset + 2] = Base64.encodeBase64((inputBuffer[inputBufferOffset + 1] & 0xF) << 2 | (inputBuffer[inputBufferOffset + 2] & 0xC0) >> 6);
                    outputBuffer[outputBufferOffset + 3] = Base64.encodeBase64(inputBuffer[inputBufferOffset + 2] & 0x3F);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void encodeUpTo3BytesBase64(byte[] inputBuffer, int inputBufferOffset, char[] outputBuffer, int outputBufferOffset, int nbInput) {
        try {
            outputBuffer[outputBufferOffset + 0] = (char)Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 0xFC) >> 2);
            if (nbInput == 1) {
                outputBuffer[outputBufferOffset + 1] = (char)Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 3) << 4);
                outputBuffer[outputBufferOffset + 2] = 61;
                outputBuffer[outputBufferOffset + 3] = 61;
            } else {
                outputBuffer[outputBufferOffset + 1] = (char)Base64.encodeBase64((inputBuffer[inputBufferOffset + 0] & 3) << 4 | (inputBuffer[inputBufferOffset + 1] & 0xF0) >> 4);
                if (nbInput == 2) {
                    outputBuffer[outputBufferOffset + 2] = (char)Base64.encodeBase64((inputBuffer[inputBufferOffset + 1] & 0xF) << 2);
                    outputBuffer[outputBufferOffset + 3] = 61;
                } else {
                    outputBuffer[outputBufferOffset + 2] = (char)Base64.encodeBase64((inputBuffer[inputBufferOffset + 1] & 0xF) << 2 | (inputBuffer[inputBufferOffset + 2] & 0xC0) >> 6);
                    outputBuffer[outputBufferOffset + 3] = (char)Base64.encodeBase64(inputBuffer[inputBufferOffset + 2] & 0x3F);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte encodeBase64(int v) throws IOException {
        if (v <= 25) {
            return (byte)(v + 65);
        }
        if (v <= 51) {
            return (byte)(v - 26 + 97);
        }
        if (v <= 61) {
            return (byte)(v - 52 + 48);
        }
        if (v == 62) {
            return 43;
        }
        if (v == 63) {
            return 47;
        }
        throw new IOException("Invalid Base64 value to encode: " + v);
    }

    public static byte[] encodeBase64(byte[] input) {
        return Base64.encodeBase64(input, 0, input.length);
    }

    public static byte[] encodeBase64(byte[] input, int offset, int len) {
        int nb = len / 3;
        if (len % 3 > 0) {
            ++nb;
        }
        byte[] output = new byte[nb *= 4];
        int pos = 0;
        while (len >= 3) {
            Base64.encode3BytesBase64(input, offset, output, pos);
            offset += 3;
            len -= 3;
            pos += 4;
        }
        if (len > 0) {
            Base64.encodeUpTo3BytesBase64(input, offset, output, pos, len);
        }
        return output;
    }

    public static char[] encodeBase64ToChars(byte[] input, int offset, int len) {
        int nb = len / 3;
        if (len % 3 > 0) {
            ++nb;
        }
        char[] output = new char[nb *= 4];
        int pos = 0;
        while (len >= 3) {
            Base64.encode3BytesBase64(input, offset, output, pos);
            offset += 3;
            len -= 3;
            pos += 4;
        }
        if (len > 0) {
            Base64.encodeUpTo3BytesBase64(input, offset, output, pos, len - offset);
        }
        return output;
    }

    public static ISynchronizationPoint<IOException> encodeAsync(IO.Readable io, IO.WriterAsync writer) {
        return Base64.encodeAsync(io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new SimpleBufferedReadable(io, 8192), writer);
    }

    public static ISynchronizationPoint<IOException> encodeAsync(IO.Readable.Buffered io, IO.WriterAsync writer) {
        SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        Base64.encodeAsyncNextBuffer(io, writer, result, new byte[3], 0, null);
        return result;
    }

    public static ISynchronizationPoint<IOException> encodeAsync(IO.Readable io, ICharacterStream.WriterAsync writer) {
        return Base64.encodeAsync(io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new SimpleBufferedReadable(io, 8192), writer);
    }

    public static ISynchronizationPoint<IOException> encodeAsync(IO.Readable.Buffered io, ICharacterStream.WriterAsync writer) {
        SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        Base64.encodeAsyncNextBuffer(io, writer, result, new byte[3], 0, null);
        return result;
    }

    private static void encodeAsyncNextBuffer(IO.Readable.Buffered io, IO.WriterAsync writer, SynchronizationPoint<IOException> result, byte[] buf, int nbBuf, ISynchronizationPoint<IOException> lastWrite) {
        io.readNextBufferAsync().listenInline(buffer -> {
            if (buffer == null) {
                Base64.writeFinalBuffer(io, writer, result, buf, nbBuf, lastWrite);
            } else {
                Base64.writeBuffer(io, writer, result, buf, nbBuf, buffer, lastWrite);
            }
        }, result);
    }

    private static void encodeAsyncNextBuffer(IO.Readable.Buffered io, ICharacterStream.WriterAsync writer, SynchronizationPoint<IOException> result, byte[] buf, int nbBuf, ISynchronizationPoint<IOException> lastWrite) {
        io.readNextBufferAsync().listenInline(buffer -> {
            if (buffer == null) {
                Base64.writeFinalBuffer(io, writer, result, buf, nbBuf, lastWrite);
            } else {
                Base64.writeBuffer(io, writer, result, buf, nbBuf, buffer, lastWrite);
            }
        }, result);
    }

    private static void writeBuffer(final IO.Readable.Buffered io, final IO.WriterAsync writer, final SynchronizationPoint<IOException> result, final byte[] buf, final int nbBuf, final ByteBuffer buffer, final ISynchronizationPoint<IOException> lastWrite) {
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Encode base 64 stream", io.getPriority()){

            @Override
            public Void run() {
                AsyncWork<Integer, IOException> write;
                int l;
                int nb;
                if (lastWrite != null) {
                    if (lastWrite.hasError()) {
                        result.error(lastWrite.getError());
                        return null;
                    }
                    if (lastWrite.isCancelled()) {
                        result.cancel(lastWrite.getCancelEvent());
                        return null;
                    }
                }
                if ((nb = nbBuf) > 0) {
                    while (nb < 3 && buffer.hasRemaining()) {
                        buf[nb++] = buffer.get();
                    }
                    if (nb == 3) {
                        byte[] out = new byte[4];
                        Base64.encode3BytesBase64(buf, 0, out, 0);
                        Base64.writeBuffer(io, writer, (SynchronizationPoint<IOException>)result, buf, 0, buffer, (ISynchronizationPoint<IOException>)writer.writeAsync(ByteBuffer.wrap(out)));
                        return null;
                    }
                    if (nb < 3) {
                        Base64.encodeAsyncNextBuffer(io, writer, (SynchronizationPoint<IOException>)result, buf, nb, (ISynchronizationPoint<IOException>)lastWrite);
                        return null;
                    }
                }
                if ((l = buffer.remaining() / 3) > 0) {
                    byte[] out = Base64.encodeBase64(buffer.array(), buffer.arrayOffset() + buffer.position(), l * 3);
                    write = writer.writeAsync(ByteBuffer.wrap(out));
                    buffer.position(buffer.position() + l * 3);
                } else {
                    write = null;
                }
                nb = buffer.remaining();
                buffer.get(buf, 0, nb);
                Base64.encodeAsyncNextBuffer(io, writer, (SynchronizationPoint<IOException>)result, buf, nb, (ISynchronizationPoint<IOException>)write);
                return null;
            }
        };
        if (lastWrite == null || lastWrite.isUnblocked()) {
            task.start();
        } else {
            task.startOn(lastWrite, true);
        }
    }

    private static void writeBuffer(final IO.Readable.Buffered io, final ICharacterStream.WriterAsync writer, final SynchronizationPoint<IOException> result, final byte[] buf, final int nbBuf, final ByteBuffer buffer, final ISynchronizationPoint<IOException> lastWrite) {
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Encode base 64 stream", io.getPriority()){

            @Override
            public Void run() {
                ISynchronizationPoint<IOException> write;
                int l;
                int nb;
                if (lastWrite != null) {
                    if (lastWrite.hasError()) {
                        result.error(lastWrite.getError());
                        return null;
                    }
                    if (lastWrite.isCancelled()) {
                        result.cancel(lastWrite.getCancelEvent());
                        return null;
                    }
                }
                if ((nb = nbBuf) > 0) {
                    while (nb < 3 && buffer.hasRemaining()) {
                        buf[nb++] = buffer.get();
                    }
                    if (nb == 3) {
                        char[] out = new char[4];
                        Base64.encode3BytesBase64(buf, 0, out, 0);
                        Base64.writeBuffer(io, writer, (SynchronizationPoint<IOException>)result, buf, 0, buffer, (ISynchronizationPoint<IOException>)writer.writeAsync(out, 0, 4));
                        return null;
                    }
                    if (nb < 3) {
                        Base64.encodeAsyncNextBuffer(io, writer, (SynchronizationPoint<IOException>)result, buf, nb, (ISynchronizationPoint<IOException>)lastWrite);
                        return null;
                    }
                }
                if ((l = buffer.remaining() / 3) > 0) {
                    char[] out = Base64.encodeBase64ToChars(buffer.array(), buffer.arrayOffset() + buffer.position(), l * 3);
                    write = writer.writeAsync(out);
                    buffer.position(buffer.position() + l * 3);
                } else {
                    write = null;
                }
                nb = buffer.remaining();
                buffer.get(buf, 0, nb);
                Base64.encodeAsyncNextBuffer(io, writer, (SynchronizationPoint<IOException>)result, buf, nb, (ISynchronizationPoint<IOException>)write);
                return null;
            }
        };
        if (lastWrite == null || lastWrite.isUnblocked()) {
            task.start();
        } else {
            task.startOn(lastWrite, true);
        }
    }

    private static void writeFinalBuffer(IO.Readable.Buffered io, final IO.WriterAsync writer, final SynchronizationPoint<IOException> result, final byte[] buf, final int nbBuf, final ISynchronizationPoint<IOException> lastWrite) {
        if (nbBuf == 0) {
            if (lastWrite == null || lastWrite.isUnblocked()) {
                result.unblock();
            } else {
                lastWrite.listenInline(result);
            }
            return;
        }
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Encode base 64 stream", io.getPriority()){

            @Override
            public Void run() {
                if (lastWrite != null) {
                    if (lastWrite.hasError()) {
                        result.error(lastWrite.getError());
                        return null;
                    }
                    if (lastWrite.isCancelled()) {
                        result.cancel(lastWrite.getCancelEvent());
                        return null;
                    }
                }
                byte[] out = new byte[4];
                Base64.encodeUpTo3BytesBase64(buf, 0, out, 0, nbBuf);
                writer.writeAsync(ByteBuffer.wrap(out)).listenInline(result);
                return null;
            }
        };
        if (lastWrite == null || lastWrite.isUnblocked()) {
            task.start();
        } else {
            task.startOn(lastWrite, true);
        }
    }

    private static void writeFinalBuffer(IO.Readable.Buffered io, final ICharacterStream.WriterAsync writer, final SynchronizationPoint<IOException> result, final byte[] buf, final int nbBuf, final ISynchronizationPoint<IOException> lastWrite) {
        if (nbBuf == 0) {
            if (lastWrite == null || lastWrite.isUnblocked()) {
                result.unblock();
            } else {
                lastWrite.listenInline(result);
            }
            return;
        }
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Encode base 64 stream", io.getPriority()){

            @Override
            public Void run() {
                if (lastWrite != null) {
                    if (lastWrite.hasError()) {
                        result.error(lastWrite.getError());
                        return null;
                    }
                    if (lastWrite.isCancelled()) {
                        result.cancel(lastWrite.getCancelEvent());
                        return null;
                    }
                }
                char[] out = new char[4];
                Base64.encodeUpTo3BytesBase64(buf, 0, out, 0, nbBuf);
                writer.writeAsync(out, 0, 4).listenInline(result);
                return null;
            }
        };
        if (lastWrite == null || lastWrite.isUnblocked()) {
            task.start();
        } else {
            task.startOn(lastWrite, true);
        }
    }
}

