/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.ListenableLongProperty;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public abstract class PositionKnownWrapper<IOType extends IO>
extends ConcurrentCloseable
implements IO.PositionKnown {
    protected IOType io;
    protected ListenableLongProperty position;

    public PositionKnownWrapper(IOType io, long position) {
        this.io = io;
        this.position = new ListenableLongProperty(position);
    }

    public void addPositionChangedListener(Listener<Long> listener) {
        this.position.addListener(listener);
    }

    public void addPositionChangedListener(Runnable listener) {
        this.position.addListener(listener);
    }

    public void removePositionChangedListener(Listener<Long> listener) {
        this.position.removeListener(listener);
    }

    public void removePositionChangedListener(Runnable listener) {
        this.position.removeListener(listener);
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public long getPosition() {
        return this.position.get();
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.io = null;
        ondone.unblock();
    }

    protected ISynchronizationPoint<IOException> canStartReading() {
        return ((IO.Readable)this.io).canStartReading();
    }

    protected int readSync(ByteBuffer buffer) throws IOException {
        int nb = ((IO.Readable)this.io).readSync(buffer);
        if (nb > 0) {
            this.position.add(nb);
        }
        return nb;
    }

    protected int readAsync() throws IOException {
        int c = ((IO.Readable.Buffered)this.io).readAsync();
        if (c >= 0) {
            this.position.inc();
        }
        return c;
    }

    protected AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return ((IO.Readable)this.io).readAsync(buffer, result -> {
            Integer nb = (Integer)result.getValue1();
            if (nb != null && nb > 0) {
                this.position.add(nb.longValue());
            }
            if (ondone != null) {
                ondone.run((Pair<Integer, IOException>)result);
            }
        });
    }

    protected int readFullySync(ByteBuffer buffer) throws IOException {
        int nb = ((IO.Readable)this.io).readFullySync(buffer);
        if (nb > 0) {
            this.position.add(nb);
        }
        return nb;
    }

    protected AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return ((IO.Readable)this.io).readFullyAsync(buffer, result -> {
            Integer nb = (Integer)result.getValue1();
            if (nb != null && nb > 0) {
                this.position.add(nb.intValue());
            }
            if (ondone != null) {
                ondone.run((Pair<Integer, IOException>)result);
            }
        });
    }

    protected long skipSync(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long skipped = ((IO.Readable)this.io).skipSync(n);
        this.position.add(skipped);
        return skipped;
    }

    protected AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        if (n <= 0L) {
            return IOUtil.success(0L, ondone);
        }
        return ((IO.Readable)this.io).skipAsync(n, result -> {
            Long nb = (Long)result.getValue1();
            if (nb != null) {
                this.position.add(nb);
            }
            if (ondone != null) {
                ondone.run(result);
            }
        });
    }

    protected int read() throws IOException {
        int c = ((IO.Readable.Buffered)this.io).read();
        if (c >= 0) {
            this.position.inc();
        }
        return c;
    }

    protected int read(byte[] buffer, int offset, int len) throws IOException {
        int nb = ((IO.Readable.Buffered)this.io).read(buffer, offset, len);
        if (nb > 0) {
            this.position.add(nb);
        }
        return nb;
    }

    protected int readFully(byte[] buffer) throws IOException {
        int nb = ((IO.Readable.Buffered)this.io).readFully(buffer);
        if (nb > 0) {
            this.position.add(nb);
        }
        return nb;
    }

    protected int skip(int skip) throws IOException {
        int skipped = ((IO.Readable.Buffered)this.io).skip(skip);
        this.position.add(skipped);
        return skipped;
    }

    protected AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        return ((IO.Readable.Buffered)this.io).readNextBufferAsync(result -> {
            ByteBuffer buf = (ByteBuffer)result.getValue1();
            if (buf != null) {
                this.position.add(buf.remaining());
            }
            if (ondone != null) {
                ondone.run((Pair<ByteBuffer, IOException>)result);
            }
        });
    }

    protected AsyncWork<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> res = new AsyncWork<Integer, IOException>();
        ((IO.Readable.Buffered)this.io).readFullySyncIfPossible(buffer, r -> {
            if (r.getValue1() != null) {
                this.position.add(((Integer)r.getValue1()).intValue());
            }
            if (ondone == null) {
                return;
            }
            ondone.run((Pair<Integer, IOException>)r);
        }).listenInline(nb -> res.unblockSuccess((Integer)nb), res);
        return res;
    }

    public static class Readable
    extends PositionKnownWrapper<IO.Readable>
    implements IO.Readable,
    IO.PositionKnown {
        public Readable(IO.Readable io, long position) {
            super(io, position);
        }

        public Readable(IO.Readable io) {
            this(io, 0L);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return super.canStartReading();
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public long skipSync(long n) throws IOException {
            return super.skipSync(n);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }

        public static class Buffered
        extends PositionKnownWrapper<IO.Readable.Buffered>
        implements IO.Readable.Buffered,
        IO.PositionKnown {
            public Buffered(IO.Readable.Buffered io, long position) {
                super(io, position);
            }

            public Buffered(IO.Readable.Buffered io) {
                this(io, 0L);
            }

            @Override
            public ISynchronizationPoint<IOException> canStartReading() {
                return super.canStartReading();
            }

            @Override
            public int readSync(ByteBuffer buffer) throws IOException {
                return super.readSync(buffer);
            }

            @Override
            public int readAsync() throws IOException {
                return super.readAsync();
            }

            @Override
            public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return super.readAsync(buffer, ondone);
            }

            @Override
            public int readFullySync(ByteBuffer buffer) throws IOException {
                return super.readFullySync(buffer);
            }

            @Override
            public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return super.readFullyAsync(buffer, ondone);
            }

            @Override
            public long skipSync(long n) throws IOException {
                return super.skipSync(n);
            }

            @Override
            public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
                return super.skipAsync(n, ondone);
            }

            @Override
            public int read() throws IOException {
                return super.read();
            }

            @Override
            public int read(byte[] buffer, int offset, int len) throws IOException {
                return super.read(buffer, offset, len);
            }

            @Override
            public int readFully(byte[] buffer) throws IOException {
                return super.readFully(buffer);
            }

            @Override
            public int skip(int skip) throws IOException {
                return super.skip(skip);
            }

            @Override
            public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
                return super.readNextBufferAsync(ondone);
            }

            @Override
            public AsyncWork<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return super.readFullySyncIfPossible(buffer, ondone);
            }
        }
    }
}

