/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;

public class IOWritePool {
    private IO.Writable io;
    private LinkedList<ByteBuffer> buffers = new LinkedList();
    private AsyncWork<Integer, IOException> writing = null;
    private AsyncWork.AsyncWorkListener<Integer, IOException> listener = new Listener();
    private SynchronizationPoint<IOException> waitDone = null;

    public IOWritePool(IO.Writable io) {
        this.io = io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer buffer) throws IOException {
        LinkedList<ByteBuffer> linkedList = this.buffers;
        synchronized (linkedList) {
            if (this.writing == null) {
                this.writing = this.io.writeAsync(buffer);
                this.writing.listenInline(this.listener);
                return;
            }
            if (this.writing.hasError()) {
                throw this.writing.getError();
            }
            this.buffers.add(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationPoint<IOException> onDone() {
        LinkedList<ByteBuffer> linkedList = this.buffers;
        synchronized (linkedList) {
            if (this.writing == null) {
                return new SynchronizationPoint<boolean>(true);
            }
            if (this.writing.hasError()) {
                return new SynchronizationPoint<IOException>(this.writing.getError());
            }
            if (this.writing.isCancelled()) {
                return new SynchronizationPoint<IOException>(this.writing.getCancelEvent());
            }
            if (this.waitDone == null) {
                this.waitDone = new SynchronizationPoint();
            }
        }
        return this.waitDone;
    }

    private class Listener
    implements AsyncWork.AsyncWorkListener<Integer, IOException> {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ready(Integer result) {
            LinkedList linkedList = IOWritePool.this.buffers;
            synchronized (linkedList) {
                if (!IOWritePool.this.buffers.isEmpty()) {
                    IOWritePool.this.writing = IOWritePool.this.io.writeAsync((ByteBuffer)IOWritePool.this.buffers.removeFirst());
                    IOWritePool.this.writing.listenInline(IOWritePool.this.listener);
                    return;
                }
                IOWritePool.this.writing = null;
                if (IOWritePool.this.waitDone != null) {
                    IOWritePool.this.waitDone.unblock();
                }
            }
        }

        @Override
        public void error(IOException error) {
            if (IOWritePool.this.waitDone != null) {
                IOWritePool.this.waitDone.error(error);
            }
        }

        @Override
        public void cancelled(CancelException event) {
            if (IOWritePool.this.waitDone != null) {
                IOWritePool.this.waitDone.cancel(event);
            }
        }
    }
}

