/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.buffering.BufferedToInputStream;

public class IOAsInputStream
extends InputStream {
    private IO.Readable io;
    private long mark = -1L;
    private byte[] b = new byte[1];
    private ByteBuffer bb = ByteBuffer.wrap(this.b);

    public static InputStream get(IO.Readable io, boolean closeAsync) {
        if (io instanceof IOFromInputStream) {
            return ((IOFromInputStream)io).getInputStream();
        }
        if (io instanceof IO.Readable.Buffered) {
            return new BufferedToInputStream((IO.Readable.Buffered)io, closeAsync);
        }
        return new IOAsInputStream(io);
    }

    private IOAsInputStream(IO.Readable io) {
        this.io = io;
    }

    @Override
    public void close() throws IOException {
        try {
            this.io.close();
        }
        catch (Exception e) {
            throw IO.error(e);
        }
    }

    @Override
    public int available() {
        return 1;
    }

    @Override
    public boolean markSupported() {
        return this.io instanceof IO.Seekable;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = ((IO.Seekable)((Object)this.io)).getPosition();
        }
        catch (IOException e) {
            this.mark = -1L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("No mark in InputStream");
        }
        ((IO.Seekable)((Object)this.io)).seekSync(IO.Seekable.SeekType.FROM_BEGINNING, this.mark);
    }

    @Override
    public int read() throws IOException {
        this.bb.clear();
        if (this.io.readSync(this.bb) <= 0) {
            return -1;
        }
        return this.b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        int nb = this.io.readSync(buffer);
        if (nb == 0 && len > 0) {
            return -1;
        }
        return nb;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.io.skipSync(n);
    }
}

