/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.event;

import java.util.ArrayList;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.event.Listenable;
import net.lecousin.framework.event.Listener;

public class Event<T>
implements Listenable<T> {
    private ArrayList<Listener<T>> listeners = null;
    private ArrayList<Runnable> listenersRunnable = null;

    @Override
    public synchronized void addListener(Listener<T> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(5);
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void addListener(Runnable listener) {
        if (this.listenersRunnable == null) {
            this.listenersRunnable = new ArrayList(5);
        }
        this.listenersRunnable.add(listener);
    }

    @Override
    public synchronized void removeListener(Listener<T> listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    @Override
    public synchronized void removeListener(Runnable listener) {
        if (this.listenersRunnable == null) {
            return;
        }
        this.listenersRunnable.remove(listener);
        if (this.listenersRunnable.isEmpty()) {
            this.listenersRunnable = null;
        }
    }

    @Override
    public boolean hasListeners() {
        return this.listeners != null || this.listenersRunnable != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(T event) {
        ArrayList<Runnable> list2;
        ArrayList<Listener<T>> list1;
        Event event2 = this;
        synchronized (event2) {
            list1 = this.listeners == null ? null : new ArrayList<Listener<T>>(this.listeners);
            list2 = this.listenersRunnable == null ? null : new ArrayList<Runnable>(this.listenersRunnable);
        }
        if (list1 != null) {
            for (int i = 0; i < list1.size(); ++i) {
                try {
                    list1.get(i).fire(event);
                    continue;
                }
                catch (Throwable t) {
                    LCCore.getApplication().getDefaultLogger().error("Event listener error: " + list1.get(i), t);
                }
            }
        }
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                try {
                    list2.get(i).run();
                    continue;
                }
                catch (Throwable t) {
                    LCCore.getApplication().getDefaultLogger().error("Event listener error: " + list2.get(i), t);
                }
            }
        }
    }

    public static <T> Listener<T> createListenerToFire(final Event<T> event) {
        return new Listener<T>(){

            @Override
            public void fire(T obj) {
                event.fire(obj);
            }
        };
    }
}

