/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.util.production.simple;

import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.util.production.simple.Consumer;

public abstract class ProductTransformation<Input, Output>
implements Consumer<Input> {
    private Consumer<Output> consumer;
    private AsyncWork<?, ? extends Exception> consuming = null;
    private Output waitingData = null;
    private CancelException cancelled = null;
    private Exception error = null;
    private AsyncWork<?, ? extends Exception> endReached = null;

    public ProductTransformation(Consumer<Output> consumer) {
        this.consumer = consumer;
    }

    @Override
    public AsyncWork<?, ? extends Exception> consume(Input product) {
        final AsyncWork sp = new AsyncWork();
        if (this.error != null) {
            sp.unblockError(this.error);
            return sp;
        }
        if (this.cancelled != null) {
            sp.unblockCancel(this.cancelled);
            return sp;
        }
        AsyncWork<Output, Exception> processing = this.process(product);
        processing.listenInline(new AsyncWork.AsyncWorkListener<Output, Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ready(Output result) {
                Consumer consumer = ProductTransformation.this.consumer;
                synchronized (consumer) {
                    if (ProductTransformation.this.error != null) {
                        sp.unblockError(ProductTransformation.this.error);
                        return;
                    }
                    if (ProductTransformation.this.cancelled != null) {
                        sp.unblockCancel(ProductTransformation.this.cancelled);
                        return;
                    }
                    if (ProductTransformation.this.consuming == null) {
                        ProductTransformation.this.consumeTransformed(result, sp);
                    } else {
                        ProductTransformation.this.waitingData = result;
                    }
                }
            }

            @Override
            public void cancelled(CancelException event) {
                ProductTransformation.this.cancel(event);
                sp.unblockCancel(event);
            }

            @Override
            public void error(Exception error) {
                ProductTransformation.this.error(error);
                sp.unblockError(error);
            }
        });
        return sp;
    }

    protected abstract AsyncWork<Output, Exception> process(Input var1);

    private void consumeTransformed(Output data, final AsyncWork<Void, Exception> sp) {
        this.consuming = this.consumer.consume(data);
        sp.unblockSuccess(null);
        this.consuming.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Consumer consumer = ProductTransformation.this.consumer;
                synchronized (consumer) {
                    if (ProductTransformation.this.error != null) {
                        sp.unblockError(ProductTransformation.this.error);
                        return;
                    }
                    if (ProductTransformation.this.cancelled != null) {
                        sp.unblockCancel(ProductTransformation.this.cancelled);
                        return;
                    }
                    if (!ProductTransformation.this.consuming.isSuccessful()) {
                        if (ProductTransformation.this.consuming.isCancelled()) {
                            ProductTransformation.this.cancel(ProductTransformation.this.consuming.getCancelEvent());
                        } else {
                            ProductTransformation.this.error((Exception)ProductTransformation.this.consuming.getError());
                        }
                        ProductTransformation.this.consuming = null;
                        return;
                    }
                    ProductTransformation.this.consuming = null;
                    if (ProductTransformation.this.waitingData != null) {
                        ProductTransformation.this.consumeTransformed(ProductTransformation.this.waitingData, sp);
                        ProductTransformation.this.waitingData = null;
                    } else if (ProductTransformation.this.endReached != null) {
                        ProductTransformation.this.consumer.endOfProduction().listenInline(new Runnable(){

                            @Override
                            public void run() {
                                ProductTransformation.this.endReached.unblockSuccess(null);
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void cancel(CancelException event) {
        this.cancelled = event;
    }

    @Override
    public void error(Exception error) {
        this.error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncWork<?, ? extends Exception> endOfProduction() {
        Consumer<Output> consumer = this.consumer;
        synchronized (consumer) {
            if (this.consuming == null) {
                return this.consumer.endOfProduction();
            }
            this.endReached = new AsyncWork();
            return this.endReached;
        }
    }
}

