/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.util;

import java.io.IOException;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.Pair;

public class LimitAsyncOperations<InputType, OutputResultType, OutputErrorType extends Exception> {
    private Executor<InputType, OutputResultType, OutputErrorType> executor;
    private TurnArray<Pair<InputType, AsyncWork<OutputResultType, OutputErrorType>>> waiting;
    private SynchronizationPoint<NoException> lock = null;
    private AsyncWork<OutputResultType, OutputErrorType> lastWrite = new AsyncWork<Object, Object>(null, null);
    private CancelException cancelled = null;
    private OutputErrorType error = null;
    private boolean isReady = true;

    public LimitAsyncOperations(int maxOperations, Executor<InputType, OutputResultType, OutputErrorType> executor) {
        this.waiting = new TurnArray(maxOperations);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncWork<OutputResultType, OutputErrorType> write(InputType data) throws IOException {
        while (true) {
            SynchronizationPoint<NoException> lk;
            TurnArray<Pair<InputType, AsyncWork<OutputResultType, OutputErrorType>>> turnArray = this.waiting;
            synchronized (turnArray) {
                if (this.error != null) {
                    return new AsyncWork<Object, OutputErrorType>(null, this.error);
                }
                if (this.cancelled != null) {
                    return new AsyncWork<Object, Object>(null, null, this.cancelled);
                }
                if (this.isReady) {
                    this.isReady = false;
                    this.lastWrite = this.executor.execute(data);
                    AsyncWork<OutputResultType, OutputErrorType> op = this.lastWrite;
                    this.lastWrite.listenInline(new WriteListener(data, op, null));
                    return op;
                }
                if (!this.waiting.isFull()) {
                    AsyncWork op = new AsyncWork();
                    this.waiting.addLast(new Pair(data, op));
                    this.lastWrite = op;
                    return op;
                }
                if (this.lock != null) {
                    throw new IOException("Concurrent write");
                }
                lk = this.lock = new SynchronizationPoint();
            }
            lk.block(0L);
        }
    }

    protected void writeDone(InputType data, AsyncWork<OutputResultType, OutputErrorType> result) {
    }

    public AsyncWork<OutputResultType, OutputErrorType> getLastPendingOperation() {
        return this.lastWrite.isUnblocked() ? null : this.lastWrite;
    }

    public ISynchronizationPoint<OutputErrorType> flush() {
        final SynchronizationPoint sp = new SynchronizationPoint();
        Runnable callback = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsyncWork last = null;
                TurnArray turnArray = LimitAsyncOperations.this.waiting;
                synchronized (turnArray) {
                    if (LimitAsyncOperations.this.error != null) {
                        sp.error(LimitAsyncOperations.this.error);
                    } else if (LimitAsyncOperations.this.cancelled != null) {
                        sp.cancel(LimitAsyncOperations.this.cancelled);
                    } else if (LimitAsyncOperations.this.isReady) {
                        sp.unblock();
                    } else {
                        last = LimitAsyncOperations.this.lastWrite;
                    }
                }
                if (last != null) {
                    last.listenInline(this);
                }
            }
        };
        callback.run();
        return sp;
    }

    private class WriteListener
    implements Runnable {
        private InputType data;
        private AsyncWork<OutputResultType, OutputErrorType> op;
        private AsyncWork<OutputResultType, OutputErrorType> result;

        public WriteListener(InputType data, AsyncWork<OutputResultType, OutputErrorType> op, AsyncWork<OutputResultType, OutputErrorType> result) {
            this.data = data;
            this.op = op;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SynchronizationPoint lk = null;
            TurnArray turnArray = LimitAsyncOperations.this.waiting;
            synchronized (turnArray) {
                if (LimitAsyncOperations.this.lock != null) {
                    lk = LimitAsyncOperations.this.lock;
                    LimitAsyncOperations.this.lock = null;
                }
                if (this.op.hasError()) {
                    LimitAsyncOperations.this.error = this.op.getError();
                } else if (this.op.isCancelled()) {
                    LimitAsyncOperations.this.cancelled = this.op.getCancelEvent();
                } else {
                    Pair b = (Pair)LimitAsyncOperations.this.waiting.pollFirst();
                    if (b != null) {
                        AsyncWork newOp = LimitAsyncOperations.this.executor.execute(b.getValue1());
                        LimitAsyncOperations.this.lastWrite = newOp;
                        newOp.listenInline(new WriteListener(b.getValue1(), newOp, (AsyncWork)b.getValue2()));
                    } else {
                        LimitAsyncOperations.this.isReady = true;
                    }
                }
            }
            if (this.result != null) {
                this.op.listenInline(this.result);
            }
            if (lk != null) {
                lk.unblock();
            }
            LimitAsyncOperations.this.writeDone(this.data, this.op);
        }
    }

    public static interface Executor<InputType, OutputResultType, OutputErrorType extends Exception> {
        public AsyncWork<OutputResultType, OutputErrorType> execute(InputType var1);
    }
}

